UNIT Unit11_extractor;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, StrUtils, ComCtrls;
TYPE
  TForm11 = Class(TForm)
    group_select: TGroupBox;
    panel_extension: TPanel;
    combo_extension: TComboBox;
    list: TListBox;
    group_extract: TGroupBox;
    group_singlefiles: TGroupBox;
    btn_sel_dat: TButton;
    btn_sel_datraw: TButton;
    btn_sel_datraw_convert: TButton;
    btn_all_dat: TButton;
    btn_all_datraw: TButton;
    btn_all_datraw_convert: TButton;
    group_onefile: TGroupBox;
    btn_sel_files_toone: TButton;
    btn_all_files_toone: TButton;
    group_progress: TGroupBox;
    progress: TProgressBar;
    Label1: TLabel;
    Label2: TLabel;
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
    PROCEDURE FormResize(Sender: TObject);
    PROCEDURE combo_extensionClick(Sender: TObject);
    PROCEDURE panel_extensionResize(Sender: TObject);
    PROCEDURE Extract(Sender: TObject);
  PRIVATE
  PUBLIC
    PROCEDURE Recreatelist;
  END;

VAR
  Form11: TForm11;

IMPLEMENTATION
{$R *.dfm}
USES Unit1_main, Unit2_functions, Unit3_data;

PROCEDURE TForm11.Recreatelist;
  VAR
    i:LongWord;
  BEGIN
    combo_extension.Items.Clear;
    combo_extension.Items.Add('_All files_ ('+IntToStr(dat_header.Files)+')');
    FOR i:=0 TO dat_header.Extensions-1 DO BEGIN
      WITH dat_extensionsmap[i] DO BEGIN
        combo_extension.Items.Add(
          Extension[3]+Extension[2]+Extension[1]+Extension[0]+' ('+
          IntToStr(ExtCount)+')');
      END;
    END;
    combo_extension.ItemIndex:=0;
    combo_extensionClick(Self);
  END;

PROCEDURE TForm11.panel_extensionResize(Sender: TObject);
  BEGIN
    combo_extension.Width:=panel_extension.Width-5;
  END;

PROCEDURE TForm11.combo_extensionClick(Sender: TObject);
  VAR
    Extension:String[4];
    i:LongWord;
  BEGIN
    Extension:=MidStr(combo_extension.Items.Strings[combo_extension.ItemIndex],1,4);
    list.Items.Clear;
    IF Extension='_All' THEN BEGIN
      FOR i:=0 TO dat_header.Files-1 DO
        IF (dat_files[i].FileType AND $02)=0 THEN
          list.Items.Add(dat_files[i].FileName);
    END ELSE BEGIN
      FOR i:=0 TO dat_header.Files-1 DO
        IF dat_files[i].Extension=Extension THEN
          IF (dat_files[i].FileType AND $02)=0 THEN
            list.Items.Add(dat_files[i].FileName);
    END;
  END;

PROCEDURE TForm11.FormResize(Sender: TObject);
  BEGIN
    IF Self.Width>=450 THEN BEGIN
    END ELSE Self.Width:=450;
    IF Self.Height>=400 THEN BEGIN
      group_progress.Height:=group_extract.Height-293;
    END ELSE Self.Height:=400;
  END;

PROCEDURE TForm11.FormClose(Sender: TObject; var Action: TCloseAction);
  BEGIN
    Action:=caFree;
    Form1.close_window(Self.Name);
  END;

PROCEDURE TForm11.FormActivate(Sender: TObject);
  BEGIN
    Form1.SetActiveWindow(Self.Name);
  END;

PROCEDURE TForm11.FormCreate(Sender: TObject);
  BEGIN
    btn_sel_dat.Caption:=           'Selected files'+CrLf+'(dat contents only)';
    btn_sel_datraw.Caption:=        'Selected files'+CrLf+'(dat+raw contents)';
    btn_sel_datraw_convert.Caption:='Selected files'+CrLf+'(dat+raw contents)'+CrLf+'(with convert if possible)';
    btn_all_dat.Caption:=           'All files in list'+CrLf+'(dat contents only)';
    btn_all_datraw.Caption:=        'All files in list'+CrLf+'(dat+raw contents)';
    btn_all_datraw_convert.Caption:='All files in list'+CrLf+'(dat+raw contents)'+CrLf+'(with convert if possible)';
    btn_sel_files_toone.Caption:=   'Selected files'+CrLf+'(dat contents only)';
    btn_all_files_toone.Caption:=   'All files in list'+CrLf+'(dat contents only)';
  END;

PROCEDURE TForm11.Extract(Sender: TObject);
  VAR
    sel_only:Boolean;
    dat_only:Boolean;
    convert:Boolean;
    one_file:Boolean;
    files:LongWord;
    i:LongWord;
    fs:TFileStream;
    ms:TMemoryStream;
  BEGIN
    sel_only:=Pos('sel',TButton(Sender).Name)>0;
    dat_only:=NOT (Pos('datraw',TButton(Sender).Name)>0);
    convert:=Pos('convert',TButton(Sender).Name)>0;
    one_file:=Pos('toone',TButton(Sender).Name)>0;

    IF sel_only THEN BEGIN
      files:=list.SelCount;
      FOR i:=0 TO list.Count-1 DO BEGIN
        IF list.Selected[i] THEN BEGIN
          BEGIN END;
        END;
      END;
    END ELSE BEGIN
    END; 
  END;

END.
