UNIT Unit9_data_structures;
INTERFACE
USES SysUtils;

TYPE
  Tstructure_entry=RECORD
      name:String;
      offset:LongWord;
      datatype:Word;  // 1..4: Integer[1..4] dec; 5..8: Integer[1..4] hex; 9: float; 10: bitset; 10000+: string[0+]
      description:String;
    END;
  Tstructure_info=RECORD
      extension:String;
      typedesc:String;
      entries:Array OF Tstructure_entry;
    END;
  Tstructures=Array OF Tstructure_info;

VAR
  structure_infos:Tstructures;


FUNCTION GetDataType(typeid:Word):String;
FUNCTION GetStructureInfoId(ext:String):Integer;
FUNCTION GetTypeDataLength(datatype:Word):Word;



IMPLEMENTATION

FUNCTION GetTypeDataLength(datatype:Word):Word;
  BEGIN
    CASE datatype OF
      1..4: Result:=datatype;
      5..8: Result:=datatype-4;
      9: Result:=4;
      10: Result:=1;
      10000..65535: Result:=datatype-10000;
    END;
  END;


FUNCTION GetStructureInfoId(ext:String):Integer;
  VAR
    i:Integer;
  BEGIN
    FOR i:=0 TO High(structure_infos) DO BEGIN
      IF structure_infos[i].extension=ext THEN BEGIN
        Result:=i;
        Exit;
      END;
    END;
    Result:=-1;
  END;


FUNCTION GetDataType(typeid:Word):String;
  BEGIN
    CASE typeid OF
      1..4: Result:='Int'+IntToStr(typeid*8);
      5..8: Result:='Int'+IntToStr((typeid-4)*8);
      9: Result:='Float';
      10: Result:='BitSet';
      10000..65535: Result:='String('+IntToStr(typeid-10000)+')';
    END;
  END;


PROCEDURE AddEntry(_ext:String; _name:String; _offset:LongWord; _datatype:Word; _description:String);
  VAR
    sid:Integer;
  BEGIN
    sid:=GetStructureInfoId(_ext);
    IF sid>=0 THEN BEGIN
      WITH structure_infos[sid] DO BEGIN
        SetLength(entries,Length(entries)+1);
        WITH entries[High(entries)] DO BEGIN
          name:=_name;
          offset:=_offset;
          datatype:=_datatype;
          description:=_description;
        END;
      END;
    END;
  END;


PROCEDURE AddExtension(_ext:String; _typedesc:String);
  BEGIN
    IF GetStructureInfoId(_ext)<0 THEN BEGIN
      SetLength(structure_infos,Length(structure_infos)+1);
      WITH structure_infos[High(structure_infos)] DO BEGIN
        extension:=_ext;
        typedesc:=_typedesc;
      END;
    END;
  END;


BEGIN
  AddExtension('TXMP','Texture');
  AddEntry('TXMP','ID',$00,4,'ID of this file');
  AddEntry('TXMP','LevelID',$04,8,'ID of the level this file is in');
  AddEntry('TXMP','FileName',$08,10128,'');
  AddEntry('TXMP','Fading',$88,10,'Fading-Bitset');
  AddEntry('TXMP','Depth',$89,10,'Depth-Bitset');
  AddEntry('TXMP','Width',$8C,2,'x-resolution of image');
  AddEntry('TXMP','Height',$8E,2,'y-resolution of image');
  AddEntry('TXMP','Storetype',$90,10,'Storetype-Bitset');
  AddEntry('TXMP','TXAN-Link',$94,8,'Link to the TXAN-file (if this TXMP is the first image of an animation)');
  AddEntry('TXMP','TXMP-Link',$98,8,'Link to another TXMP-file');
  AddEntry('TXMP','Raw-Link',$9C,8,'Address of the image data in the .raw-file');
END.
