unit TXAN;

interface

uses
  _FileTypes;

type
  TFile_TXAN = class(TFile)
    protected
      procedure InitDatLinks; override;
      procedure InitDataFields; override;
      procedure InitRawList; override;
  end;

implementation

uses
  ConnectionManager, Math, Classes, TypeDefs, _DataTypes;

procedure TFile_TXAN.InitDataFields;
var
  tempi: Integer;
  temps: String;
  templist: TStringList;
begin
  inherited;
  FDataFields := TBlock.Create(Self, nil, 0, 'Base', '', nil);
  templist := TStringList.Create;
  with FDataFields do
  begin
    AddField(TFileID, $00, 'FileID', '', nil);

    AddField(TLevelID, $04, 'LevelID', '', nil);

    tempi := 12;
    AddField(TUnused, $08, 'Unused data', '', @tempi);

    tempi := 2;
    AddField(TInt, $14, 'Loop speed', '', @tempi);

    tempi := 2;
    AddField(TInt, $16, 'Unknown', '', @tempi);

    tempi := 2;
    AddField(TInt, $18, 'Unknown', '', @tempi);

    tempi := 2;
    AddField(TUnused, $1A, 'Unused', '', @tempi);

    with AddField(TArray, $1C, 'AnimTextures array', '', @tempi) do
    begin
      AddField(TLinkByID, $00, 'Texture', '', nil);
    end;
  end;
  templist.Free;
end;


procedure TFile_TXAN.InitDatLinks;
var
  links: Integer;
  i: Integer;
begin
  ConManager.Connection[FConnectionID].LoadDatFilePart(FFileID, $1C, SizeOf(links), @links);
  SetLength(FDatLinks, links);
  for i := 0 to links - 1 do
  begin
    FDatLinks[i].SrcOffset := $20 + $4 * i;
    FDatLinks[i].DestID := GetDatLinkValue(FFileStream, FDatLinks[i].SrcOffset);
    FDatLinks[i].PosDestExts := 'TXMP';
  end;
end;


procedure TFile_TXAN.InitRawList;
begin
  SetLength(FRawParts, 0);
end;

end.

