unit TXMP;

interface

uses
  _FileTypes;

type
  TFile_TXMP = class(TFile)
    protected
      procedure InitDatLinks; override;
      procedure InitDataFields; override;
      procedure InitRawList; override;
  end;

implementation

uses
  ConnectionManager, Math, Classes, TypeDefs, _DataTypes;

{ TFile_TXMP }

procedure TFile_TXMP.InitDataFields;
var
  tempi: Integer;
  temps: String;
  templist: TStringList;
begin
  inherited;
  FDataFields := TBlock.Create(Self, nil, 0, 'Base', '', nil);
  templist := TStringList.Create;
  with FDataFields do
  begin
    AddField(TFileID, $00, 'FileID', '', nil);

    AddField(TLevelID, $04, 'LevelID', '', nil);

    tempi := 128;
    AddField(TString, $08, 'FileName', '', @tempi);

    templist.Add('MipMapping enabled');
    templist.Add('unknown');
    templist.Add('U wrapping disabled');
    templist.Add('V wrapping disabled');
    templist.Add('EnvMapped/EnvMap');
    templist.Add('unused');
    templist.Add('Play anim back to back');
    templist.Add('Random anim order + frame time');
    AddField(TBitSet, $88, 'Flags1', '', @templist);

    templist.Clear;
    templist.Add('Random anim time offset');
    templist.Add('High byte as EnvMap');
    templist.Add('High byte as alpha');
    templist.Add('Different alpha formula');
    templist.Add('Data swapping (always set)');
    templist.Add('used at runtime');
    templist.Add('TXAN looping on/off');
    templist.Add('16 bit blue');
    AddField(TBitSet, $89, 'Flags2', '', @templist);

    templist.Clear;
    templist.Add('16 bit alpha');
    templist.Add('16 bit red');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    AddField(TBitSet, $8A, 'Flags3', '', @templist);

    templist.Clear;
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    AddField(TBitSet, $8B, 'Flags4', '', @templist);

    tempi := 2;
    AddField(TInt, $8C, 'Width', '', @tempi);

    tempi := 2;
    AddField(TInt, $8E, 'Height', '', @tempi);

    tempi := 4;
    AddField(TInt, $90, 'StoreType', '', @tempi);

    temps := '*';
    AddField(TLinkByID, $94, 'TXAN', '', @temps);

    temps := 'TXMP';
    AddField(TLinkByID, $98, 'TXMP', '', @temps);

    AddField(TRawLink, $9C, 'RawLink', '', nil);

    AddField(TRawLink, $A0, 'SepLink', '', nil);

    tempi := $1C;
    AddField(TUnused, $A4, 'Unused', '', @tempi);
  end;
  templist.Free;
end;


procedure TFile_TXMP.InitDatLinks;
begin
  SetLength(FDatLinks, 2);
  FDatLinks[0].SrcOffset := $94;
  FDatLinks[0].DestID := GetDatLinkValue(FFileStream, $94);
  FDatLinks[0].PosDestExts := '*';
  FDatLinks[1].SrcOffset := $98;
  FDatLinks[1].DestID := GetDatLinkValue(FFileStream, $98);
  FDatLinks[1].PosDestExts := 'TXMP';
end;


procedure TFile_TXMP.InitRawList;
var
  link_pc:   Integer;
  link_mac:  Integer;
  x, y:      Word;
  storetype: Byte;
  datasize:  Integer;
  mipmap:    Byte;

  function GetImgSize(w,h, storetype: Integer): Integer;
  begin
    case storetype of
      0, 1, 2:
        Result := w*h*2;
      8:
        Result := w*h*4;
      9:
        Result :=  Max(1, w div 4) * Max(1, h div 4) * 8;
    else
      Result := -1;
    end;
  end;

begin
  ConManager.Connection[FConnectionID].LoadDatFilePart(FFileID, $88, SizeOf(mipmap), @mipmap);
  ConManager.Connection[FConnectionID].LoadDatFilePart(FFileID, $8C, SizeOf(x), @x);
  ConManager.Connection[FConnectionID].LoadDatFilePart(FFileID, $8E, SizeOf(y), @y);
  ConManager.Connection[FConnectionID].LoadDatFilePart(FFileID, $90, SizeOf(storetype), @storetype);
  ConManager.Connection[FConnectionID].LoadDatFilePart(FFileID, $9C, 4, @link_pc);
  ConManager.Connection[FConnectionID].LoadDatFilePart(FFileID, $A0, 4, @link_mac);

  datasize := GetImgSize(x, y, storetype);
  if (mipmap and $01) > 0 then
  begin
    repeat
      x    := Max(x div 2, 1);
      y    := Max(y div 2, 1);
      datasize := datasize + GetImgSize(x, y, storetype);
    until (x = 1) and (y = 1);
  end;

  SetLength(FRawParts, 1);
  if ConManager.Connection[FConnectionID].DataOS = DOS_WIN then
  begin
    FRawParts[0].SrcOffset := $9C;
    FRawParts[0].RawAddr   := link_pc;
  end
  else
  begin
    FRawParts[0].SrcOffset := $A0;
    FRawParts[0].RawAddr   := link_mac;
  end;
  FRawParts[0].RawSize := datasize;
  FRawParts[0].LocSep  := not (ConManager.Connection[FConnectionID].DataOS = DOS_WIN);
end;

end.

