unit _MetaManager;
interface

uses _FileTypes,
  ABNA, AGDB, AGQC, AGQG, AGQM, AGQR, AISA, AITR, AIWA, AKAA, AKBA, AKBP, AKDA,
  AKEV, AKOT, AKVA, BINA, CBPI, CBPM, CONS, CRSA, DOOR, DPge, EDIA, ENVP, FILM,
  FXLR, GMAN, HPge, IDXA, IGHH, IGPA, IGPG, IGSA, IGSt, Impt, IPge, KeyI, M3GA,
  M3GM, M3TA, Mtrl, NMSA, OBAN, OBDC, OBLS, OBOA, OFGA, ONCC, ONCP, ONCV, ONFA,
  ONGS, ONIA, ONLD, ONLV, ONMA, ONOA, ONSA, ONSK, ONTA, ONVL, ONWC, OPge, OSBD,
  OTIT, OTLF, PLEA, PNTA, PSpc, PSpL, PSUI, QTNA, QUDA, SNDD, StNA, SUBT, TMFA,
  TMRA, TRAC, TRAM, TRAS, TRBS, TRCM, TRFT, TRGA, TRGE, TRIA, TRIG, TRMA, TRSC,
  TRTA, TSFF, TSFL, TSFT, TSGA, TStr, TURR, TXAN, TXCA, TXMA, TXMB, TXMP, TXPC,
  TxtC, UUEA, UVDL, VCRA, WMCL, WMDD, WMM_, WMMB, WPge,
  _EmptyFile;

type
  TFileType = class of TFile;
  TFileDesc = record
    ext: String;
    ftype: TFileType;
  end;

const
  FileDescs: array[0..112] of TFileDesc = (
    (ext: 'ABNA'; ftype: TFile_ABNA),
    (ext: 'AGDB'; ftype: TFile_AGDB),
    (ext: 'AGQC'; ftype: TFile_AGQC),
    (ext: 'AGQG'; ftype: TFile_AGQG),
    (ext: 'AGQM'; ftype: TFile_AGQM),
    (ext: 'AGQR'; ftype: TFile_AGQR),
    (ext: 'AISA'; ftype: TFile_AISA),
    (ext: 'AITR'; ftype: TFile_AITR),
    (ext: 'AIWA'; ftype: TFile_AIWA),
    (ext: 'AKAA'; ftype: TFile_AKAA),
    (ext: 'AKBA'; ftype: TFile_AKBA),
    (ext: 'AKBP'; ftype: TFile_AKBP),
    (ext: 'AKDA'; ftype: TFile_AKDA),
    (ext: 'AKEV'; ftype: TFile_AKEV),
    (ext: 'AKOT'; ftype: TFile_AKOT),
    (ext: 'AKVA'; ftype: TFile_AKVA),
    (ext: 'BINA'; ftype: TFile_BINA),
    (ext: 'CBPI'; ftype: TFile_CBPI),
    (ext: 'CBPM'; ftype: TFile_CBPM),
    (ext: 'CONS'; ftype: TFile_CONS),
    (ext: 'CRSA'; ftype: TFile_CRSA),
    (ext: 'DOOR'; ftype: TFile_DOOR),
    (ext: 'DPge'; ftype: TFile_DPge),
    (ext: 'EDIA'; ftype: TFile_EDIA),
    (ext: 'ENVP'; ftype: TFile_ENVP),
    (ext: 'FILM'; ftype: TFile_FILM),
    (ext: 'FXLR'; ftype: TFile_FXLR),
    (ext: 'GMAN'; ftype: TFile_GMAN),
    (ext: 'HPge'; ftype: TFile_HPge),
    (ext: 'IDXA'; ftype: TFile_IDXA),
    (ext: 'IGHH'; ftype: TFile_IGHH),
    (ext: 'IGPA'; ftype: TFile_IGPA),
    (ext: 'IGPG'; ftype: TFile_IGPG),
    (ext: 'IGSA'; ftype: TFile_IGSA),
    (ext: 'IGSt'; ftype: TFile_IGSt),
    (ext: 'Impt'; ftype: TFile_Impt),
    (ext: 'IPge'; ftype: TFile_IPge),
    (ext: 'KeyI'; ftype: TFile_KeyI),
    (ext: 'M3GA'; ftype: TFile_M3GA),
    (ext: 'M3GM'; ftype: TFile_M3GM),
    (ext: 'M3TA'; ftype: TFile_M3TA),
    (ext: 'Mtrl'; ftype: TFile_Mtrl),
    (ext: 'NMSA'; ftype: TFile_NMSA),
    (ext: 'OBAN'; ftype: TFile_OBAN),
    (ext: 'OBDC'; ftype: TFile_OBDC),
    (ext: 'OBLS'; ftype: TFile_OBLS),
    (ext: 'OBOA'; ftype: TFile_OBOA),
    (ext: 'OFGA'; ftype: TFile_OFGA),
    (ext: 'ONCC'; ftype: TFile_ONCC),
    (ext: 'ONCP'; ftype: TFile_ONCP),
    (ext: 'ONCV'; ftype: TFile_ONCV),
    (ext: 'ONFA'; ftype: TFile_ONFA),
    (ext: 'ONGS'; ftype: TFile_ONGS),
    (ext: 'ONIA'; ftype: TFile_ONIA),
    (ext: 'ONLD'; ftype: TFile_ONLD),
    (ext: 'ONLV'; ftype: TFile_ONLV),
    (ext: 'ONMA'; ftype: TFile_ONMA),
    (ext: 'ONOA'; ftype: TFile_ONOA),
    (ext: 'ONSA'; ftype: TFile_ONSA),
    (ext: 'ONSK'; ftype: TFile_ONSK),
    (ext: 'ONTA'; ftype: TFile_ONTA),
    (ext: 'ONVL'; ftype: TFile_ONVL),
    (ext: 'ONWC'; ftype: TFile_ONWC),
    (ext: 'OPge'; ftype: TFile_OPge),
    (ext: 'OSBD'; ftype: TFile_OSBD),
    (ext: 'OTIT'; ftype: TFile_OTIT),
    (ext: 'OTLF'; ftype: TFile_OTLF),
    (ext: 'PLEA'; ftype: TFile_PLEA),
    (ext: 'PNTA'; ftype: TFile_PNTA),
    (ext: 'PSpc'; ftype: TFile_PSpc),
    (ext: 'PSpL'; ftype: TFile_PSpL),
    (ext: 'PSUI'; ftype: TFile_PSUI),
    (ext: 'QTNA'; ftype: TFile_QTNA),
    (ext: 'QUDA'; ftype: TFile_QUDA),
    (ext: 'SNDD'; ftype: TFile_SNDD),
    (ext: 'StNA'; ftype: TFile_StNA),
    (ext: 'SUBT'; ftype: TFile_SUBT),
    (ext: 'TMFA'; ftype: TFile_TMFA),
    (ext: 'TMRA'; ftype: TFile_TMRA),
    (ext: 'TRAC'; ftype: TFile_TRAC),
    (ext: 'TRAM'; ftype: TFile_TRAM),
    (ext: 'TRAS'; ftype: TFile_TRAS),
    (ext: 'TRBS'; ftype: TFile_TRBS),
    (ext: 'TRCM'; ftype: TFile_TRCM),
    (ext: 'TRFT'; ftype: TFile_TRFT),
    (ext: 'TRGA'; ftype: TFile_TRGA),
    (ext: 'TRGE'; ftype: TFile_TRGE),
    (ext: 'TRIA'; ftype: TFile_TRIA),
    (ext: 'TRIG'; ftype: TFile_TRIG),
    (ext: 'TRMA'; ftype: TFile_TRMA),
    (ext: 'TRSC'; ftype: TFile_TRSC),
    (ext: 'TRTA'; ftype: TFile_TRTA),
    (ext: 'TSFF'; ftype: TFile_TSFF),
    (ext: 'TSFL'; ftype: TFile_TSFL),
    (ext: 'TSFT'; ftype: TFile_TSFT),
    (ext: 'TSGA'; ftype: TFile_TSGA),
    (ext: 'TStr'; ftype: TFile_TStr),
    (ext: 'TURR'; ftype: TFile_TURR),
    (ext: 'TXAN'; ftype: TFile_TXAN),
    (ext: 'TXCA'; ftype: TFile_TXCA),
    (ext: 'TXMA'; ftype: TFile_TXMA),
    (ext: 'TXMB'; ftype: TFile_TXMB),
    (ext: 'TXMP'; ftype: TFile_TXMP),
    (ext: 'TXPC'; ftype: TFile_TXPC),
    (ext: 'TxtC'; ftype: TFile_TxtC),
    (ext: 'UUEA'; ftype: TFile_UUEA),
    (ext: 'UVDL'; ftype: TFile_UVDL),
    (ext: 'VCRA'; ftype: TFile_VCRA),
    (ext: 'WMCL'; ftype: TFile_WMCL),
    (ext: 'WMDD'; ftype: TFile_WMDD),
    (ext: 'WMM_'; ftype: TFile_WMM_),
    (ext: 'WMMB'; ftype: TFile_WMMB),
    (ext: 'WPge'; ftype: TFile_WPge)
  );

type
  TMetaManager = class
    protected
      FFiles: array of TFile;
      FConnectionID: Integer;
      function GetFileCount: Integer;
      function GetFileById(Id: Integer): TFile;
    private
      procedure InitRootFiles;
    public
      constructor Create(ConnectionID: Integer);
      procedure InitFile(id: Integer);
      procedure InitFileFields(id: Integer);

      property FileCount: Integer read GetFileCount;
      property FileById[Id: Integer]: TFile read GetFileById;
  end;

var
  Meta: TMetaManager;

implementation

uses
  Classes, ConnectionManager, Access_OniArchive, TypeDefs, Dialogs, SysUtils, StrUtils;

{ TFileManager }

constructor TMetaManager.Create(ConnectionID: Integer);
begin
  FConnectionID := ConnectionID;
  InitRootFiles;
end;

function TMetaManager.GetFileById(Id: Integer): TFile;
begin
  Result := FFiles[Id];
end;

function TMetaManager.GetFileCount: Integer;
begin
  Result := Length(FFiles);
end;

procedure TMetaManager.InitFile(id: Integer);
var
  typei: Integer;
  finfo: TFileInfo;
begin
  if id < ConManager.Connection[FConnectionID].GetFileCount then
  begin
    if not Assigned(FFiles[id]) then
    begin
      finfo := ConManager.Connection[FConnectionID].GetFileInfo(id);
      if finfo.Size > 0 then
      begin
        for typei := 0 to High(FileDescs) do
        begin
          if FileDescs[typei].ext = finfo.Extension then
          begin
            FFiles[id] := TFileType(FileDescs[typei].ftype).Create(FConnectionID, id);
            Break;
          end;
        end;
        if typei > High(FileDescs) then
          FFiles[id] := TFile_Empty.Create(FConnectionID, id);
      end else
        FFiles[id] := TFile_Empty.Create(FConnectionID, id);
      Exit;
    end;
  end;
end;

procedure TMetaManager.InitFileFields(id: Integer);
begin
  if id < ConManager.Connection[FConnectionID].GetFileCount then
  begin
    if not Assigned(FFiles[id]) then
    begin
      InitFile(id);
      if not (FFiles[id] is TFile_Empty) then
        FFiles[id].InitDataFields;
    end;
  end;
end;

procedure TMetaManager.InitRootFiles;
var
  files: TStrings;
  i: Integer;
  typei: Integer;
  fid: Integer;
  finfo: TFileInfo;
begin
  if ConManager.Connection[FConnectionID] is TAccess_OniArchive then
    TAccess_OniArchive(ConManager.Connection[FConnectionID]).UnloadWhenUnused := False;
  files := TStringList.Create;
  files := ConManager.Connection[FConnectionID].GetFilesList('', '', False, ST_IDAsc);
  SetLength(FFiles, ConManager.Connection[FConnectionID].GetFileCount);
  for i := 0 to High(FFiles) do
    FFiles[i] := nil;
  if files.Count > 0 then
  begin
    for i := 0 to files.Count - 1 do
    begin
      fid := StrToInt(MidStr(files.Strings[i], 1, 5));
      finfo := ConManager.Connection[FConnectionID].GetFileInfo(fid);
      if Length(finfo.Name) > 0 then
      begin
        if finfo.Size > 0 then
        begin
          for typei := 0 to High(FileDescs) do
          begin
            if FileDescs[typei].ext = finfo.Extension then
            begin
              FFiles[fid] := TFileType(FileDescs[typei].ftype).Create(FConnectionID, fid);
              Break;
            end;
          end;
        end
        else
          FFiles[fid] := TFile_Empty.Create(FConnectionID, fid);
      end;
    end;
  end;
  files.Free;
  if ConManager.Connection[FConnectionID] is TAccess_OniArchive then
    TAccess_OniArchive(ConManager.Connection[FConnectionID]).UnloadWhenUnused := True;
end;

end.
