unit TXMP;

interface

uses
  _FileTypes;

type
  TFile_TXMP = class(TFile)
    public
      procedure InitDataFields; override;
  end;

implementation

uses
  ConnectionManager, Math, Classes, TypeDefs, _DataTypes;

{ TFile_TXMP }

procedure TFile_TXMP.InitDataFields;
var
  tempi: Integer;
  temps: String;
  templist: TStringList;
begin
  inherited;
  FDataFields := TBlock.Create(Self, nil, 0, 'Base', '', nil);
  templist := TStringList.Create;
  with FDataFields do
  begin
    AddField(TFileID, $00, 'FileID', '', nil);

    AddField(TLevelID, $04, 'LevelID', '', nil);

    tempi := 128;
    AddField(TString, $08, 'FileName', '', @tempi);

    templist.Add('MipMapping enabled');
    templist.Add('unknown');
    templist.Add('U wrapping disabled');
    templist.Add('V wrapping disabled');
    templist.Add('EnvMapped/EnvMap');
    templist.Add('unused');
    templist.Add('Play anim back to back');
    templist.Add('Random anim order + frame time');
    AddField(TBitSet, $88, 'Flags1', '', @templist);

    templist.Clear;
    templist.Add('Random anim time offset');
    templist.Add('High byte as EnvMap');
    templist.Add('High byte as alpha');
    templist.Add('Different alpha formula');
    templist.Add('Data swapping (always set)');
    templist.Add('used at runtime');
    templist.Add('TXAN looping on/off');
    templist.Add('16 bit blue');
    AddField(TBitSet, $89, 'Flags2', '', @templist);

    templist.Clear;
    templist.Add('16 bit alpha');
    templist.Add('16 bit red');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    AddField(TBitSet, $8A, 'Flags3', '', @templist);

    templist.Clear;
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    templist.Add('unknown');
    AddField(TBitSet, $8B, 'Flags4', '', @templist);

    tempi := 2;
    AddField(TInt, $8C, 'Width', '', @tempi);

    tempi := 2;
    AddField(TInt, $8E, 'Height', '', @tempi);

    tempi := 4;
    AddField(TInt, $90, 'StoreType', '', @tempi);

    temps := '*';
    AddField(TLinkByID, $94, 'TXAN', '', @temps);

    temps := 'TXMP';
    AddField(TLinkByID, $98, 'TXMP', '', @temps);

    AddField(TRawLink, $9C, 'RawLink', '', nil);

    AddField(TRawLink, $A0, 'SepLink', '', nil);

    tempi := $1C;
    AddField(TUnused, $A4, 'Unused', '', @tempi);
  end;
  templist.Free;
end;


end.

