unit _TemplateFile;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, _BaseTemplate, StdCtrls, ExtCtrls,
  TypeDefs;

type
  TNewFileSelectedEvent = procedure(FileInfo: TFileInfo) of object;

  TForm_TemplateFile = class(TForm_BaseTemplate)
  protected
    FOnNewFileSelected: TNewFileSelectedEvent;
    FSelectedFile: TFileInfo;
  public
    constructor Create(AOwner: TComponent); override;
    procedure SelectFileID(ConnectionID, FileID: Integer);
  published
    property OnNewFileSelected: TNewFileSelectedEvent read FOnNewFileSelected write FOnNewFileSelected;
    property SelectedFile: TFileInfo read FSelectedFile;
  end;

var
  ToolList: TToolList;
procedure AddToolListEntry(context, name, exts: String);

implementation
{$R *.dfm}
uses ConnectionManager;


constructor TForm_TemplateFile.Create(AOwner: TComponent);
begin
  inherited;
  FOnNewFileSelected := nil;
  FSelectedFile.ID := -1;
end;


procedure TForm_TemplateFile.SelectFileID(ConnectionID, FileID: Integer);
begin
  if FConnectionID <> ConnectionID then
    SelectConnection(ConnectionID);

  if FileID < ConManager.Connection[FConnectionID].GetFileCount then
    FSelectedFile := ConManager.Connection[FConnectionID].GetFileInfo(FileID)
  else
    FSelectedFile.ID := -1;
  if Assigned(FOnNewFileSelected) then
    FOnNewFileSelected(FSelectedFile);
end;



procedure AddToolListEntryExt(context, ext: String);
var
  i: Integer;
begin
  for i := 0 to High(ToolList) do
    if ToolList[i].context = context then
    begin
      if Pos(ext, ToolList[i].exts) = 0 then
      begin
        if Length(ToolList[i].exts) = 0 then
          ToolList[i].exts := ext
        else
          ToolList[i].exts := ToolList[i].exts + ',' + ext;
      end;
      Exit;
    end;
end;

procedure AddToolListEntry(context, name, exts: String);
var
  i: Integer;
begin
  if Length(ToolList) > 0 then
  begin
    for i := 0 to High(ToolList) do
      if ToolList[i].context = context then
      begin
        if (Length(ToolList[i].name) = 0) and (Length(name) > 0) then
          ToolList[i].name := name;
        if Length(exts) > 0 then
          AddToolListEntryExt(context, exts);
        Exit;
      end;
  end;
  SetLength(ToolList, Length(ToolList) + 1);
  for i := High(ToolList) downto 1 do
    if ToolList[i - 1].name > name then
      ToolList[i] := ToolList[i - 1]
    else
      Break;
  ToolList[i].context := context;
  ToolList[i].name := name;
  ToolList[i].exts := exts;
end;

end.
