UNIT Unit8_binedit;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Wrapgrid, StdCtrls, Grids, StrUtils, MPHexEditor, Unit3_data, Unit2_functions,
  ExtCtrls;

TYPE
  TForm8 = Class(TForm)
    list: TListBox;
    hex: TMPHexEditor;
    Splitter1: TSplitter;
    PROCEDURE listClick(Sender: TObject);
    PROCEDURE FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE Recreatelist;
  PRIVATE
  PUBLIC
  END;

VAR
  Form8: TForm8;

IMPLEMENTATION
{$R *.dfm}
VAR
  fileid:LongWord;

PROCEDURE TForm8.Recreatelist;
  VAR
    i:LongWord;
  BEGIN
    Form8.list.Items.Clear;
    FOR i:=0 TO dat_header.Files-1 DO BEGIN
      IF (dat_files[i].FileType AND $02)=0 THEN
        Form8.list.Items.Add(dat_files[i].FileName);
    END;
  END;

PROCEDURE TForm8.FormCreate(Sender: TObject);
  BEGIN
    Form8.Caption:='';
    fileid:=0;
  END;

PROCEDURE TForm8.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    CanClose:=False;
    Form8.Visible:=False;
  END;

PROCEDURE TForm8.listClick(Sender: TObject);
  VAR
    mem:TMemoryStream;
    data:Tdata;
  BEGIN
    IF hex.Modified THEN BEGIN
      IF MessageBox(Form8.Handle,PChar('Save changes to file '+dat_files[fileid].FileName+'?'),PChar('Data changed...'),MB_YESNO)=IDYES THEN BEGIN
        mem:=TMemoryStream.Create;
        hex.SaveToStream(mem);
        mem.Seek(0,soFromBeginning);
        SetLength(data,mem.Size);
        mem.Read(data[0],mem.Size); 
        mem.Free;
        SaveDatFile(fileid,data);
        ShowMessage('Changes saved...');
      END;
    END;
    fileid:=StrToInt(MidStr(list.Items.Strings[list.ItemIndex],1,5));
    data:=LoadDatFile(fileid);
    mem:=TMemoryStream.Create;
    mem.Write(data[0],Length(data));
    hex.LoadFromStream(mem);
    mem.Free;
  END;

END.
