unit TypeDefs;
interface

uses
  Graphics, SysUtils;

type
  ENotImplemented = class(Exception);

  TDataBackend = (DB_ONI, DB_ADB);
  TDataOS = (DOS_WIN, DOS_WINDEMO, DOS_MAC, DOS_MACBETA);

  TChangeRights = set of (CR_EditDat, CR_EditRaw, CR_ResizeDat, CR_ResizeRaw, CR_AppendRaw);

  TStatusMessages = (
      SM_OK,
      SM_AlreadyOpened,
      SM_FileNotFound,
      SM_UnknownExtension,
      SM_IncompatibleFile,
      SM_IncompatibleDBVersion,
      SM_UnknownError
  );

  TDatOSIdent = array[0..3] of Byte;
  TDatGlobalIdent = array[0..15] of Byte;

  THeader = packed record
    OSIdent:    TDatOSIdent;
    GlobalIdent:TDatGlobalIdent;
    Files:      Integer;
    NamedFiles: Integer;
    Extensions: Integer;
    DataAddr:   Integer;
    DataSize:   Integer;
    NamesAddr:  Integer;
    NamesSize:  Integer;
    Ident2:     array[0..$F] of Byte;
  end;
  TFilesMap = array of packed record
    Extension: array[0..$3] of Char;
    DataAddr:  Integer;
    NameAddr:  Integer;
    FileSize:  Integer;
    FileType:  LongWord;
  end;
  TNamedFilesMap = array of packed record
    FileNumber: Integer;
    blubb:      Integer;
  end;

	TTypeIdent = array[0..7] of Byte;
	TFileType = record
		Extension: String[4];
		StructID:  Integer;
    Name:      String;
		IdentWin:  TTypeIdent;
    IdentMac:  TTypeIdent;
	end;

  TExtensionsMap = array of packed record
      Ident:       TTypeIdent;
      Extension:   array[0..$3] of Char;
      ExtCount:    Integer;
  end;

  TFileInfo = packed record
      ID:          Integer;
      Name:        String;
      Extension:   String[4];
      Size:        Integer;
      FileType:    LongWord;
      DatAddr:     Integer;
  end;
  TFiles = array of TFileInfo;

  TRawDataInfo = record
      Name:          String;
      SrcID:         Integer;
      SrcOffset:     Integer;
      RawAddr:       Integer;
      RawSize:       Integer;
      LocSep:        Boolean;
  end;
  TRawDataList = array of TRawDataInfo;

  TSortType = (
      ST_IDAsc,
      ST_IDDesc,
      ST_NameAsc,
      ST_NameDesc,
      ST_ExtAsc,
      ST_ExtDesc,
      ST_ExtNameAsc,
      ST_ExtNameDesc
  );

  TExtensionFormat = (
      EF_ExtOnly,
      EF_ExtCount
  );

  TByteData = array of Byte; 

  TAppSettings = record
      DatPath:        String[250];
      ExtractPath:    String[250];
      CharSet:        TFontCharSet;
      HideUnusedData: Boolean;
  end;

  TToolList = array of record
      context: String;
      name: String;
      exts: String;
  end;


  TLinkByName = record
      SrcOffset: Integer;
      Destination: String;
  end;
  TLinkByID = record
      SrcOffset: Integer;
      Destination: Integer;
  end;
  TLinks = record
      ByName: array of TLinkByName;
      ByID: array of TLinkByID;
  end;

  TDatLink = record
      SrcOffset: Integer;
      DestID:    Integer;
      PosDestExts:   String;
  end;
  TDatLinkList = array of TDatLink;
 
{
  TLevelInfo = record
    Ident: array[0..$13] of Byte;
    LevelNumber: Byte;
  end;

 TDatLinks = array of record
    Src_Offset: Integer;
    Target:     Integer;
  end;
}

const
  CrLf: String[2] = #13#10;

implementation

end.
