unit _Extensions;

interface

uses
  _FileTypes;

type
  TExtension = class
    private
      FConnectionID: Integer;
      FExt: String;
      FFiles: array of Integer;
      function GetFile(ID: Integer): Integer;
      function GetFileCount: Integer;
    public
      constructor Create(ConnectionID: Integer; Ext: String); virtual;
      procedure InitList;
      property Ext: String read FExt;
      property Files[ID: Integer]: Integer read GetFile;
      property FileCount: Integer read GetFileCount;
  end;

  TExtensions = array of TExtension;
                      


implementation

uses
  Classes, StrUtils, SysUtils, ConnectionManager, TypeDefs;

{ TExtension }

constructor TExtension.Create(ConnectionID: Integer; Ext: String);
begin
  FConnectionID := ConnectionID;
  FExt := Ext;
end;

function TExtension.GetFile(ID: Integer): Integer;
begin
  Result := FFiles[ID];
end;

function TExtension.GetFileCount: Integer;
begin
  Result := Length(FFiles);
end;

procedure TExtension.InitList;
var
  files: TStrings;
  i: Integer;
  fid: Integer;
  finfo: TFileInfo;
begin
  files := TStringList.Create;
  files := ConManager.Connection[FConnectionID].GetFilesList(Ext, '', False, ST_NameAsc);
  if files.Count > 0 then
  begin
    for i := 0 to files.Count - 1 do
    begin
      fid := StrToInt(MidStr(files.Strings[i], 1, 5));
      finfo := ConManager.Connection[FConnectionID].GetFileInfo(fid);
      if Length(finfo.Name) > 0 then
      begin
        SetLength(FFiles, Length(FFiles) + 1);
        FFiles[High(FFiles)] := fid;
      end;
    end;
  end;
  files.Free;
end;

end.
