unit MetaEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, _BaseTemplate, ExtCtrls, VirtualTrees, StdCtrls;

type
  TForm_Meta = class(TForm_BaseTemplate)
    VST: TVirtualStringTree;
    Panel2: TPanel;
    splitter: TSplitter;
    procedure FormCreate(Sender: TObject);
    procedure VSTInitChildren(Sender: TBaseVirtualTree; Node: PVirtualNode;
      var ChildCount: Cardinal);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure VSTFocusChanged(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex);
    procedure VSTFocusChanging(Sender: TBaseVirtualTree; OldNode,
      NewNode: PVirtualNode; OldColumn, NewColumn: TColumnIndex;
      var Allowed: Boolean);
    procedure VSTGetText(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex; TextType: TVSTTextType; var CellText: WideString);
    procedure VSTPaintText(Sender: TBaseVirtualTree;
      const TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
      TextType: TVSTTextType);
  private
    procedure NewCon(ID: Integer);
  public
  end;


implementation
{$R *.dfm}
uses _MetaManager, _MetaTypes, ConnectionManager, Data;

type
  PNodeData = ^TNodeData;

  TNodeData = record
    Field: TObject;
  end;

function AddVSTEntry(AVST: TCustomVirtualStringTree; ANode: PVirtualNode;
  ARecord: TNodeData): PVirtualNode;
var
  Data: PNodeData;
begin
  Result := AVST.AddChild(ANode);
  Data   := AVST.GetNodeData(Result);
  AVST.ValidateNode(Result, False);
  Data^ := ARecord;
end;


procedure TForm_Meta.NewCon(ID: Integer);
var
  i: Integer;
  data: TNodeData;
  node: PVirtualNode;
  Meta: TMetaManager;
begin
  if ID >= 0 then
  begin
    VST.Clear;
    VST.BeginUpdate;
    Meta := ConManager.Connection[ID].MetaData;
    for i := 0 to Meta.FileCount - 1 do
    begin
      if Assigned(Meta.FileById[i]) then
      begin
        data.Field := Meta.FileById[i];
        node := AddVSTEntry(VST, nil, data);
        if Meta.FileById[i].ChildCount > 0 then
          VST.HasChildren[node] := True;
      end;
    end;
    VST.EndUpdate;
  end;
end;


procedure TForm_Meta.VSTInitChildren(Sender: TBaseVirtualTree;
  Node: PVirtualNode; var ChildCount: Cardinal);
var
  data: PNodeData;
  newdata: TNodeData;
  newnode: PVirtualNode;
  i: Integer;
  id: Integer;
  Meta: TMetaManager;
begin
  data := Sender.GetNodeData(node);
  Meta := ConManager.Connection[ID].MetaData;
  for i := 0 to TFile(data.Field).ChildCount - 1 do
  begin
    id := TFile(data.Field).LinkByIndex[i].DestID;
    Meta.InitFile(id);
    newdata.Field := Meta.FileById[id];
    newnode := AddVSTEntry(TCustomVirtualStringTree(Sender), Node, newdata);
    if Meta.FileById[id].ChildCount > 0 then
      Sender.HasChildren[newnode] := True;
  end;
  ChildCount := Sender.ChildCount[Node];
end;


procedure TForm_Meta.VSTFocusChanged(Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex);
var
  data: PNodeData;
begin
  data := Sender.GetNodeData(Node);
  if data.Field is TFile then
  begin
    TFile(data.Field).InitEditor;
    if Assigned(TFile(data.Field).Editor) then
    begin
      panel2.InsertControl(TFile(data.Field).Editor);
      TFile(data.Field).Opened := True;
    end;
  end;
end;


procedure TForm_Meta.VSTFocusChanging(Sender: TBaseVirtualTree; OldNode,
  NewNode: PVirtualNode; OldColumn, NewColumn: TColumnIndex;
  var Allowed: Boolean);
var
  data: PNodeData;
  i: Integer;
begin
  data := Sender.GetNodeData(NewNode);
  if data.Field is TFile then
  begin
    TFile(data.Field).InitEditor;
    if Assigned(TFile(data.Field).Editor) then
      Allowed := not TFile(data.Field).Opened
    else
      Allowed := True;
  end;
  if Allowed and Assigned(OldNode) then
  begin
    data := Sender.GetNodeData(OldNode);
    if data.Field is TFile then
    begin
      if TFile(data.Field).Opened then
      begin
        if panel2.ControlCount > 0 then
          for i := 0 to panel2.ControlCount - 1 do
            panel2.RemoveControl(panel2.Controls[i]);
        TFile(data.Field).Opened := False;
      end;
    end;
  end;
end;


procedure TForm_Meta.VSTGetText(Sender: TBaseVirtualTree; Node: PVirtualNode;
  Column: TColumnIndex; TextType: TVSTTextType; var CellText: WideString);
var
  Data: PNodeData;
begin
  Data     := Sender.GetNodeData(Node);
  CellText := '';
  if TextType = ttNormal then
  begin
    case Column of
      0:
        begin
          if Data.Field is TFile then
          begin
            CellText := TFile(Data.Field).FileInfo.Name;
            if CellText = '' then
              CellText := 'Unnamed';
          end;
        end;
      1:
        begin
          if Data.Field is TFile then
            CellText := TFile(Data.Field).FileInfo.Extension;
        end;
      2:
        begin
          if Data.Field is TFile then
            CellText := IntToStr(TFile(Data.Field).FileInfo.ID);
        end;
    end;
  end;
end;


procedure TForm_Meta.VSTPaintText(Sender: TBaseVirtualTree;
  const TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
  TextType: TVSTTextType);
var
  Data: PNodeData;
begin
  Data     := Sender.GetNodeData(Node);
  if TextType = ttNormal then
  begin
    case Column of
      0:
        begin
          if Data.Field is TFile then
          begin
            if Length(TFile(Data.Field).FileInfo.Name) = 0 then
              TargetCanvas.Font.Color := $C06060;
            if TFile(Data.Field).FileInfo.Size = 0 then
              TargetCanvas.Font.Color := $2020A0;
          end;
        end;
    end;
  end;
end;



procedure TForm_Meta.FormClose(Sender: TObject; var Action: TCloseAction);
begin
//  Meta.Free;
  inherited;
end;

procedure TForm_Meta.FormCreate(Sender: TObject);
begin
  inherited;
  OnNewConnection := NewCon;

  VST.NodeDataSize := SizeOf(TNodeData);
  VST.Font.Charset := AppSettings.CharSet;
  VST.Clear;

  UpdateConList;
end;

end.
