unit SUBT;

interface

uses
  _FileTypes;

type
  TFile_SUBT = class(TFile)
    public
      procedure InitDataFields; override;
      procedure InitEditor; override;
  end;

implementation

uses
  ConnectionManager, Math, Classes, TypeDefs, _DataTypes, Forms, StdCtrls, Grids;

procedure TFile_SUBT.InitDataFields;
var
  tempi: Integer;
begin
  inherited;
  FDataFields := TBlock.Create(Self, nil, 0, 'Base', '', nil);
  with FDataFields do
  begin
    AddField(TFileID, $00, 'FileID', '', nil);

    AddField(TLevelID, $04, 'LevelID', '', nil);

    tempi := 16;
    AddField(TUnused, $08, 'Unused data', '', @tempi);

    AddField(TRawLink, $18, 'Raw Address', '', nil);

    tempi := 4;
    with AddField(TArray, $1C, 'SUBT offsets array', '', @tempi) do
    begin
      tempi := 4;
      AddField(TInt, $00, 'Offset', '', @tempi);
    end;
  end;
  FFileStream.Free;
  FFileStream := nil;
end;


procedure TFile_SUBT.InitEditor;
var
  grid: TStringGrid;
begin
  FEditor := TFrame.Create(nil);
  grid := TStringGrid.Create(FEditor);
  grid.Parent := FEditor;
end;

end.
