unit TXAN;

interface

uses
  _FileTypes;

type
  TFile_TXAN = class(TFile)
    public
      procedure InitDataFields; override;
  end;

implementation

uses
  ConnectionManager, Math, Classes, TypeDefs, _DataTypes;

procedure TFile_TXAN.InitDataFields;
var
  tempi: Integer;
  arrargs: TArrayArgs;
begin
  inherited;
  FDataFields := TBlock.Create(Self, nil, 0, 'Base', '', nil);
  with FDataFields do
  begin
    AddField(TFileID, $00, 'FileID', '', nil);

    AddField(TLevelID, $04, 'LevelID', '', nil);

    tempi := 12;
    AddField(TUnused, $08, 'Unused data', '', @tempi);

    tempi := 2;
    AddField(TInt, $14, 'Loop speed', '', @tempi);

    tempi := 2;
    AddField(TInt, $16, 'Unknown', '', @tempi);

    tempi := 2;
    AddField(TInt, $18, 'Unknown', '', @tempi);

    tempi := 2;
    AddField(TUnused, $1A, 'Unused', '', @tempi);

    arrargs.CounterSize := 2;
    arrargs.BlockLength := 4;
    with AddField(TArray, $1C, 'AnimTextures array', '', @arrargs) do
    begin
      AddField(TLinkByID, $00, 'Texture', '', nil);
    end;
  end;
  FFileStream.Free;
  FFileStream := nil;
end;


end.
