unit _MetaManager;
interface

uses _MetaTypes;

type
  TMetaManager = class
    protected
      FFiles: array of TFile;
      FRoot: TExtensions;
      FConnectionID: Integer;
      FDataAccess: TObject;
      function GetFileCount: Integer;
      function GetFileById(Id: Integer): TFile;
    private
    public
      constructor Create(ConnectionID: Integer; DataAccess: TObject);
      procedure InitFile(id: Integer);
      procedure InitFileFields(id: Integer);

      property Root: TExtensions read FRoot;
      property FileCount: Integer read GetFileCount;
      property FileById[Id: Integer]: TFile read GetFileById;
  end;

implementation

uses
  Classes, ConnectionManager, Access_OniArchive, TypeDefs,
  Dialogs, SysUtils, StrUtils, DataAccess, _Extensions;

{ TFileManager }

constructor TMetaManager.Create(ConnectionID: Integer; DataAccess: TObject);
begin
  FConnectionID := ConnectionID;
  FDataAccess := DataAccess;
  SetLength(FFiles, TDataAccess(DataAccess).GetFileCount);
  FRoot := TExtensions.Create(DataAccess, ConnectionID);
end;


function TMetaManager.GetFileById(Id: Integer): TFile;
begin
  InitFile(Id);
  Result := FFiles[Id];
end;

function TMetaManager.GetFileCount: Integer;
begin
  Result := Length(FFiles);
end;

procedure TMetaManager.InitFile(id: Integer);
var
  typei: Integer;
  finfo: TFileInfo;
begin
  if id < ConManager.Connection[FConnectionID].GetFileCount then
  begin
    if not Assigned(FFiles[id]) then
    begin
      finfo := ConManager.Connection[FConnectionID].GetFileInfo(id);
      if finfo.Size > 0 then
      begin
        for typei := 0 to High(FileDescs) do
        begin
          if FileDescs[typei].ext = finfo.Extension then
          begin
            FFiles[id] := TFileClass(FileDescs[typei].ftype).Create(FConnectionID, id);
            Break;
          end;
        end;
        if typei > High(FileDescs) then
          FFiles[id] := TFile_Empty.Create(FConnectionID, id);
      end else
        FFiles[id] := TFile_Empty.Create(FConnectionID, id);
      Exit;
    end;
  end;
end;

procedure TMetaManager.InitFileFields(id: Integer);
begin
  if id < ConManager.Connection[FConnectionID].GetFileCount then
  begin
    if not Assigned(FFiles[id]) then
    begin
      InitFile(id);
      if not (FFiles[id] is TFile_Empty) then
        FFiles[id].InitDataFields;
    end;
  end;
end;

end.
