unit _FileTypes;

interface

uses
  TypeDefs, _DataTypes, _TreeElement, Classes, Forms;


type
  TFile = class(TTreeElement)
      function GetChildCount: Integer; override;
      function GetChild(ID: Integer): TTreeElement; override;
      function GetCaption: String; override;
  private
    FConnectionID: Integer;
    protected
      FFileInfo: TFileInfo;
      FFileStream: TMemoryStream;

      FCached: Boolean;
      FChanged: Boolean;

      FDataFields: TBlock;

      FEditor: TFrame;
      FOpened: Boolean;

      function GetFieldByOffset(Offset: Integer): TDataField;
  published
    public
      constructor Create(ConnectionID, FileID: Integer); virtual;
      procedure Free;

      procedure InitDataFields; virtual;
      procedure InitEditor; virtual;

      property FileStream: TMemoryStream read FFileStream;
      property FileInfo: TFileInfo read FFileInfo;
      property ConnectionID: Integer read FConnectionID;

      property Cached: Boolean read FCached;
      property Changed: Boolean read FChanged write FChanged;

      property Editor: TFrame read FEditor;
      property Opened: Boolean read FOpened write FOpened;

      property FieldByOffset[Offset: Integer]: TDataField read GetFieldByOffset;
  end;


  TFileType = class of TFile;



implementation

uses
  DatLinks, RawList, ConnectionManager, Dialogs, _MetaTypes, _MetaManager;

{ TFileType }

constructor TFile.Create(ConnectionID, FileID: Integer);
begin
  FConnectionID := ConnectionID;
  FFileInfo := ConManager.Connection[ConnectionID].GetFileInfo(FileID);

  FCached := False;
  FChanged := False;

  if not (Self is TFile_Empty) then
  begin
    FDataFields := nil;
    InitDataFields;
    FEditor := nil;
  end
  else
  begin
    FEditor := nil;
  end;
end;


procedure TFile.Free;
begin
  FDataFields.Free;
end;


function TFile.GetFieldByOffset(Offset: Integer): TDataField;
begin
  Result := FDataFields.FieldByOffset[Offset];
end;


function TFile.GetCaption: String;
begin
  Result := FFileInfo.Name;
  if Result = '' then
    Result := 'Unnamed';
end;

function TFile.GetChild(ID: Integer): TTreeElement;
begin
  Result := FDataFields.Child[ID];
end;

function TFile.GetChildCount: Integer;
begin
  if FDataFields <> nil then
    Result := FDataFields.ChildCount;
end;


procedure TFile.InitDataFields;
begin
  if Assigned(FDataFields) then
    Exit;
  FFileStream := TMemoryStream.Create;
  ConManager.Connection[FConnectionID].LoadDatFile(FFileInfo.ID, TStream(FFileStream));
end;


procedure TFile.InitEditor;
begin
  Exit;
end;


end.
