unit AKVA;

interface

uses
  _FileTypes;

type
  TFile_AKVA = class(TFile)
    public
      procedure InitDataFields; override;
  end;

implementation

uses
  ConnectionManager, Math, Classes, TypeDefs, _DataTypes, Forms, StdCtrls;

procedure TFile_AKVA.InitDataFields;
begin
  inherited;
  FDataFields := TBlock.Create(Self, nil, 'Base', '', []);
  with FDataFields do
  begin
    AddField(TFileID, 'FileID', '', []);
    AddField(TLevelID, 'LevelID', '', []);

    AddField(TUnused, 'Unused data', '', [20]);

    with TArray(Addfield(TArray, 'BNV nodes', '', [4])) do
    begin
      AddField(TInt, 'AKBP index', 'BSP tree for this BNV', [4]);
      AddField(TInt, 'AKVA index', 'index of this BNV', [4]);
      AddField(TInt, 'AKBA index', '"side" range start', [4]);
      AddField(TInt, 'AKBA index', '"side" range end', [4]);
      AddField(TInt, 'AKVA index', 'first child BNV', [4]);
      AddField(TInt, 'AKVA index', 'next sibling BNV', [4]);
      AddField(TInt, 'Unknown', 'always -1', [4]);
      with TBlock(AddField(TBlock, 'RAW link', '', [])) do
      begin
        AddField(TInt, 'X-tiles', 'size of pathfinding grid', [4]);
        AddField(TInt, 'Z-tiles', 'size of pathfinding grid', [4]);
        AddField(TRawLink, 'RAW offset', 'offset of grid data', []);
        AddField(TInt, 'RAW size', 'size of grid data', [4]);
        AddField(TFloat, 'Tile size', 'usually 4 world units', []);
      end;
      AddField(TFloat, 'AABB X-', 'BNV AABB', []);
      AddField(TFloat, 'AABB Y-', 'BNV AABB', []);
      AddField(TFloat, 'AABB Z-', 'BNV AABB', []);
      AddField(TFloat, 'AABB X+', 'BNV AABB', []);
      AddField(TFloat, 'AABB Y+', 'BNV AABB', []);
      AddField(TFloat, 'AABB Z+', 'BNV AABB', []);
      AddField(TInt, 'Unknown', 'always -2', [2]);
      AddField(TInt, 'Unknown', 'always -2', [2]);
      AddField(TInt, 'AKVA index', 'index of this BNV again', [4]);
      AddField(TInt, 'Unknown', 'always 0', [4]);
      AddField(TInt, 'Unknown', 'always 0', [4]);
      AddField(TInt, 'Unknown', 'always 0 (was a RAW offset once?)', [4]);
      AddField(TBitSet, 'Bitset', '', ['sloped', 'unknown', 'unknown, always set',
          'unknown', 'unknown, "no raw data"', 'unknown', 'unknown', 'unknown']);
      AddField(TBitSet, 'Bitset', '', ['unknown', 'unknown', 'unknown', 'unknown',
          'unknown', 'unknown', 'unknown', 'unknown']);
      AddField(TBitSet, 'Bitset', '', ['unknown', 'unknown', 'unknown', 'unknown',
          'unknown', 'unknown', 'unknown', 'unknown']);
      AddField(TBitSet, 'Bitset', '', ['unknown', 'unknown', 'unknown', 'unknown',
          'unknown', 'unknown', 'unknown', 'unknown']);
      AddField(TFloat, 'Plane X', 'floor and ceiling normal', []);
      AddField(TFloat, 'Plane Y', 'floor and ceiling normal', []);
      AddField(TFloat, 'Plane Z', 'floor and ceiling normal', []);
      AddField(TFloat, 'Plane D', 'distance of floor to origin', []);
      AddField(TFloat, 'Plane D', 'distance of ceiling to origin', []);
      SetCount;
    end;
  end;
  FDataFields.Update(0, -1);
  FFileStream.Free;
  FFileStream := nil;
end;


end.
