unit Data;
interface
uses Classes, Graphics, TypeDefs;

const
  Version:   String    = 'v0.35a';
  DBVersion: String    = '0.5';
  CrLf:      String[2] = #13 + #10;

var
  AppSettings:     TAppSettings;
  AppSettingsFile: file of TAppSettings;


const
  HeaderOSIdentWin:     TDatOSIdent = ($1F, $27, $DC, $33);
  HeaderOSIdentMac:     TDatOSIdent = ($61, $30, $C1, $23);
  HeaderOSIdentMacBeta: TDatOSIdent = ($81, $11, $8D, $23);
  HeaderGlobalIdent: TDatGlobalIdent = ($DF, $BC, $03, $00, $31, $33, $52, $56,
                                        $40, $00, $14, $00, $10, $00, $08, $00);

	FileTypes: array[0..113] of TFileType = (
		(Extension: 'AISA';  StructID: 501; Name: 'AI Character Setup Array';  IdentWin:($E9,$6B,$4C,$22,$2A,$00,$00,$00);  IdentMac:($E9,$6B,$4C,$22,$2A,$00,$00,$00)),
		(Extension: 'AITR';  StructID: 502; Name: 'AI script trigger array';  IdentWin:($55,$EA,$1A,$00,$00,$00,$00,$00);  IdentMac:($55,$EA,$1A,$00,$00,$00,$00,$00)),
		(Extension: 'AIWA';  StructID: 503; Name: 'AI Imported Waypoint Array';  IdentWin:($03,$7F,$10,$00,$00,$00,$00,$00);  IdentMac:($03,$7F,$10,$00,$00,$00,$00,$00)),
		(Extension: 'AKAA';  StructID: 504; Name: 'Adjacency Array';  IdentWin:($77,$DE,$11,$00,$00,$00,$00,$00);  IdentMac:($77,$DE,$11,$00,$00,$00,$00,$00)),
		(Extension: 'ABNA';  StructID: 505; Name: 'BSP tree node Array';  IdentWin:($A0,$6D,$12,$00,$00,$00,$00,$00);  IdentMac:($A0,$6D,$12,$00,$00,$00,$00,$00)),
		(Extension: 'AKVA';  StructID: 506; Name: 'BNV Node Array';  IdentWin:($E0,$05,$DF,$00,$00,$00,$00,$00);  IdentMac:($E0,$05,$DF,$00,$00,$00,$00,$00)),
		(Extension: 'AKBA';  StructID: 507; Name: 'Side Array';  IdentWin:($84,$28,$3A,$00,$00,$00,$00,$00);  IdentMac:($84,$28,$3A,$00,$00,$00,$00,$00)),
		(Extension: 'AKBP';  StructID: 508; Name: 'BSP node Array';  IdentWin:($49,$F4,$0C,$00,$00,$00,$00,$00);  IdentMac:($49,$F4,$0C,$00,$00,$00,$00,$00)),
		(Extension: 'AKDA';  StructID: 509; Name: 'Door Frame Array';  IdentWin:($64,$54,$2E,$00,$00,$00,$00,$00);  IdentMac:($64,$54,$2E,$00,$00,$00,$00,$00)),
		(Extension: 'AKEV';  StructID: 510; Name: 'Akira Environment';  IdentWin:($75,$DE,$14,$30,$88,$00,$00,$00);  IdentMac:($75,$DE,$14,$30,$88,$00,$00,$00)),
		(Extension: 'AGQC';  StructID: 511; Name: 'Gunk Quad Collision Array';  IdentWin:($91,$CB,$1C,$00,$00,$00,$00,$00);  IdentMac:($91,$CB,$1C,$00,$00,$00,$00,$00)),
		(Extension: 'AGDB';  StructID: 512; Name: 'Gunk Quad Debug Array';  IdentWin:($17,$2E,$07,$00,$00,$00,$00,$00);  IdentMac:($17,$2E,$07,$00,$00,$00,$00,$00)),
		(Extension: 'AGQG';  StructID: 513; Name: 'Gunk Quad General Array';  IdentWin:($D2,$03,$1C,$00,$00,$00,$00,$00);  IdentMac:($D2,$03,$1C,$00,$00,$00,$00,$00)),
		(Extension: 'AGQM';  StructID: 514; Name: 'Gunk Quad Material';  IdentWin:($A6,$4A,$04,$00,$00,$00,$00,$00);  IdentMac:($A6,$4A,$04,$00,$00,$00,$00,$00)),
		(Extension: 'AGQR';  StructID: 515; Name: 'Gunk Quad Render Array';  IdentWin:($3B,$3A,$08,$00,$00,$00,$00,$00);  IdentMac:($3B,$3A,$08,$00,$00,$00,$00,$00)),
		(Extension: 'AKOT';  StructID: 516; Name: 'Oct tree';  IdentWin:($08,$DA,$B8,$E7,$11,$00,$00,$00);  IdentMac:($08,$DA,$B8,$E7,$11,$00,$00,$00)),
		(Extension: 'OTIT';  StructID: 517; Name: 'Oct tree interior node Array';  IdentWin:($D2,$51,$0A,$00,$00,$00,$00,$00);  IdentMac:($D2,$51,$0A,$00,$00,$00,$00,$00)),
		(Extension: 'OTLF';  StructID: 518; Name: 'Oct tree leaf node Array';  IdentWin:($0B,$AC,$1E,$00,$00,$00,$00,$00);  IdentMac:($0B,$AC,$1E,$00,$00,$00,$00,$00)),
		(Extension: 'QTNA';  StructID: 519; Name: 'Quad tree node Array';  IdentWin:($CC,$6E,$06,$00,$00,$00,$00,$00);  IdentMac:($CC,$6E,$06,$00,$00,$00,$00,$00)),
		(Extension: 'BINA';  StructID: 520; Name: 'Binary Data';  IdentWin:($41,$DB,$00,$00,$00,$00,$00,$00);  IdentMac:($11,$5E,$01,$00,$00,$00,$00,$00)),
		(Extension: 'ENVP';  StructID: 521; Name: 'Env Particle Array';  IdentWin:($C3,$C1,$67,$00,$00,$00,$00,$00);  IdentMac:($C3,$C1,$67,$00,$00,$00,$00,$00)),
		(Extension: 'FXLR';  StructID: 522; Name: 'FX Laser effect';  IdentWin:($A9,$F8,$83,$95,$06,$00,$00,$00);  IdentMac:($A9,$F8,$83,$95,$06,$00,$00,$00)),
		(Extension: '3CLA';  StructID: 523; Name: 'RGB Color Array';  IdentWin:($BE,$E6,$04,$00,$00,$00,$00,$00);  IdentMac:($BE,$E6,$04,$00,$00,$00,$00,$00)),
		(Extension: 'EDIA';  StructID: 524; Name: 'Edge Index Array';  IdentWin:($F7,$B6,$07,$00,$00,$00,$00,$00);  IdentMac:($F7,$B6,$07,$00,$00,$00,$00,$00)),
		(Extension: 'M3GM';  StructID: 525; Name: 'Geometry';  IdentWin:($36,$E4,$78,$A0,$27,$00,$00,$00);  IdentMac:($36,$E4,$78,$A0,$27,$00,$00,$00)),
		(Extension: 'GMAN';  StructID: 526; Name: 'Geometry Animation';  IdentWin:($A5,$F5,$72,$A6,$09,$00,$00,$00);  IdentMac:($A5,$F5,$72,$A6,$09,$00,$00,$00)),
		(Extension: 'M3GA';  StructID: 527; Name: 'GeometryArray';  IdentWin:($B2,$20,$6B,$20,$05,$00,$00,$00);  IdentMac:($B2,$20,$6B,$20,$05,$00,$00,$00)),
		(Extension: 'PLEA';  StructID: 528; Name: 'Plane Equation Array';  IdentWin:($38,$BC,$07,$00,$00,$00,$00,$00);  IdentMac:($38,$BC,$07,$00,$00,$00,$00,$00)),
		(Extension: 'PNTA';  StructID: 529; Name: '3D Point Array';  IdentWin:($6C,$67,$37,$00,$00,$00,$00,$00);  IdentMac:($6C,$67,$37,$00,$00,$00,$00,$00)),
		(Extension: 'QUDA';  StructID: 530; Name: 'Quad array';  IdentWin:($6A,$5E,$03,$00,$00,$00,$00,$00);  IdentMac:($6A,$5E,$03,$00,$00,$00,$00,$00)),
		(Extension: 'TXCA';  StructID: 531; Name: 'Texture Coordinate Array';  IdentWin:($1A,$14,$09,$00,$00,$00,$00,$00);  IdentMac:($1A,$14,$09,$00,$00,$00,$00,$00)),
		(Extension: 'TXMP';  StructID: 532; Name: 'Texture Map';  IdentWin:($81,$75,$18,$91,$08,$00,$00,$00);  IdentMac:($5F,$EB,$1E,$91,$08,$00,$00,$00)),
		(Extension: 'TXAN';  StructID: 533; Name: 'Texture Map Animation';  IdentWin:($87,$43,$13,$8B,$0A,$00,$00,$00);  IdentMac:($87,$43,$13,$8B,$0A,$00,$00,$00)),
		(Extension: 'TXMA';  StructID: 534; Name: 'Texture map array';  IdentWin:($90,$7F,$DE,$99,$05,$00,$00,$00);  IdentMac:($90,$7F,$DE,$99,$05,$00,$00,$00)),
		(Extension: 'TXMB';  StructID: 535; Name: 'Texture Map Big';  IdentWin:($52,$6A,$16,$8B,$0A,$00,$00,$00);  IdentMac:($52,$6A,$16,$8B,$0A,$00,$00,$00)),
		(Extension: 'TXPC';  StructID: 536; Name: 'Texture Procedure Data';  IdentWin:($7E,$A7,$0B,$00,$00,$00,$00,$00);  IdentMac:($7E,$A7,$0B,$00,$00,$00,$00,$00)),
		(Extension: 'M3TA';  StructID: 537; Name: 'Triangle array';  IdentWin:($C1,$F7,$02,$00,$00,$00,$00,$00);  IdentMac:($C1,$F7,$02,$00,$00,$00,$00,$00)),
		(Extension: 'VCRA';  StructID: 538; Name: '3D Vector Array';  IdentWin:($39,$47,$05,$00,$00,$00,$00,$00);  IdentMac:($39,$47,$05,$00,$00,$00,$00,$00)),
		(Extension: 'Impt';  StructID: 539; Name: 'Impact';  IdentWin:($16,$4F,$04,$00,$00,$00,$00,$00);  IdentMac:($16,$4F,$04,$00,$00,$00,$00,$00)),
		(Extension: 'Mtrl';  StructID: 540; Name: 'Material';  IdentWin:($0D,$8E,$02,$00,$00,$00,$00,$00);  IdentMac:($0D,$8E,$02,$00,$00,$00,$00,$00)),
		(Extension: 'NMSA';  StructID: 541; Name: 'Network Spawn Point Array';  IdentWin:($9C,$09,$0C,$00,$00,$00,$00,$00);  IdentMac:($9C,$09,$0C,$00,$00,$00,$00,$00)),
		(Extension: 'CONS';  StructID: 542; Name: 'Console';  IdentWin:($DD,$0B,$8B,$DA,$13,$00,$00,$00);  IdentMac:($DD,$0B,$8B,$DA,$13,$00,$00,$00)),
		(Extension: 'DOOR';  StructID: 543; Name: 'Door';  IdentWin:($67,$FD,$72,$31,$06,$00,$00,$00);  IdentMac:($67,$FD,$72,$31,$06,$00,$00,$00)),
		(Extension: 'OFGA';  StructID: 544; Name: 'Object Furn Geom Array';  IdentWin:($62,$C3,$FA,$74,$13,$00,$00,$00);  IdentMac:($62,$C3,$FA,$74,$13,$00,$00,$00)),
		(Extension: 'OBLS';  StructID: 545; Name: 'Object LS Data';  IdentWin:($3D,$70,$0B,$00,$00,$00,$00,$00);  IdentMac:($3D,$70,$0B,$00,$00,$00,$00,$00)),
		(Extension: 'TRIG';  StructID: 546; Name: 'Trigger';  IdentWin:($2C,$CD,$D0,$DC,$21,$00,$00,$00);  IdentMac:($2C,$CD,$D0,$DC,$21,$00,$00,$00)),
		(Extension: 'TRGE';  StructID: 547; Name: 'Trigger Emitter';  IdentWin:($3C,$B9,$A6,$71,$08,$00,$00,$00);  IdentMac:($3C,$B9,$A6,$71,$08,$00,$00,$00)),
		(Extension: 'TURR';  StructID: 548; Name: 'Turret';  IdentWin:($BE,$05,$58,$C8,$49,$00,$00,$00);  IdentMac:($BE,$05,$58,$C8,$49,$00,$00,$00)),
		(Extension: 'OBAN';  StructID: 549; Name: 'Object animation';  IdentWin:($24,$0C,$4E,$00,$00,$00,$00,$00);  IdentMac:($24,$0C,$4E,$00,$00,$00,$00,$00)),
		(Extension: 'OBDC';  StructID: 550; Name: 'Door class array';  IdentWin:($0B,$CA,$9E,$BD,$07,$00,$00,$00);  IdentMac:($0B,$CA,$9E,$BD,$07,$00,$00,$00)),
		(Extension: 'OBOA';  StructID: 551; Name: 'Starting Object Array';  IdentWin:($E1,$86,$89,$4F,$13,$00,$00,$00);  IdentMac:($E1,$86,$89,$4F,$13,$00,$00,$00)),
		(Extension: 'CBPI';  StructID: 552; Name: 'Character Body Part Impacts';  IdentWin:($C2,$D6,$F9,$0B,$0C,$00,$00,$00);  IdentMac:($C2,$D6,$F9,$0B,$0C,$00,$00,$00)),
		(Extension: 'CBPM';  StructID: 553; Name: 'Character Body Part Material';  IdentWin:($1F,$35,$A4,$6B,$02,$00,$00,$00);  IdentMac:($1F,$35,$A4,$6B,$02,$00,$00,$00)),
		(Extension: 'ONCC';  StructID: 554; Name: 'Oni Character Class';  IdentWin:($EF,$59,$C7,$AA,$A5,$04,$00,$00);  IdentMac:($EF,$59,$C7,$AA,$A5,$04,$00,$00)),
		(Extension: 'ONIA';  StructID: 555; Name: 'Oni Character Impact Array';  IdentWin:($9A,$2F,$2B,$00,$00,$00,$00,$00);  IdentMac:($9A,$2F,$2B,$00,$00,$00,$00,$00)),
		(Extension: 'ONCP';  StructID: 556; Name: 'Oni Character Particle Array';  IdentWin:($21,$73,$2F,$00,$00,$00,$00,$00);  IdentMac:($21,$73,$2F,$00,$00,$00,$00,$00)),
		(Extension: 'ONCV';  StructID: 557; Name: 'Oni Character Variant';  IdentWin:($F5,$99,$02,$00,$00,$00,$00,$00);  IdentMac:($F5,$99,$02,$00,$00,$00,$00,$00)),
		(Extension: 'CRSA';  StructID: 558; Name: 'Corpse Array';  IdentWin:($CC,$D4,$43,$15,$0C,$00,$00,$00);  IdentMac:($CC,$D4,$43,$15,$0C,$00,$00,$00)),
		(Extension: 'DPge';  StructID: 559; Name: 'Diary Page';  IdentWin:($6B,$68,$8A,$BA,$07,$00,$00,$00);  IdentMac:($6B,$68,$8A,$BA,$07,$00,$00,$00)),
		(Extension: 'FILM';  StructID: 560; Name: 'Film';  IdentWin:($AD,$62,$1B,$33,$0B,$00,$00,$00);  IdentMac:($AD,$62,$1B,$33,$0B,$00,$00,$00)),
		(Extension: 'ONFA';  StructID: 561; Name: 'Imported Flag Node Array';  IdentWin:($E7,$0C,$1B,$00,$00,$00,$00,$00);  IdentMac:($E7,$0C,$1B,$00,$00,$00,$00,$00)),
		(Extension: 'ONGS';  StructID: 562; Name: 'Oni Game Settings';  IdentWin:($B6,$EB,$26,$02,$00,$00,$00,$00);  IdentMac:($B6,$EB,$26,$02,$00,$00,$00,$00)),
		(Extension: 'HPge';  StructID: 563; Name: 'Help Page';  IdentWin:($3B,$71,$2F,$4B,$04,$00,$00,$00);  IdentMac:($3B,$71,$2F,$4B,$04,$00,$00,$00)),
		(Extension: 'IGHH';  StructID: 564; Name: 'IGUI HUD Help';  IdentWin:($DE,$58,$8E,$E5,$08,$00,$00,$00);  IdentMac:($DE,$58,$8E,$E5,$08,$00,$00,$00)),
		(Extension: 'IGPG';  StructID: 565; Name: 'IGUI Page';  IdentWin:($7D,$88,$67,$CE,$11,$00,$00,$00);  IdentMac:($7D,$88,$67,$CE,$11,$00,$00,$00)),
		(Extension: 'IGPA';  StructID: 566; Name: 'IGUI Page Array';  IdentWin:($05,$09,$BE,$DD,$04,$00,$00,$00);  IdentMac:($05,$09,$BE,$DD,$04,$00,$00,$00)),
		(Extension: 'IGSt';  StructID: 567; Name: 'IGUI String';  IdentWin:($25,$77,$A4,$A2,$02,$00,$00,$00);  IdentMac:($25,$77,$A4,$A2,$02,$00,$00,$00)),
		(Extension: 'IGSA';  StructID: 568; Name: 'IGUI String Array';  IdentWin:($08,$A4,$BE,$DD,$04,$00,$00,$00);  IdentMac:($08,$A4,$BE,$DD,$04,$00,$00,$00)),
		(Extension: 'IPge';  StructID: 569; Name: 'Item Page';  IdentWin:($BA,$69,$83,$93,$02,$00,$00,$00);  IdentMac:($BA,$69,$83,$93,$02,$00,$00,$00)),
		(Extension: 'KeyI';  StructID: 570; Name: 'Key Icons';  IdentWin:($AD,$57,$47,$3F,$40,$00,$00,$00);  IdentMac:($AD,$57,$47,$3F,$40,$00,$00,$00)),
		(Extension: 'ONLV';  StructID: 571; Name: 'Oni Game Level';  IdentWin:($A3,$2E,$9A,$B7,$7D,$00,$00,$00);  IdentMac:($A3,$2E,$9A,$B7,$7D,$00,$00,$00)),
		(Extension: 'ONLD';  StructID: 572; Name: 'Oni Game Level Descriptor';  IdentWin:($A1,$12,$04,$00,$00,$00,$00,$00);  IdentMac:($A1,$12,$04,$00,$00,$00,$00,$00)),
		(Extension: 'ONMA';  StructID: 573; Name: 'Imported Marker Node Array';  IdentWin:($79,$47,$12,$00,$00,$00,$00,$00);  IdentMac:($79,$47,$12,$00,$00,$00,$00,$00)),
		(Extension: 'ONOA';  StructID: 574; Name: 'Object Gunk Array';  IdentWin:($7C,$5C,$E7,$4B,$06,$00,$00,$00);  IdentMac:($7C,$5C,$E7,$4B,$06,$00,$00,$00)),
		(Extension: 'OPge';  StructID: 575; Name: 'Objective Page';  IdentWin:($FB,$BB,$30,$4B,$04,$00,$00,$00);  IdentMac:($FB,$BB,$30,$4B,$04,$00,$00,$00)),
		(Extension: 'ONSK';  StructID: 576; Name: 'Oni Sky class';  IdentWin:($67,$10,$26,$C2,$14,$00,$00,$00);  IdentMac:($67,$10,$26,$C2,$14,$00,$00,$00)),
		(Extension: 'ONSA';  StructID: 577; Name: 'Imported Spawn Array';  IdentWin:($34,$46,$04,$00,$00,$00,$00,$00);  IdentMac:($34,$46,$04,$00,$00,$00,$00,$00)),
		(Extension: 'TxtC';  StructID: 578; Name: 'Text Console';  IdentWin:($27,$8B,$AC,$B7,$01,$00,$00,$00);  IdentMac:($27,$8B,$AC,$B7,$01,$00,$00,$00)),
		(Extension: 'ONTA';  StructID: 579; Name: 'Trigger Array';  IdentWin:($C0,$FC,$A0,$00,$00,$00,$00,$00);  IdentMac:($C0,$FC,$A0,$00,$00,$00,$00,$00)),
		(Extension: 'ONVL';  StructID: 580; Name: 'Oni Variant List';  IdentWin:($8A,$C5,$34,$44,$05,$00,$00,$00);  IdentMac:($8A,$C5,$34,$44,$05,$00,$00,$00)),
		(Extension: 'WPge';  StructID: 581; Name: 'Weapon Page';  IdentWin:($B5,$89,$58,$6F,$04,$00,$00,$00);  IdentMac:($B5,$89,$58,$6F,$04,$00,$00,$00)),
		(Extension: 'OSBD';  StructID: 582; Name: 'Oni Sound Binary Data';  IdentWin:($6C,$DB,$00,$00,$00,$00,$00,$00);  IdentMac:($3C,$5E,$01,$00,$00,$00,$00,$00)),
		(Extension: 'PSpc';  StructID: 583; Name: 'Part Specification';  IdentWin:($48,$26,$08,$00,$00,$00,$00,$00);  IdentMac:($48,$26,$08,$00,$00,$00,$00,$00)),
		(Extension: 'PSpL';  StructID: 584; Name: 'Part Specification List';  IdentWin:($05,$CC,$0C,$00,$00,$00,$00,$00);  IdentMac:($05,$CC,$0C,$00,$00,$00,$00,$00)),
		(Extension: 'PSUI';  StructID: 585; Name: 'Part Specifications UI';  IdentWin:($FB,$96,$4E,$54,$CD,$03,$00,$00);  IdentMac:($FB,$96,$4E,$54,$CD,$03,$00,$00)),
		(Extension: 'SNDD';  StructID: 586; Name: 'Sound Data';  IdentWin:($78,$05,$37,$00,$00,$00,$00,$00);  IdentMac:($EB,$11,$04,$00,$00,$00,$00,$00)),
		(Extension: 'SUBT';  StructID: 587; Name: 'Subtitle Array';  IdentWin:($68,$6C,$04,$00,$00,$00,$00,$00);  IdentMac:($68,$6C,$04,$00,$00,$00,$00,$00)),
		(Extension: 'UUEA';  StructID: 588; Name: 'Error Binding Array';  IdentWin:($BC,$EE,$0A,$00,$00,$00,$00,$00);  IdentMac:($BC,$EE,$0A,$00,$00,$00,$00,$00)),
		(Extension: 'TMFA';  StructID: 589; Name: 'Float Array';  IdentWin:($24,$53,$02,$00,$00,$00,$00,$00);  IdentMac:($24,$53,$02,$00,$00,$00,$00,$00)),
		(Extension: 'IDXA';  StructID: 590; Name: 'Index Array';  IdentWin:($8F,$70,$02,$00,$00,$00,$00,$00);  IdentMac:($8F,$70,$02,$00,$00,$00,$00,$00)),
		(Extension: 'TStr';  StructID: 591; Name: 'String';  IdentWin:($A0,$64,$00,$00,$00,$00,$00,$00);  IdentMac:($A0,$64,$00,$00,$00,$00,$00,$00)),
		(Extension: 'StNA';  StructID: 592; Name: 'String Array';  IdentWin:($20,$B5,$8C,$99,$05,$00,$00,$00);  IdentMac:($20,$B5,$8C,$99,$05,$00,$00,$00)),
		(Extension: 'TMRA';  StructID: 593; Name: 'Template Reference Array';  IdentWin:($21,$35,$07,$00,$00,$00,$00,$00);  IdentMac:($21,$35,$07,$00,$00,$00,$00,$00)),
		(Extension: 'TRAS';  StructID: 594; Name: 'Totoro Aiming Screen';  IdentWin:($30,$A9,$21,$FA,$01,$00,$00,$00);  IdentMac:($30,$A9,$21,$FA,$01,$00,$00,$00)),
		(Extension: 'TRAM';  StructID: 595; Name: 'Totoro Animation Sequence';  IdentWin:($18,$C9,$3C,$7E,$10,$00,$00,$00);  IdentMac:($18,$C9,$3C,$7E,$10,$00,$00,$00)),
		(Extension: 'TRAC';  StructID: 596; Name: 'Animation Collection';  IdentWin:($2F,$FB,$E9,$26,$0F,$00,$00,$00);  IdentMac:($2F,$FB,$E9,$26,$0F,$00,$00,$00)),
		(Extension: 'TRCM';  StructID: 597; Name: 'Totoro Quaternion Body';  IdentWin:($4E,$05,$DE,$92,$23,$00,$00,$00);  IdentMac:($4E,$05,$DE,$92,$23,$00,$00,$00)),
		(Extension: 'TRBS';  StructID: 598; Name: 'Totoro Body Set';  IdentWin:($39,$42,$92,$A2,$02,$00,$00,$00);  IdentMac:($39,$42,$92,$A2,$02,$00,$00,$00)),
		(Extension: 'TRMA';  StructID: 599; Name: 'Texture Map Array';  IdentWin:($57,$6D,$DE,$99,$05,$00,$00,$00);  IdentMac:($57,$6D,$DE,$99,$05,$00,$00,$00)),
		(Extension: 'TRFT';  StructID: 600; Name: 'Totoro Facing Table';  IdentWin:($AF,$21,$02,$00,$00,$00,$00,$00);  IdentMac:($AF,$21,$02,$00,$00,$00,$00,$00)),
		(Extension: 'TRGA';  StructID: 601; Name: 'Totoro Quaternion Body Geometry Array';  IdentWin:($F8,$20,$6B,$20,$05,$00,$00,$00);  IdentMac:($F8,$20,$6B,$20,$05,$00,$00,$00)),
		(Extension: 'TRIA';  StructID: 602; Name: 'Totoro Quaternion Body Index Array';  IdentWin:($82,$C4,$0A,$00,$00,$00,$00,$00);  IdentMac:($82,$C4,$0A,$00,$00,$00,$00,$00)),
		(Extension: 'TRSC';  StructID: 603; Name: 'Screen (aiming) Collection';  IdentWin:($17,$6B,$78,$99,$05,$00,$00,$00);  IdentMac:($17,$6B,$78,$99,$05,$00,$00,$00)),
		(Extension: 'TRTA';  StructID: 604; Name: 'Totoro Quaternion Body Translation Array';  IdentWin:($E8,$59,$07,$00,$00,$00,$00,$00);  IdentMac:($E8,$59,$07,$00,$00,$00,$00,$00)),
		(Extension: 'TSFT';  StructID: 605; Name: 'Font';  IdentWin:($EA,$DE,$91,$BA,$16,$00,$00,$00);  IdentMac:($EA,$DE,$91,$BA,$16,$00,$00,$00)),
		(Extension: 'TSFF';  StructID: 606; Name: 'Font Family';  IdentWin:($8A,$48,$6C,$8A,$0A,$00,$00,$00);  IdentMac:($8A,$48,$6C,$8A,$0A,$00,$00,$00)),
		(Extension: 'TSFL';  StructID: 607; Name: 'Font Language';  IdentWin:($29,$DE,$08,$00,$00,$00,$00,$00);  IdentMac:($29,$DE,$08,$00,$00,$00,$00,$00)),
		(Extension: 'TSGA';  StructID: 608; Name: 'Glyph Array';  IdentWin:($98,$4E,$2A,$00,$00,$00,$00,$00);  IdentMac:($98,$4E,$2A,$00,$00,$00,$00,$00)),
		(Extension: 'UVDL';  StructID: 609; Name: 'UV Data List';  IdentWin:($E5,$16,$0A,$00,$00,$00,$00,$00);  IdentMac:($E5,$16,$0A,$00,$00,$00,$00,$00)),
		(Extension: 'WMCL';  StructID: 610; Name: 'WM Cursor List';  IdentWin:($76,$D0,$09,$00,$00,$00,$00,$00);  IdentMac:($76,$D0,$09,$00,$00,$00,$00,$00)),
		(Extension: 'WMDD';  StructID: 611; Name: 'WM Dialog Data';  IdentWin:($C4,$F3,$1D,$00,$1C,$00,$00,$00);  IdentMac:($C4,$F3,$1D,$00,$1C,$00,$00,$00)),
		(Extension: 'WMMB';  StructID: 612; Name: 'WM Menu Bar';  IdentWin:($37,$67,$0C,$D2,$06,$00,$00,$00);  IdentMac:($37,$67,$0C,$D2,$06,$00,$00,$00)),
		(Extension: 'WMM_';  StructID: 613; Name: 'WM Menu';  IdentWin:($38,$1A,$0C,$00,$00,$00,$00,$00);  IdentMac:($38,$1A,$0C,$00,$00,$00,$00,$00)),
		(Extension: 'ONWC';  StructID: 614; Name: 'Oni Weapon Class';  IdentWin:($B5,$EE,$E0,$A3,$93,$01,$00,$00);  IdentMac:($B5,$EE,$E0,$A3,$93,$01,$00,$00))
	);


implementation

end.
