unit TXAN;

interface

uses
  _FileTypes;

type
  TFile_TXAN = class(TFile)
    public
      procedure InitDataFields; override;
  end;

implementation

uses
  ConnectionManager, Math, Classes, TypeDefs, _DataTypes;

procedure TFile_TXAN.InitDataFields;
begin
  inherited;
  FDataFields := TBlock.Create(Self, nil, 'Base', '', []);
  with FDataFields do
  begin
    AddField(TFileID, 'FileID', '', []);

    AddField(TLevelID, 'LevelID', '', []);

    AddField(TUnused, 'Unused data', '', [12]);

    AddField(TInt, 'Loop speed', '', [2]);
    AddField(TInt, 'Unknown', '', [2]);
    AddField(TInt, 'Unknown', '', [2]);
    AddField(TUnused, 'Unused', '', [2]);

    with TArray(AddField(TArray, 'AnimTextures array', '', [4])) do
    begin
      AddField(TLinkByID, 'Texture', '', ['TXMP']);
      SetCount;
    end;
  end;
  FDataFields.Update(0, -1);
  FFileStream.Free;
  FFileStream := nil;
end;


end.
