unit AKEV;

interface

uses
  _FileTypes;

type
  TFile_AKEV = class(TFile)
    public
      procedure InitDataFields; override;
  end;

implementation

uses
  ConnectionManager, Math, Classes, TypeDefs, _DataTypes, Forms, StdCtrls;

procedure TFile_AKEV.InitDataFields;
begin
  inherited;
  FDataFields := TBlock.Create(Self, nil, 'Base', '', []);
  with FDataFields do
  begin
    AddField(TFileID, 'FileID', '', []);
    AddField(TLevelID, 'LevelID', '', []);

    AddField(TLinkByID, 'PNTA-link', 'Link to the 3D Point Array', ['PNTA']);
    AddField(TLinkByID, 'PLEA-link', 'Link to the Plane Equation Array', ['PLEA']);
    AddField(TLinkByID, 'TXCA-link', 'Link to the Texture Coordinate Array', ['TXCA']);
    AddField(TLinkByID, 'AGQG-link', 'Link to the Gunk Quad General Array', ['AGQG']);

    AddField(TLinkByID, 'AGQR-link', 'Link to the Gunk Quad Render Array', ['AGQR']);
    AddField(TLinkByID, 'AGQC-link', 'Link to the Gunk Quad Collision Array', ['AGQC']);
    AddField(TLinkByID, 'AGDB-link', 'Link to the Gunk Quad Debug Array', ['AGDB']);
    AddField(TLinkByID, 'TXMA-link', 'Link to the Texture Map Array', ['TXMA']);

    AddField(TLinkByID, 'AKVA-link', 'Link to the BNV Node Array', ['AKVA']);
    AddField(TLinkByID, 'AKBA-link', 'Link to the Side Array', ['AKBA']);
    AddField(TLinkByID, 'IDXA-link', 'Link to the Index Array', ['IDXA']);
    AddField(TLinkByID, 'IDXA-link', 'Link to the Index Array', ['IDXA']);

    AddField(TLinkByID, 'AKBP-link', 'Link to the BSP Node Array', ['AKBP']);
    AddField(TLinkByID, 'ABNA-link', 'Link to the BSP Tree Node Array', ['ABNA']);
    AddField(TLinkByID, 'AKOT-link', 'Link to the Oct Tree', ['AKOT']);
    AddField(TLinkByID, 'AKAA-link', 'Link to the Adjacency Array', ['AKAA']);

    AddField(TLinkByID, 'AKDA-link', 'Link to the Door Frame Array', ['AKDA']);


    AddField(TFloat, 'Neg. x-coordinate', 'Maximal negative x-coordinate of the level model', []);
    AddField(TFloat, 'Neg. y-coordinate', 'Maximal negative y-coordinate of the level model', []);
    AddField(TFloat, 'Neg. z-coordinate', 'Maximal negative z-coordinate of the level model', []);

    AddField(TFloat, 'Pos. x-coordinate', 'Maximal positive x-coordinate of the level model', []);
    AddField(TFloat, 'Pos. y-coordinate', 'Maximal positive y-coordinate of the level model', []);
    AddField(TFloat, 'Pos. z-coordinate', 'Maximal positive z-coordinate of the level model', []);

    AddField(TUnused, 'Not used', '', [1024]);
    AddField(TFloat, 'Unknown', 'Unknown; maybe the tolerance', []);
  end;
  FDataFields.Update(0, -1);
  FFileStream.Free;
  FFileStream := nil;
end;


end.
