unit SUBT;

interface

uses
  _FileTypes, Grids, StdCtrls, ExtCtrls;

type
  TFile_SUBT = class(TFile)
      procedure SetOpened(Opened: Boolean); override;
    private
      grid: TStringGrid;
      panel: TPanel;
      save: TButton;
      procedure saveclick(Sender: TObject); 
    public
      procedure InitDataFields; override;
      procedure InitEditor; override;
  end;

implementation

uses
  ConnectionManager, Math, Classes, TypeDefs, _DataTypes, Forms,
  Controls;

procedure TFile_SUBT.InitDataFields;
begin
  inherited;
  FDataFields := TBlock.Create(Self, nil, 'Base', '', []);
  with FDataFields do
  begin
    AddField(TFileID, 'FileID', '', []);
    AddField(TLevelID, 'LevelID', '', []);
    AddField(TUnused, 'Unused data', '', [16]);

    AddField(TRawLink, 'Raw Address', '', ['SUBT']);

    with TArray(AddField(TArray, 'SUBT offsets array', '', [4])) do
    begin
      AddField(TInt, 'Offset', '', [4]);
      SetCount;
    end;
  end;
  FDataFields.Update(0, -1);

  FFileStream.Free;
  FFileStream := nil;
end;

procedure TFile_SUBT.InitEditor;
begin
  FEditor := TFrame.Create(nil);
  grid := TStringGrid.Create(FEditor);
  grid.Align := alClient;
  grid.DefaultRowHeight := 18;
  grid.DefaultColWidth := 100;
  grid.ColCount := 2;
  grid.RowCount := 4;
  grid.FixedRows := 1;
  grid.FixedCols := 0;
  grid.ColWidths[0] := 80;
  grid.ColWidths[1] := 200;
  grid.Cells[0, 0] := 'Name';
  grid.Cells[1, 0] := 'Content';
  grid.Options := [goColSizing,goEditing,
      goVertLine,goHorzLine,goFixedVertLine,goFixedHorzLine];
  grid.Parent := FEditor;
  panel := TPanel.Create(FEditor);
  panel.Align := alBottom;
  panel.Height := 30;
  panel.Parent := FEditor;
  save := TButton.Create(panel);
  save.Top := 2;
  save.Left := 2;
  save.Width := 100;
  save.Height := 26;
  save.Caption := 'Save';
  save.OnClick := saveclick;
  save.Parent := panel;
end;

procedure TFile_SUBT.saveclick(Sender: TObject);
var
  i,j: Integer;
  temps: String;
  fs: TFileStream;
  offset: Integer;
begin
  fs := TFileStream.Create('C:\Spiele\Oni\GameDataFolder\tests\messages_raw_recreated.hex', fmCreate);

  i := grid.RowCount - 2;
  FFileStream.Seek($1C, soFromBeginning);
  FFileStream.Write(i, 4);
  FFileStream.Size := $20 + i * 4; 
  
  for i := 0 to grid.RowCount - 2 do
  begin
    for j := 0 to 1 do
    begin
      if j = 0 then
      begin
        offset := fs.Size;
        FFileStream.Seek($20 + i*4, soFromBeginning);
        FFileStream.Write(offset, 4);
      end;
      temps := grid.Cells[j, i+1];
      SetLength(temps, Length(temps)+1);
      temps[Length(temps)] := #0;
      fs.Write(temps[1], Length(temps));
    end;
  end;
  fs.Free;
  fs := TFileStream.Create('C:\Spiele\Oni\GameDataFolder\tests\messages_dat_recreated.hex', fmCreate);
  ReCreateFile(fs);
  fs.Free;
end;


procedure TFile_SUBT.SetOpened(Opened: Boolean);
var
  i,j: Integer;
  offset: Integer;
  temps: String;
  pos: Integer;
begin
  inherited;
  if Opened then
  begin
    CacheFile;
    CacheAllRawFiles;

    FFileStream.Seek($1C, soFromBeginning);
    FFileStream.Read(i, 4);

    grid.RowCount := 1 + i;

    for i := 0 to grid.RowCount - 2 do
    begin
      for j := 0 to 1 do
      begin
        if j = 0 then
        begin
          FFileStream.Seek($20 + i*4, soFromBeginning);
          FFileStream.Read(offset, 4);
          FRawCaches[0].RawStream.Seek(offset, soFromBeginning);
        end;
        SetLength(temps, 200);
        pos := 0;
        repeat
          Inc(pos);
          FRawCaches[0].RawStream.Read(temps[pos], 1);
        until temps[pos] = #0;
        SetLength(temps, pos - 1);
        grid.Cells[j, i+1] := temps;
      end;
    end;

  end else
  begin
    Exit;
  end;
end;

end.
