unit TXMP;

interface

uses
  _FileTypes;

type
  TFile_TXMP = class(TResource)
    public
      procedure InitDataFields; override;
      procedure InitEditor; override;
  end;

implementation

uses
  ConnectionManager, Math, Classes, TypeDefs, _DataTypes, ExtCtrls, StdCtrls,
  Controls, Forms;

{ TFile_TXMP }

procedure TFile_TXMP.InitDataFields;
begin
  inherited;
  FDataFields := TBlock.Create(Self, nil, 'Base', '', []);
  with FDataFields do
  begin
    AddField(TResourceID, 'FileID', '', []);
    AddField(TLevelID, 'LevelID', '', []);

    AddField(TString, 'FileName', '', [128]);

    AddField(TBitSet, 'Flags1', '',
        ['MipMapping enabled', 'unknown', 'U wrapping disabled',
         'V wrapping disabled', 'EnvMapped/EnvMap', 'unused',
         'Play anim back to back', 'Random anim order + frame time']);

    AddField(TBitSet, 'Flags2', '',
        ['Random anim time offset', 'High byte as EnvMap', 'High byte as alpha',
         'Different alpha formula', 'Data swapping (always set)', 'used at runtime',
         'TXAN looping on/off', '16 bit blue']);

    AddField(TBitSet, 'Flags3', '',
        ['16 bit alpha', '16 bit red', 'unknown', 'unknown',
         'unknown', 'unknown', 'unknown', 'unknown']);

    AddField(TBitSet, 'Flags4', '',
        ['unknown', 'unknown', 'unknown', 'unknown',
         'unknown', 'unknown', 'unknown', 'unknown']);

    AddField(TInt, 'Width', '', [2]);
    AddField(TInt, 'Height', '', [2]);
    AddField(TInt, 'StoreType', '', [4]);
    AddField(TLinkByID, 'TXAN', '', ['TXAN']);
    AddField(TLinkByID, 'TXMP', '', ['TXMP']);
    AddField(TRawLink, 'RawLink', '', ['TXMP']);
    AddField(TRawLink, 'SepLink', '', ['TXMP']);
    AddField(TUnused, 'Unused', '', [$1C]);
  end;
  FDataFields.Update(0, -1);
  FFileStream.Free;
  FFileStream := nil;
end;


procedure TFile_TXMP.InitEditor;
var
  group: TGroupBox;
  splitter: TSplitter;
begin
  inherited;
  FEditor := TFrame.Create(nil);
  group := TGroupBox.Create(FEditor);
  group.Align := alTop;
  group.Height := 150;
  group.Caption := '1. ';
  group.Parent := FEditor;

  splitter := TSplitter.Create(FEditor);
  splitter.Align := alTop;
  splitter.Top := group.Height + 10;
  splitter.AutoSnap := False;
  splitter.MinSize := 100;
  splitter.Beveled := True;
  splitter.Height := 8;
  splitter.Parent := FEditor;

  group := TGroupBox.Create(FEditor);
  group.Align := alClient;
  group.Caption := '2. ';
  group.Parent := FEditor;
end;

end.
