unit BINA;

interface

uses
  _FileTypes, Grids;

type
  TFile_BINA = class(TResource)
      procedure SetOpened(Opened: Boolean); override;
    private
      maintype: String;
      subtype: String;
      grid: TStringGrid;
(*      panel: TPanel;
      save: TButton; *)
      procedure saveclick(Sender: TObject); 
    public
      procedure InitDataFields; override;
      procedure InitEditor; override;
  end;

implementation

uses
  ConnectionManager, Math, Classes, TypeDefs, _DataTypes, Forms, StdCtrls, 
  Controls, StrUtils, Functions, SysUtils;

procedure TFile_BINA.InitDataFields;
begin
  inherited;
  FDataFields := TBlock.Create(Self, nil, 'Base', '', []);
  with FDataFields do
  begin
    AddField(TResourceID, 'FileID', '', []);
    AddField(TLevelID, 'LevelID', '', []);

    AddField(TInt, 'RawSize', 'Size of the part in the raw file', [4]);
    AddField(TRawLink, 'RawOffset', 'At this position starts the part in the raw/sep file', []);

    AddField(TUnused, 'Not used', '', [16]);
  end;
  FDataFields.Update(0, -1);
  FFileStream.Free;
  FFileStream := nil;
end;

procedure TFile_BINA.InitEditor;
var
  subsize: Integer;
begin
  CacheAllRawFiles;
  SetLength(maintype, 4);
  FRawCaches[0].RawStream.Read(maintype[1], 4);
  maintype := ReverseString(maintype);
  if maintype = 'OBJC' then
  begin
    FRawCaches[0].RawStream.Seek($0C, soFromBeginning);
    FRawCaches[0].RawStream.Read(subsize, 4);
    if subsize > 0 then
    begin
      SetLength(subtype, 4);
      FRawCaches[0].RawStream.Seek($10, soFromBeginning);
      FRawCaches[0].RawStream.Read(subtype[1], 4);
      subtype := ReverseString(subtype);
      if subtype = 'CHAR' then
      begin
      end
      else if subtype = 'CMBT' then
      begin
      end
      else if subtype = 'CONS' then
      begin
      end
      else if subtype = 'DOOR' then
      begin
      end
      else if subtype = 'FLAG' then
      begin
      end
      else if subtype = 'FURN' then
      begin
      end
      else if subtype = 'MELE' then
      begin
      end
      else if subtype = 'NEUT' then
      begin
      end
      else if subtype = 'PART' then
      begin
      end
      else if subtype = 'PATR' then
      begin
      end
      else if subtype = 'PWRU' then
      begin
      end
      else if subtype = 'SNDG' then
      begin
      end
      else if subtype = 'TRGV' then
      begin
        FEditor := TFrame.Create(nil);
        grid := TStringGrid.Create(FEditor);
        grid.Align := alClient;
        grid.DefaultRowHeight := 18;
        grid.DefaultColWidth := 100;
        grid.ColCount := 8;
        grid.RowCount := 2;
        grid.FixedRows := 1;
        grid.FixedCols := 0;
        grid.ColWidths[0] := 150;
        grid.ColWidths[1] := 125;
        grid.ColWidths[2] := 125;
        grid.ColWidths[3] := 125;
        grid.Cells[0, 0] := 'TrgName';
        grid.Cells[1, 0] := 'FuncName Enter';
        grid.Cells[2, 0] := 'FuncName Inside';
        grid.Cells[3, 0] := 'FuncName Leave';
        grid.Cells[4, 0] := 'Teams';
        grid.Cells[5, 0] := 'Settings';
        grid.Cells[6, 0] := 'X, Y, Z';
        grid.Cells[7, 0] := 'Size X, Y, Z';
        grid.Options := [goColSizing,goEditing,
            goVertLine,goHorzLine,goFixedVertLine,goFixedHorzLine];
        grid.Parent := FEditor;
      end
      else if subtype = 'TRIG' then
      begin
      end
      else if subtype = 'TURR' then
      begin
      end
      else if subtype = 'WEAP' then
      begin
      end;
    end;
  end
  else if maintype = 'ONIE' then
  begin
  end
  else if maintype = 'PAR3' then
  begin
  end
  else if maintype = 'SABD' then
  begin
  end
  else if maintype = 'TMBD' then
  begin
  end;

  DiscardAllRawCaches;

(*
  panel := TPanel.Create(FEditor);
  panel.Align := alBottom;
  panel.Height := 30;
  panel.Parent := FEditor;
  save := TButton.Create(panel);
  save.Top := 2;
  save.Left := 2;
  save.Width := 100;
  save.Height := 26;
  save.Caption := 'Save';
  save.OnClick := saveclick;
  save.Parent := panel;    *)
end;

procedure TFile_BINA.saveclick(Sender: TObject);
var
  i,j: Integer;
  temps: String;
  fs: TFileStream;
  offset: Integer;
begin
(*  fs := TFileStream.Create('C:\Spiele\Oni\GameDataFolder\tests\messages_raw_recreated.hex', fmCreate);

  i := grid.RowCount - 2;
  FFileStream.Seek($1C, soFromBeginning);
  FFileStream.Write(i, 4);
  FFileStream.Size := $20 + i * 4; 
  
  for i := 0 to grid.RowCount - 2 do
  begin
    for j := 0 to 1 do
    begin
      if j = 0 then
      begin
        offset := fs.Size;
        FFileStream.Seek($20 + i*4, soFromBeginning);
        FFileStream.Write(offset, 4);
      end;
      temps := grid.Cells[j, i+1];
      SetLength(temps, Length(temps)+1);
      temps[Length(temps)] := #0;
      fs.Write(temps[1], Length(temps));
    end;
  end;
  fs.Free;
  fs := TFileStream.Create('C:\Spiele\Oni\GameDataFolder\tests\messages_dat_recreated.hex', fmCreate);
  ReCreateFile(fs);
  fs.Free;
*)end;


procedure TFile_BINA.SetOpened(Opened: Boolean);
var
  i: Integer;
  cursize: Integer;
  curoffset: Integer;
  raw: TMemoryStream;
  tempi: Integer;
  temps: String;
  j: Integer;
  tempf: Single;
begin
  inherited;
  if Opened then
  begin
    CacheAllRawFiles;
    raw := FRawCaches[0].RawStream;

    if maintype = 'OBJC' then
    begin
      if subtype = 'TRGV' then
      begin
        i := 0;
        curoffset := $0C;
        raw.Seek(curoffset, soFromBeginning);
        raw.Read(cursize, 4);

        while cursize > 0 do
        begin
          Inc(i);
          grid.RowCount := 1 + i;
          grid.Cells[0, i] := ReadString(raw, curoffset + 4 + $24);
          grid.Cells[1, i] := ReadString(raw, curoffset + 4 + $63);
          grid.Cells[2, i] := ReadString(raw, curoffset + 4 + $83);
          grid.Cells[3, i] := ReadString(raw, curoffset + 4 + $A3);

          raw.Seek(curoffset + 4 + $C3, soFromBeginning);
          tempi := 0;
          raw.Read(tempi, 1);
          if tempi > 0 then
          begin
            temps := '';
            for j := 0 to 7 do
            begin
              if tempi and (1 shl j) > 0 then
              begin
                if Length(temps) > 0 then
                  temps := temps + ', ' + IntToStr(1 shl j)
                else
                  temps := IntToStr(1 shl j);
              end;
            end;
          end
          else
            temps := '0';
          grid.Cells[4, i] := temps;

          raw.Seek(curoffset + 4 + $15C, soFromBeginning);
          tempi := 0;
          raw.Read(tempi, 1);
          if tempi > 0 then
          begin
            temps := '';
            for j := 0 to 7 do
            begin
              if tempi and (1 shl j) > 0 then
              begin
                if Length(temps) > 0 then
                  temps := temps + ', ' + IntToStr(1 shl j)
                else
                  temps := IntToStr(1 shl j);
              end;
            end;
          end
          else
            temps := '0';
          grid.Cells[5, i] := temps;

          raw.Seek(curoffset + 4 + $0C, soFromBeginning);
          raw.Read(tempf, 4);
          temps := FormatFloat('#0', tempf);
          raw.Seek(curoffset + 4 + $10, soFromBeginning);
          raw.Read(tempf, 4);
          temps := temps + ', ' + FormatFloat('#0', tempf);
          raw.Seek(curoffset + 4 + $14, soFromBeginning);
          raw.Read(tempf, 4);
          temps := temps + ', ' + FormatFloat('#0', tempf);
          grid.Cells[6, i] := temps;

          raw.Seek(curoffset + 4 + $C7, soFromBeginning);
          raw.Read(tempf, 4);
          temps := FormatFloat('#0', tempf);
          raw.Seek(curoffset + 4 + $CB, soFromBeginning);
          raw.Read(tempf, 4);
          temps := temps + ', ' + FormatFloat('#0', tempf);
          raw.Seek(curoffset + 4 + $CF, soFromBeginning);
          raw.Read(tempf, 4);
          temps := temps + ', ' + FormatFloat('#0', tempf);
          grid.Cells[7, i] := temps;

          curoffset := curoffset + cursize + 4;
          raw.Seek(curoffset, soFromBeginning);
          raw.Read(cursize, 4);
        end;
      end;
    end;
  end else
  begin
    Exit;
  end;
end;

end.
