UNIT Unit4_Exporters;
INTERFACE
USES Classes, Dialogs, StrUtils, SysUtils, Math, Unit3_data, Unit6_imgfuncs;

PROCEDURE ExportDatFile(fileid:LongWord; filename:String);

FUNCTION ExportSNDD(fileid:LongWord; filename:String; convert:Boolean):Integer;
FUNCTION ExportTRAC(fileid:LongWord; filename:String; convert:Boolean):Integer;
FUNCTION ExportTXAN(fileid:LongWord; filename:String; convert:Boolean):Integer;
FUNCTION ExportTXMB(fileid:LongWord; filename:String; convert:Boolean):Integer;
FUNCTION ExportTXMP(fileid:LongWord; filename:String; convert:Boolean):Integer;
VAR
  ExportHandlers:Array[1..1] OF TExportHandlers=(
//    (Ext:'ABNA'; needed:False),
    //(Ext:'AGDB'; needed:False),
    (Ext:'SNDD'; needed:True; Handler:ExportSNDD)
{    (Ext:'TRAC'; needed:True; Handler:ExportTRAC),
    (Ext:'TXAN'; needed:True; Handler:ExportTXAN),
    (Ext:'TXMB'; needed:True; Handler:ExportTXMB),
    (Ext:'TXMP'; needed:True; Handler:ExportTXMP)
}  );



IMPLEMENTATION
USES Unit2_functions;

PROCEDURE ExportDatFile(fileid:LongWord; filename:String);
  VAR
    filestream:TFileStream;
    data:Tdata;
  BEGIN
    data:=LoadDatFile(fileid);
    IF FileExists(filename) THEN BEGIN
      filestream:=TFileStream.Create(filename,fmOpenReadWrite);
      filestream.Seek(0,soFromEnd);
    END ELSE BEGIN
      filestream:=TFileStream.Create(filename,fmCreate);
    END;
    filestream.Write(data[0],Length(data));
    filestream.Free;
  END;

FUNCTION ExportSNDD;
{  CONST
    WAVheader:Array[0..0] OF Byte=(
        Ord('R'),Ord('I'),Ord('F'),Ord('F'),0,0,0,0,Ord('W'),Ord('A'),Ord('V'),Ord('E'),
        Ord('f'),Ord('m'),Ord('t'),Ord(' '),24,0,0,0,
      );
}  TYPE
    TDatData=RECORD
      {0x00}
      _fileid:LongWord;
      level:LongWord;
      Flag:LongWord;
      FormatTag:Word;
      ChanNo:Word;
      {0x10}
      SampleRate:LongWord;
      BytesPSec:LongWord;
      BPSample:LongWord;
      BitsPS:LongWord;
      {0x20}
      Unknown:Array[1..7] OF LongWord;
      Unknown2:Word;
      {0x40}
      RawSize:LongWord;
      RawPos:LongWord;
    END;
  VAR
      filestream:TFileStream;

    DatData:TDatData;
      //Wave Header Stuff
      ASCII_Group:LongWord; //"RIFF"
      WAV_Len:LongWord;
      ASCII_WAV:LongWord; //"WAVE"
      ASCII_FMT:LongWord; //"fmt "
      WAV_FMT_Len:LongWord;
      ASCII_DATA:LongWord; //"data"
      WAV_FolLen:LongWord;

      data:Tdata;
  BEGIN
      Result:=export_noerror;
    LoadDatFilePart(fileid,0,SizeOf(DatData),@DatData);
    WITH DatData DO BEGIN
        //Initializing Header vars
        ASCII_Group:=1179011410; // 'RIFF'
        WAV_Len:=RAWSize+70;
        ASCII_WAV:=1163280727;  // 'WAVE'
        ASCII_FMT:=544501094;   // 'fmt '
        WAV_FMT_Len:=50;        // 50 bytes
        ASCII_DATA:=1635017060; // 'data'
        WAV_FolLen:=RAWSize;
        SetLength(data,RAWSize);
        LoadRawFile(fileid,$44,rawpos,Length(data),data);

      filestream:=TFileStream.Create(filename+'.raw',fmCreate);
      filestream.Write(data[0],Length(data));
      filestream.Free;

      IF convert THEN BEGIN
          //Now start packing this into a neat wave...
        filestream:=TFileStream.Create(filename+'.wav',fmCreate);
          filestream.Write(ASCII_Group,SizeOf(ASCII_Group));
          filestream.Write(WAV_Len,SizeOf(WAV_Len));
          filestream.Write(ASCII_WAV,SizeOf(ASCII_WAV));
          filestream.Write(ASCII_FMT,SizeOf(ASCII_FMT));
          filestream.Write(WAV_FMT_Len,SizeOf(WAV_FMT_Len));
          filestream.Write(ChanNo,SizeOf(ChanNo));
          filestream.Write(Samplerate,SizeOf(Samplerate));
          filestream.Write(BytesPSec,SizeOf(BytesPSec));
          filestream.Write(BPSample,SizeOf(BPSample));
          filestream.Write(BitsPS,SizeOf(BitsPS));
          filestream.Write(Unknown[1],SizeOf(Unknown));
          filestream.Write(Unknown2,SizeOf(Unknown2));
          filestream.Write(ASCII_DATA,SizeOf(ASCII_DATA));
          filestream.Write(WAV_FolLen,SizeOf(WAV_FolLen));
          filestream.Write(data[0],Length(data));
          filestream.Free;
      END;
    END;
  END;

FUNCTION ExportTRAC;
  VAR
    link:LongWord;
    linkcount:Word;
    i:LongWord;
  BEGIN
    Result:=export_noerror;

    LoadDatFilePart(fileid,$18,SizeOf(link),@link);
    link:=link DIV 256;

    LoadDatFilePart(fileid,$1E,SizeOf(linkcount),@linkcount);
    FOR i:=1 TO linkcount DO BEGIN
      LoadDatFilePart(fileid,$20+(i-1)*12+8,SizeOf(link),@link);
      link:=link DIV 256;
    END;
  END;

FUNCTION ExportTXAN;
  VAR
    loop_speed,unknown:Word;
    linkcount:LongWord;
    link:LongWord;
    i:Byte;
  BEGIN
    Result:=export_noerror;

    LoadDatFilePart(fileid,$14,SizeOf(loop_speed),@loop_speed);
    LoadDatFilePart(fileid,$16,SizeOf(unknown),@unknown);

    LoadDatFilePart(fileid,$1C,SizeOf(linkcount),@linkcount);
    FOR i:=0 TO linkcount-1 DO BEGIN
      LoadDatFilePart(fileid,$20+i*4,SizeOf(link),@link);
      link:=link DIV 256;
      IF link=0 THEN link:=fileid-1;
    END;
  END;

FUNCTION ExportTXMB;
  VAR
    filestream:TFileStream;
    img:TImgPackage;
    data:Tdata;
  BEGIN
    Result:=export_noerror;
    IF convert THEN BEGIN
      img:=LoadTXMBconnected(fileid);
      data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);
      filestream:=TFileStream.Create(filename+'.bmp',fmCreate);
      filestream.Write(data[0],Length(data));
      filestream.Free;
    END;
  END;

FUNCTION ExportTXMP;
  VAR
    filestream:TFileStream;
    img:TImgPackage;
  BEGIN
    Result:=export_noerror;
    img:=LoadImgData(fileid);

    filestream:=TFileStream.Create(filename+'.raw',fmCreate);
    filestream.Write(img.imgdata[0],Length(img.imgdata));
    filestream.Free;

    IF convert THEN BEGIN
      img.imgdata:=ImgdataToBMP(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);
      filestream:=TFileStream.Create(filename+'.bmp',fmCreate);
      filestream.Write(img.imgdata[0],Length(img.imgdata));
      filestream.Free;
    END;
  END;

END.