UNIT Unit10;

INTERFACE

USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Math;

TYPE
  TForm10 = Class(TForm)
    label_key: TLabel;
    label_group: TLabel;
    combo_group: TComboBox;
    label_target_char: TLabel;
    check_charid: TRadioButton;
    check_charname: TRadioButton;
    edit_char: TEdit;
    label_option: TLabel;
    combo_option: TComboBox;
    label_action: TLabel;
    combo_action: TComboBox;
    label_value: TLabel;
    label_value2: TLabel;
    edit_value: TEdit;
    edit_value2: TEdit;
    button_add: TButton;
    button_cancel: TButton;
    Check_Ctrl: TCheckBox;
    Check_Alt: TCheckBox;
    combo_keys: TComboBox;
    procedure button_addClick(Sender: TObject);
    procedure check_charnameClick(Sender: TObject);
    PROCEDURE check_charidClick(Sender: TObject);
    PROCEDURE button_cancelClick(Sender: TObject);
    PROCEDURE combo_actionChange(Sender: TObject);
    PROCEDURE combo_optionChange(Sender: TObject);
    PROCEDURE combo_groupChange(Sender: TObject);
    PROCEDURE FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    PROCEDURE InitStuff(LoadHotKey:Byte);
  PRIVATE
  PUBLIC
  END;

VAR
  Form10: TForm10;

IMPLEMENTATION

USES Unit1,Unit2,Unit3,Unit8,Unit9;

{$R *.dfm}

VAR change:Byte;

PROCEDURE TForm10.InitStuff(LoadHotKey:Byte);
  VAR i:Byte;
  BEGIN
    IF LoadHotKey=0 THEN BEGIN
      change:=0;
      Form10.Check_Ctrl.Checked:=False;
      Form10.Check_Alt.Checked:=False;
      Form10.combo_keys.Items.Clear;
      FOR i:=1 TO Length(VKKeys) DO Form10.combo_keys.Items.Add(VKKeys[i].Name);
      Form10.combo_keys.ItemIndex:=0;
      Form10.combo_group.Items.Clear;
      FOR i:=1 TO Length(HK_Target_Types) DO Form10.combo_group.Items.Add(HK_Target_Types[i]);
      Form10.combo_group.ItemIndex:=0;
      Form10.combo_groupChange(Self);
      Form10.combo_option.ItemIndex:=0;
      Form10.combo_optionChange(Self);
      Form10.combo_action.ItemIndex:=0;
      Form10.check_charid.Checked:=True;
      Form10.label_target_char.Caption:='Target char ID:';
      Form10.edit_char.Text:='';
      Form10.edit_value.Text:='0';
      Form10.edit_value2.Text:='0';
    END ELSE BEGIN
      change:=LoadHotKey;
      WITH Hotkeys.Items[LoadHotKey-1] DO BEGIN
        Form10.Check_Ctrl.Checked:=MOD_Ctrl;
        Form10.Check_Alt.Checked:=MOD_Alt;
        Form10.combo_keys.Items.Clear;
        FOR i:=1 TO Length(VKKeys) DO Form10.combo_keys.Items.Add(VKKeys[i].Name);
        Form10.combo_keys.ItemIndex:=key-1;
        Form10.combo_group.Items.Clear;
        FOR i:=1 TO Length(HK_Target_Types) DO Form10.combo_group.Items.Add(HK_Target_Types[i]);
        Form10.combo_group.ItemIndex:=Target_Type-1;
        Form10.combo_groupChange(Self);
        Form10.combo_option.ItemIndex:=Target_Item-1;
        Form10.combo_optionChange(Self);
        FOR i:=0 TO Form10.combo_action.Items.Count-1 DO BEGIN
          IF HK_Actions[Action]=Form10.combo_action.Items.Strings[i] THEN BEGIN
            Form10.combo_action.ItemIndex:=i;
            break;
          END;
        END;
        IF Target_CharName='' THEN BEGIN
          Form10.check_charid.Checked:=True;
          Form10.label_target_char.Caption:='Target char ID:';
          Form10.edit_char.Text:=IntToStr(Target_CharID);
        END ELSE BEGIN
          Form10.check_charname.Checked:=True;
          Form10.label_target_char.Caption:='Target char name:';
          Form10.edit_char.Text:=Target_CharName;
        END;
        Form10.edit_value.Text:=FloatToStr(Value);
        Form10.edit_value2.Text:=FloatToStr(Value2);
      END;
    END;
  END;

PROCEDURE TForm10.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    Form9.Enabled:=True;
    Form10.Visible:=False;
    CanClose:=False;
  END;

PROCEDURE TForm10.combo_groupChange(Sender: TObject);
  VAR i:Byte;
  BEGIN
    Form10.combo_option.Items.Clear;
    IF Pos('Global',Form10.combo_group.Items.Strings[Form10.combo_group.ItemIndex])>0 THEN BEGIN
      Form10.check_charid.Enabled:=False;
      Form10.check_charname.Enabled:=False;
      Form10.edit_char.Enabled:=False;
      Form10.label_target_char.Enabled:=False;
      FOR i:=1 TO Length(Settings) DO BEGIN
        IF Settings[i].has_box THEN
          Form10.combo_option.Items.Add(Settings[i].Item_Checkbox.Caption)
        ELSE Form10.combo_option.Items.Add(Settings[i].Item_Label.Caption);
      END;
    END;
    IF Pos('Char',Form10.combo_group.Items.Strings[Form10.combo_group.ItemIndex])>0 THEN BEGIN
      Form10.check_charid.Enabled:=True;
      Form10.check_charname.Enabled:=True;
      Form10.edit_char.Enabled:=True;
      Form10.label_target_char.Enabled:=True;
      FOR i:=1 TO Length(CharDataStuff) DO BEGIN
        Form10.combo_option.Items.Add(CharDataStuff[i].overview_name);
      END;
    END;
    Form10.combo_option.ItemIndex:=0;
    Form10.combo_optionChange(Self);
  END;

PROCEDURE TForm10.combo_optionChange(Sender: TObject);
  BEGIN
    Form10.button_add.Enabled:=True;
    Form10.combo_action.Items.Clear;
    IF Pos('Global',Form10.combo_group.Items.Strings[Form10.combo_group.ItemIndex])>0 THEN BEGIN
      IF Settings[Form10.combo_option.ItemIndex+1].has_box THEN BEGIN
        Form10.combo_action.Items.Add('Toggle');
      END;
      IF Settings[Form10.combo_option.ItemIndex+1].has_edit THEN BEGIN
        Form10.combo_action.Items.Add('Set');
        Form10.combo_action.Items.Add('Add');
        Form10.combo_action.Items.Add('Multiply');
        Form10.combo_action.Items.Add('Switch value');
      END;
    END;
    IF Pos('Char',Form10.combo_group.Items.Strings[Form10.combo_group.ItemIndex])>0 THEN BEGIN
      IF CharDataStuff[Form10.combo_option.ItemIndex+1].data_type=6 THEN BEGIN
        Form10.combo_action.Items.Add('CAN''T CHANGE');
        Form10.button_add.Enabled:=False;
      END ELSE BEGIN
        Form10.combo_action.Items.Add('Set');
        Form10.combo_action.Items.Add('Add');
        Form10.combo_action.Items.Add('Multiply');
        Form10.combo_action.Items.Add('Freeze');
        Form10.combo_action.Items.Add('Set & Freeze');
        Form10.combo_action.Items.Add('Switch value');
      END;
    END;
    Form10.combo_action.ItemIndex:=0;
    Form10.combo_actionChange(Self);
  END;

PROCEDURE TForm10.combo_actionChange(Sender: TObject);
  BEGIN
    IF ('Toggle'=Form10.combo_action.Items.Strings[Form10.combo_action.ItemIndex]) OR ('Freeze'=Form10.combo_action.Items.Strings[Form10.combo_action.ItemIndex]) THEN BEGIN
      Form10.label_value.Enabled:=False;
      Form10.label_value2.Enabled:=False;
      Form10.edit_value.Enabled:=False;
      Form10.edit_value2.Enabled:=False;
    END ELSE BEGIN
      Form10.label_value.Enabled:=True;
      Form10.edit_value.Enabled:=True;
      IF Pos('Switch',Form10.combo_action.Items.Strings[Form10.combo_action.ItemIndex])>0 THEN BEGIN
        Form10.label_value2.Enabled:=True;
        Form10.edit_value2.Enabled:=True;
      END ELSE BEGIN
        Form10.label_value2.Enabled:=False;
        Form10.edit_value2.Enabled:=False;
      END;
    END;
  END;

PROCEDURE TForm10.button_cancelClick(Sender: TObject);
  BEGIN
    Form9.Enabled:=True;
    Form10.Visible:=False;
  END;

PROCEDURE TForm10.check_charidClick(Sender: TObject);
  BEGIN
    IF Form10.check_charid.Checked THEN
      Form10.label_target_char.Caption:='Target char ID:'
    ELSE
      Form10.label_target_char.Caption:='Target char name:';
  END;

PROCEDURE TForm10.check_charnameClick(Sender: TObject);
  BEGIN
    IF Form10.check_charid.Checked THEN
      Form10.label_target_char.Caption:='Target char ID:'
    ELSE
      Form10.label_target_char.Caption:='Target char name:';
  END;

PROCEDURE TForm10.button_addClick(Sender: TObject);
  VAR i:Byte;
    dataset:HotKey;
    _temp:String;
    _tempint:Integer;
    _tempfloat:Double;
    number:Word;
    _wanted_datatype:Byte;
    _check_value2:Boolean;
  BEGIN
    //check_valid_data:
    dataset.Target_Type:=Form10.combo_group.ItemIndex+1;
    dataset.Target_Item:=Form10.combo_option.ItemIndex+1;
    FOR i:=1 TO Length(HK_Actions) DO BEGIN
      IF HK_Actions[i]=Form10.combo_action.Items.Strings[Form10.combo_action.ItemIndex] THEN BEGIN
        dataset.Action:=i;
        break;
      END;
    END;
    IF Pos('Char',HK_Target_Types[dataset.Target_Type])>0 THEN BEGIN
      IF Form10.check_charid.Checked THEN BEGIN
        IF TryStrToInt(Form10.edit_char.Text,_tempint)=False THEN BEGIN
          MessageBox(Form10.Handle,PChar('Invalid character ID!'),PChar('Error'),MB_OK);
          exit;
        END;
        IF (_tempint<0) OR (_tempint>100) THEN BEGIN
          MessageBox(Form10.Handle,PChar('Invalid character ID!'),PChar('Error'),MB_OK);
          exit;
        END;
        dataset.Target_CharID:=_tempint;
      END ELSE BEGIN
        IF (Length(Form10.edit_char.Text)<1) OR (Length(Form10.edit_char.Text)>20) THEN BEGIN
          MessageBox(Form10.Handle,PChar('Invalid character name!'),PChar('Error'),MB_OK);
          exit;
        END;
        dataset.Target_CharName:=Form10.edit_char.Text;
      END;
    END;
    IF (Pos('Toggle',HK_Actions[dataset.Action])=0) AND (Pos('Freeze value',HK_Actions[dataset.Action])=0) THEN BEGIN
      IF Pos('Global',HK_Target_Types[dataset.Target_Type])>0 THEN BEGIN
        _wanted_datatype:=Settings[Form10.combo_option.ItemIndex+1].edit_type;
      END;
      IF Pos('Char',HK_Target_Types[dataset.Target_Type])>0 THEN BEGIN
        _wanted_datatype:=CharDataStuff[Form10.combo_option.ItemIndex+1].data_type;
      END;
      IF Pos('Switch',HK_Actions[dataset.Action])>0 THEN BEGIN
        _check_value2:=True;
      END ELSE _check_value2:=False;
      CASE _wanted_datatype OF
        1..4: BEGIN
                IF TryStrToInt(Form10.edit_value.Text,_tempint) THEN BEGIN
                  dataset.Value:=_tempint;
                END ELSE BEGIN
                  MessageBox(Form10.Handle,PChar('Invalid value (has to be integer)!'),PChar('Error'),MB_OK);
                  exit;
                END;
                IF _check_value2 THEN BEGIN
                  IF TryStrToInt(Form10.edit_value2.Text,_tempint) THEN BEGIN
                    dataset.Value2:=_tempint;
                  END ELSE BEGIN
                    MessageBox(Form10.Handle,PChar('Invalid value2 (has to be integer)!'),PChar('Error'),MB_OK);
                    exit;
                  END;
                END;
              END;
        5:    BEGIN
                IF TryStrToFloat(Form10.edit_value.Text,_tempfloat) THEN BEGIN
                  dataset.Value:=_tempfloat;
                END ELSE BEGIN
                  MessageBox(Form10.Handle,PChar('Invalid value (has to be float)!'),PChar('Error'),MB_OK);
                  exit;
                END;
                IF _check_value2 THEN BEGIN
                  IF TryStrToFloat(Form10.edit_value2.Text,_tempfloat) THEN BEGIN
                    dataset.Value2:=_tempfloat;
                  END ELSE BEGIN
                    MessageBox(Form10.Handle,PChar('Invalid value2 (has to be float)!'),PChar('Error'),MB_OK);
                    exit;
                  END;
                END;
              END;
      END;
    END;
    dataset.MOD_Alt:=Form10.Check_Alt.Checked;
    dataset.MOD_Ctrl:=Form10.Check_Ctrl.Checked;
    dataset.Key:=Form10.combo_keys.ItemIndex+1;

    IF change=0 THEN BEGIN
      //check_already_exist:
      number:=65000;
      IF Hotkeys.Size>0 THEN BEGIN
        FOR i:=0 TO Hotkeys.Size-1 DO BEGIN
          WITH Hotkeys.Items[i] DO BEGIN
            IF (MOD_Alt=Form10.Check_Alt.Checked)
            AND (MOD_Ctrl=Form10.Check_Ctrl.Checked)
            AND (Key=Form10.combo_keys.ItemIndex+1) THEN BEGIN
              _temp:='Do you really want to change the hotkey "';
              IF MOD_Alt THEN _temp:=_temp+'ALT+';
              IF MOD_Ctrl THEN _temp:=_temp+'CTRL+';
              _temp:=_temp+VKKeys[Key].Name+'"?';
              IF MessageBox(Form10.Handle,PChar(_temp),PChar('Really?'),MB_OKCANCEL)=IDCANCEL THEN BEGIN
                exit;
              END;
              number:=i;
              break;
            END;
          END;
        END;
      END;
      //add/change_item:
      IF number<65000 THEN BEGIN
        Hotkeys.Items[number]:=dataset;
      END ELSE BEGIN
        Hotkeys.Size:=Hotkeys.Size+1;
        HotKeys.Items[HotKeys.Size-1]:=dataset;
      END;
    //change_item:
    END ELSE BEGIN
      WITH HotKeys.Items[change-1] DO BEGIN
        _temp:='Do you really want to change the hotkey "';
        IF MOD_Alt THEN _temp:=_temp+'ALT+';
        IF MOD_Ctrl THEN _temp:=_temp+'CTRL+';
        _temp:=_temp+VKKeys[Key].Name+'"?';
        IF MessageBox(Form10.Handle,PChar(_temp),PChar('Really?'),MB_OKCANCEL)=IDCANCEL THEN BEGIN
          exit;
        END;
      END;
      HotKeys.Items[change-1]:=dataset;
    END;
    Form10.Visible:=False;
    Form9.Enabled:=True;
    Form9.DrawTable;
  END;

END.
