UNIT Unit14;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, StrUtils;
TYPE
  TForm14 = Class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    edit_char: TEdit;
    list: TListBox;
    updown: TUpDown;
    tim_lvlcheck: TTimer;
    PROCEDURE updownClick(Sender: TObject; Button: TUDBtnType);
    PROCEDURE FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    PROCEDURE tim_lvlcheckTimer(Sender: TObject);
    PROCEDURE listClick(Sender: TObject);
  PRIVATE
    { Private declarations }
  PUBLIC
    { Public declarations }
  END;

VAR
  Form14: TForm14;

IMPLEMENTATION
USES Unit1, Unit2, Unit8;
{$R *.dfm}
VAR lvl_shown:Byte;
  modelcount:Byte;

FUNCTION patch_loader_loaded:Boolean;
  CONST check_for:LongWord=$0010656EE9;
    address_at:LongWord=$4228ED;
  BEGIN
    IF Decode_Int(ReadMem(address_at,4))=check_for THEN result:=True
    ELSE result:=False;
  END;

PROCEDURE TForm14.listClick(Sender: TObject);
  VAR model:LongWord;
    struct1:LongWord;
  BEGIN
    IF _connected AND (lvlnumber>0) AND patch_loader_loaded THEN BEGIN
      model:=Decode_Int(ReadMem($10F20+Form14.list.ItemIndex*4,4));
      struct1:=Decode_Int(ReadMem(PointerStruct1PointerArray1,4));
      struct1:=Decode_Int(ReadMem(struct1+4*StrToInt(Form14.edit_char.Text),4));
      WriteMem(struct1+$00C,4,Encode_Int(model));
    END ELSE BEGIN
      IF _connected AND (lvlnumber>0) THEN BEGIN
        MessageBox(Form14.Handle,PChar('Oni.exe is not patched.'),PChar('Error'),MB_OK);
      END;
    END;
  END;

PROCEDURE TForm14.tim_lvlcheckTimer(Sender: TObject);
  VAR i:Byte;
  BEGIN
    IF _connected AND (lvlnumber>0) AND patch_loader_loaded THEN BEGIN
      IF lvl_shown<>lvlnumber THEN BEGIN
        list.Items.Clear;
        modelcount:=Decode_Int(ReadMem($10F05,1));
        FOR i:=0 TO modelcount-1 DO BEGIN
          list.Items.Add('Model'+IntToStr(i+1)+' ('+IntToHex(Decode_Int(ReadMem($10F20+i*4,4)),8)+')');
        END;
        lvl_shown:=lvlnumber;
      END;
    END ELSE BEGIN
      list.Items.Clear;
      lvl_shown:=0;
    END;
  END;

PROCEDURE TForm14.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    Self.Visible:=False;
    CanClose:=False;
    Form1.menu_Models.Checked:=False;
  END;

PROCEDURE TForm14.updownClick(Sender: TObject; Button: TUDBtnType);
  BEGIN
    Form14.edit_char.Text:=IntToStr(updown.Position);
  END;

END.
