unit Unit8;

interface

USES StdCtrls,Buttons,Windows;

CONST version:String='0.91 beta 1';
CONST ais_controlled=30; //Number of Chars watched/controlled with this prog
CONST number_main_groups=4;
CONST number_settings=55;
CONST number_items=26; //Char-Data-Items
CONST number_char_groups=4; //Char-Windows-Groups
CONST number_structs=3; //Char-Structs

VAR _path:String;

TYPE
  TSetting = Record
    updating:Boolean;
    group:Byte;
    address:LongWord;
    has_box:Boolean;
    Item_Checkbox:TCheckBox;
    Item_Label:TLabel;
    has_edit:Boolean;
    Item_Edit:TEdit;
    edit_type:Byte;
    edit_address:LongWord;
  END;
  TSettings=Record
    group:Byte;
    caption:String;
    hint:String;
    address:LongWord;
    has_box:Boolean;
    has_edit:Boolean;
    edit_hint:String;
    edit_type:Byte;
    Edit_Address:LongWord;
  END;
TYPE
  byte_array=Array[0..250] OF Byte;
TYPE
  TValueSwitcher=Record
    CASE IsFloat: Boolean OF
      True: (ValueFloat:Single);
      False: (ValueInt:LongWord);
  END;
TYPE
  TStructItem=Record
    updating:Boolean;
    struct:Byte;
    offset:LongWord;
    data_type:Byte;
    range:Single;
    group:Byte;
    Name:String;
    overview_name:String;
    hint:String;
    Item_Edit:TEdit;
    Item_Freeze:TCheckbox;
  END;
TYPE
  TStructures=Record
    Structs:Array[1..number_structs] OF LongWord;
    Items:Array[1..number_items] OF TStructItem;
  END;
  TGroup=Record
    Name:String;
    Count:Byte;
    Item:TGroupbox;
    OpenClose:TSpeedButton;
  END;
TYPE
  Hotkey=Record
    MOD_Alt:Boolean;
    MOD_Ctrl:Boolean;
    Key:Byte;
    Target_Type:Byte;
    Target_CharID:Byte;
    Target_CharName:String[25];
    Target_Item:Byte;
    Action:Byte;
    Value:Double;
    Value2:Double;
  END;

CONST HK_Target_Types:Array[1..2] OF String=(
    'Global setting','Character setting'
  );
CONST HK_Actions:Array[1..7] OF String=(
    'Toggle','Set','Add','Multiply','Freeze','Set & Freeze','Switch value'
  );

CONST MainGroupsStuff:Array[1..number_main_groups] OF TGroup=(
    (name:'Debug Settings'),
    (name:'Environment'),
    (name:'Cheats'),
    (name:'Camera')
  );
CONST SettingsStuff:Array[1..number_settings] OF TSettings=(
    (group:1; caption:'Fast mode'; hint:'Makes the game much faster.'+Chr(13)+Chr(10)+'(Fast_Mode)'; address:$5ECE6E; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Everything breakable'; hint:'You can destroy anything with shots.'+Chr(13)+Chr(10)+'(p3_everything_breakable)'; address:$5E96B1; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Debug Characters'; hint:'Displays a little box with debug information about the selected char.'+Chr(13)+Chr(10)+'(Chr_Debug_Characters)'; address:$5ECB90; has_box:True; has_edit:True; edit_hint:'Sets which character should be debugged with ''Debug Characters''.'+Chr(13)+Chr(10)+'(char_to_debug)'; edit_type:1; edit_address:$5ECB8C),
    (group:1; caption:'Debug Overlay'; hint:'Displays a debug-message box. (Don''t know yet for what use :D)'+Chr(13)+Chr(10)+'(Chr_Debug_Overlay)'; address:$5ECB91; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Draw all Characters'; hint:'Draws all characters, even the ones who are not in Konokos view.'+Chr(13)+Chr(10)+'(Chr_Draw_All_Characters)'; address:$5ECBA2; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Character detail'; hint:'Sets the drawing detail for all characters.'+Chr(13)+Chr(10)+'(Chr_Lod)'; address:0; has_box:False; has_edit:True; edit_hint:''; edit_type:1; edit_address:$54E174),
    (group:1; caption:'Reduce screenshot size'; hint:'Reduces the screenshot size by 2^n'+Chr(13)+Chr(10)+'(Gs_Screen_Shot_Reduce)'; address:$0; has_box:False; has_edit:True; edit_hint:''; edit_type:1; edit_address:$5ECE98),
    (group:1; caption:'Open all doors'; hint:'Disables the locks of all doors.'+Chr(13)+Chr(10)+'(Door_Ignore_Locks)'; address:$5EC5F5; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Show HUD'; hint:'Enables/disables the display of the HUD.'+Chr(13)+Chr(10)+'(GS_Show_UI)'; address:$5533E0; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:1; caption:'Show names'; hint:'Shows the names of characters above their heads.'+Chr(13)+Chr(10)+'(AI2_ShowNames)'; address:$5EC0B4; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Show healths'; hint:'Shows the healths of characters above their heads.'+Chr(13)+Chr(10)+'(AI2_ShowHealth)'; address:$5EC0B5; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Show lines to AIs'; hint:'Shows lines to each AI character.'+Chr(13)+Chr(10)+'(AI2_ShowLineToChar)'; address:$5EC0B9; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Show paths'; hint:'Shows lines for the paths of AI characters.'+Chr(13)+Chr(10)+'(AI2_ShowPaths)'; address:$5EB8B0; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Show player''s BNV'; hint:'Displays the player''s BNV in a box.'+Chr(13)+Chr(10)+'(Chr_Show_BNV)'; address:$5ECB9E; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:1; caption:'Show player''s LOD'; hint:'Displays the player''s LOD in a box.'+Chr(13)+Chr(10)+'(Chr_Show_LOD)'; address:$5ECBA0; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:1; caption:'Show performance'; hint:'Displays the FPS in a box.'+Chr(13)+Chr(10)+'(Show_Performance)'; address:$5ECE74; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:1; caption:'Print AI spawn events'; hint:'Prints a message whenever an AI is spawn.'+Chr(13)+Chr(10)+'(AI2_PrintSpawn)'; address:$5EC0CD; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Debug Weapons'; hint:'Prints debugging information on any weapon activity.'+Chr(13)+Chr(10)+'(Debug_Weapons)'; address:$620130; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Pin Characters'; hint:'Pins all characters to their current position.'+Chr(13)+Chr(10)+'(Chr_Pin_Character)'; address:$5ECBA1; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'AIs ignore player'; hint:'AIs don''t attack player.'+Chr(13)+Chr(10)+'(AI2_IgnorePlayer)'; address:$5EC0C2; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Weapons don''t fade'; hint:'Does make weapons stay forever.'+Chr(13)+Chr(10)+'(Wp_Disable_Fade)'; address:$627DCC; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:1; caption:'Draw only every n-th frame'; hint:'Fastens game speed.'+Chr(13)+Chr(10)+'(Draw_Every_Frame / Draw_Every_Frame_Multiple)'; address:$5ECE6D; has_box:True; has_edit:True; edit_hint:''; edit_type:1; edit_address:$5533E4),

    (group:2; caption:'Show VertexShaders'; hint:'Toggles the use of VertexShaders.'+Chr(13)+Chr(10)+'(M3_Shade_Vertex)'; address:$556008; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:2; caption:'Show Textures'; hint:'Toggles the use of textures.'+Chr(13)+Chr(10)+'(M3_Fill_Solid)'; address:$556009; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:2; caption:'Show Environment'; hint:''+Chr(13)+Chr(10)+'(Gs_Show_Environment)'; address:$5533DC; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:2; caption:'Show Objects'; hint:''+Chr(13)+Chr(10)+'(Gs_Show_Objects)'; address:$5533DE; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:2; caption:'Show Characters'; hint:''+Chr(13)+Chr(10)+'(Gs_Show_Characters)'; address:$5533DD; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),
    (group:2; caption:'Show Particles'; hint:''+Chr(13)+Chr(10)+'(Gs_Show_Particles)'; address:$5533F0; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:0),

    //(caption:''; hint:''+Chr(13)+Chr(10)+'()'; address:$; has_box:; has_edit:; edit_hint:''; edit_type:; edit_address:$),
    (group:3; caption:'*bighead*'; hint:'Makes your head bigger.'; address:$5ECB98; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:3; caption:'*canttouchthis*'; hint:'Makes you untouchable. (You can''t be knocked down etc)'; address:$5ECE91; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:3; caption:'*elderrune*'; hint:'Health regeneration'; address:$620134; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:3; caption:'*fistsoflegend*'; hint:'Enemies get knocked away.'; address:$5ECE8F; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:3; caption:'*killmequick*'; hint:'Tougher enemies'; address:$5EB849; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:3; caption:'*liveforever*'; hint:'Makes you invincible.'; address:$5ECE92; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:3; caption:'*reservoirdogs*'; hint:'Enemies attacking their allies.'; address:$5EB848; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:3; caption:'*roughjustice*'; hint:'Faster guns.'; address:$620133; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:3; caption:'*shapeshifter*'; hint:'Lets you change your character with pressing F8 ingame.'; address:$5ECE6F; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:3; caption:'*touchofdeath*'; hint:'Kill enemies with one touch.'; address:$5ECE93; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$0),
    (group:3; caption:'Headsize'; hint:'Sets the size of the characters head.'+Chr(13)+Chr(10)+'(Chr_Big_Head, Chr_Big_Head_Amount)'; address:$5ECB98; has_box:True; has_edit:True; edit_hint:''; edit_type:5; edit_address:$54E16C),
    (group:3; caption:'Bodysize'; hint:'Sets the size of your body.'+Chr(13)+Chr(10)+'(Chr_Mini_Me, Chr_Mini_Me_Amount)'; address:$5ECB99; has_box:True; has_edit:True; edit_hint:''; edit_type:5; edit_address:$54E170),
    (group:3; caption:'Auto-aim distance'; hint:'Sets the distance in which auto-aim should work.'+Chr(13)+Chr(10)+'(Chr_Auto_Aim_Dist)'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$54E160),
    (group:3; caption:'Auto-aim angle'; hint:'Sets the angle in which auto-aim should work (in degrees).'+Chr(13)+Chr(10)+'(Chr_Auto_Aim_Arc)'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$54E15C),
    (group:3; caption:'Blocking angle'; hint:'Sets the angle in which attacks are blocked (in degrees).'+Chr(13)+Chr(10)+'(Chr_Block_Angle)'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$54E168),
    //
    (group:4; caption:'Height to feet'; hint:'Sets the height of the camera relative to your feets. (normal=15)'+Chr(13)+Chr(10)+'(CM_Height)'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$54D638),
    (group:4; caption:'Distance to player'; hint:'Sets the distance of the camera to the placer. (normal=33)'+Chr(13)+Chr(10)+'(CM_Distance)'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$54D63C),
    (group:4; caption:'Viewing angle when unarmed'; hint:'Sets of which angle (up/down) you look on the action when you''re unarmed. (normal=8)'+Chr(13)+Chr(10)+'(CM_Canter_Unarmed)'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$54D644),
    (group:4; caption:'Viewing angle when armed'; hint:'Sets of which angle (up/down) you look on the action when you''re armed. (normal=7)'+Chr(13)+Chr(10)+'(CM_Canter_Weapon)'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$54D640),
    (group:4; caption:'Actual viewing angle'; hint:'Sets of which angle (up/down) you look on the action.'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$6364D0),
    (group:4; caption:'See-Through-Walls mode'; hint:'Sets if you can see through walls if they are in the way.'+Chr(13)+Chr(10)+'(CM_Jello)'; address:$54D64C; has_box:True; has_edit:False; edit_hint:''; edit_type:0; edit_address:$),
    (group:4; caption:'Wall-transparency'; hint:'Sets how transparent walls get. (normal=20)'+Chr(13)+Chr(10)+'(CM_Jello_AMT)'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:1; edit_address:$54D650),
    (group:4; caption:'Wall-transparency-range'; hint:'Sets how much around the line between the camera and the player is made transparent. (normal=12)'+Chr(13)+Chr(10)+'(CM_Jello_Radius)'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$54D648),
    (group:4; caption:'Disable next 3 settings'; hint:'Disables the settings for the camera side'; address:$6364C0; has_box:True; has_edit:False; edit_hint:''; edit_type:$; edit_address:$),
    (group:4; caption:'Side of Konoko'; hint:'Sets of which side you look at Konoko (degrees)'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$6364C4),
    (group:4; caption:'Side of Konoko to change to'; hint:'Sets to which side the cam should move (degrees)'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$6364C8),
    (group:4; caption:'Change-speed'; hint:'Sets with which speed cam should move'; address:$; has_box:False; has_edit:True; edit_hint:''; edit_type:5; edit_address:$6364CC)
  );
CONST CharDataStuff:Array[1..number_items] OF TStructItem=(
    (struct:1; offset:$014; data_type:6; range:20; group:1; name:'Character name'; overview_name:'Character name'; hint:''),
    (struct:1; offset:$012; data_type:2; range:0; group:1; name:'Teamnumber'; overview_name:'Teamnumber'; hint:'0 = Konoko'+Chr(13)+Chr(10)+'1 = TCTF'+Chr(13)+Chr(10)+'2 = Syndicate'+Chr(13)+Chr(10)+'3 = Neutral'+Chr(13)+Chr(10)+'4 = Security Guard'+Chr(13)+Chr(10)+'5 = Rogue-Konoko'+Chr(13)+Chr(10)+'6 = Switzerland'+Chr(13)+Chr(10)+'7 = Syndicate Accessory'),
    (struct:1; offset:$010; data_type:2; range:200; group:1; name:'Modelnumber'; overview_name:'Modelnumber'; hint:''),

    (struct:1; offset:$004; data_type:1; range:0; group:2; name:'Death'; overview_name:'Death';
        hint:'0 = char alive'+Chr(13)+Chr(10)+'1 = char death but still in animation'+Chr(13)+Chr(10)+'3 = char lying on ground'+Chr(13)+Chr(10)+'7 = only a corpse'+Chr(13)+Chr(10)+'32 = unkillable'),
    (struct:1; offset:$038; data_type:4; range:10000; group:2; name:'Health'; overview_name:'Health'; hint:''),
    (struct:1; offset:$03C; data_type:4; range:10000; group:2; name:'Health normal'; overview_name:'Health normal'; hint:''),
    (struct:1; offset:$1A4; data_type:2; range:10; group:2; name:'Amount of hypos'; overview_name:'Hypos'; hint:''),
    (struct:1; offset:$1A2; data_type:2; range:10; group:2; name:'Amount of red ammo clips'; overview_name:'Red ammo clips'; hint:''),
    (struct:1; offset:$1A6; data_type:2; range:10; group:2; name:'Amount of green ammo clips'; overview_name:'Green ammo clips'; hint:''),
    (struct:1; offset:$1B8; data_type:2; range:10000; group:2; name:'Shield'; overview_name:'Shield'; hint:'Full=100'),
    (struct:1; offset:$1BA; data_type:2; range:10000; group:2; name:'Phasecloak'; overview_name:'Phasecloak'; hint:'Full=1775'),

    (struct:2; offset:$084; data_type:5; range:0; group:3; name:'x'; overview_name:'x-pos'; hint:''),
    (struct:2; offset:$088; data_type:5; range:0; group:3; name:'y (height)'; overview_name:'y-pos'; hint:''),
    (struct:2; offset:$08C; data_type:5; range:0; group:3; name:'z'; overview_name:'z-pos'; hint:''),
    (struct:1; offset:$16C; data_type:5; range:2*pi; group:3; name:'Body-facing'; overview_name:'Body-facing'; hint:'[0-360]'),
    (struct:1; offset:$170; data_type:5; range:2*pi; group:3; name:'Direction you yourself look to'; overview_name:'Looking direct.'; hint:'[0-360]'),
    (struct:3; offset:$21C0; data_type:5; range:0; group:3; name:'Azimuth'; overview_name:'Azimuth'; hint:''),
    (struct:3; offset:$0E0; data_type:1; range:0; group:3; name:'Off'; overview_name:'Off'; hint:'Sets how long you''re already over an edge'),
    (struct:3; offset:$0F6; data_type:1; range:0; group:3; name:'Air'; overview_name:'Air'; hint:'Sets how long you''re already in air'),
    (struct:2; offset:$128; data_type:1; range:0; group:3; name:'NoClipping'; overview_name:'NoClipping'; hint:'2 = NoClipping disabled'+Chr(13)+Chr(10)+'70 = NoClipping enabled'),

    (struct:1; offset:$1AA; data_type:2; range:10; group:4; name:'Amount of hypos'; overview_name:'Dropped hypos'; hint:''),
    (struct:1; offset:$1A8; data_type:2; range:10; group:4; name:'Amount of red ammo clips'; overview_name:'Dropped red ammo'; hint:''),
    (struct:1; offset:$1AC; data_type:2; range:10; group:4; name:'Amount of green ammo clips'; overview_name:'Dropped green ammo'; hint:''),
    (struct:1; offset:$1B2; data_type:1; range:1; group:4; name:'Shield'; overview_name:'Drops shield'; hint:'[1/0]'),
    (struct:1; offset:$1B3; data_type:1; range:1; group:4; name:'Phasecloak'; overview_name:'Drops phasecloak'; hint:'[1/0]'),
    (struct:1; offset:$1B4; data_type:1; range:1; group:4; name:'Special'; overview_name:'Drops special'; hint:'(like datapad in lvl1, rapelling harnes in lvl5) [1/0]')
//    (struct:1; offset:$; data_type:; range:; group:; name:''; overview_name:''; hint:''),
  );
CONST CharGroupsStuff:Array[1..number_char_groups] OF TGroup=(
    (name:'Global'),
    (name:'Inventory'),
    (name:'Position'),
    (name:'AI drops')
  );
{$INCLUDE animations}

CONST
  PointerStruct1PointerArray1:longword=$127C54;
  PointerStruct1PointerArray2:longword=$12BC34;
  PointerStruct2First:longword=$6A8740;
  PointerStruct3:longword=$127254;

TYPE
  THotKeys=Record
    Size:Byte;
    Items:Array[0..255] OF Hotkey;
  END;

VAR
  Settings: Array[1..number_settings] OF TSetting;
  MainGroups: Array[1..number_main_groups] OF TGroup;
  //Cheats: Array[1..number_cheats] OF TSetting;
  _Connected:Boolean;
  _temp:byte_array;
  _tempvalue:LongWord;
  _ValueSwitcher:TValueSwitcher;
  _ais_active: Array[0..ais_controlled] OF Boolean;
  //_hotkeys: Array OF HotKey;
  HotKeys: THotKeys;
  HotKeysFile: File of THotKeys;
  lvlnumber: Byte;

TYPE
  KeyCombo=Record
    Name:String;
    Value:Byte;
  END;

CONST lvl_mappings:Array[0..14] OF String[2]=(
    '0_','1_','2_','3_','4_','6_','8_','9_','10','11','12','13','14','18','19'
  );

CONST MOD_Alt_Key=MOD_Alt;
CONST MOD_Ctrl_Key=MOD_Control;

CONST
VKKeys:Array[1..78] OF Keycombo=(
  (Name:'0';Value:$30),
  (Name:'1';Value:$31),
  (Name:'2';Value:$32),
  (Name:'3';Value:$33),
  (Name:'4';Value:$34),
  (Name:'5';Value:$35),
  (Name:'6';Value:$36),
  (Name:'7';Value:$37),
  (Name:'8';Value:$38),
  (Name:'9';Value:$39),
  (Name:'A';Value:$41),
  (Name:'B';Value:$42),
  (Name:'C';Value:$43),
  (Name:'D';Value:$44),
  (Name:'E';Value:$45),
  (Name:'F';Value:$46),
  (Name:'G';Value:$47),
  (Name:'H';Value:$48),
  (Name:'I';Value:$49),
  (Name:'J';Value:$4A),
  (Name:'K';Value:$4B),
  (Name:'L';Value:$4C),
  (Name:'M';Value:$4D),
  (Name:'N';Value:$4E),
  (Name:'O';Value:$4F),
  (Name:'P';Value:$50),
  (Name:'Q';Value:$51),
  (Name:'R';Value:$52),
  (Name:'S';Value:$53),
  (Name:'T';Value:$54),
  (Name:'U';Value:$55),
  (Name:'V';Value:$56),
  (Name:'W';Value:$57),
  (Name:'X';Value:$58),
  (Name:'Y';Value:$59),
  (Name:'Z';Value:$5A),
  (Name:'F1';Value:$70),
  (Name:'F2';Value:$71),
  (Name:'F3';Value:$72),
  (Name:'F4';Value:$73),
  (Name:'F5';Value:$74),
  (Name:'F6';Value:$75),
  (Name:'F7';Value:$76),
  (Name:'F8';Value:$77),
  (Name:'F9';Value:$78),
  (Name:'F10';Value:$79),
  (Name:'F11';Value:$7A),
  (Name:'F12';Value:$7B),
  (Name:'Backspace';Value:$08),
  (Name:'Tab';Value:$09),
//  (Name:'Clear';Value:$0C),
  (Name:'Enter';Value:$0D),
  (Name:'Esc';Value:$1B),
  (Name:'Spacebar';Value:$20),
  (Name:'Page up';Value:$21),
  (Name:'Page down';Value:$22),
  (Name:'End';Value:$23),
  (Name:'Home';Value:$24),
  (Name:'Cursor left';Value:$25),
  (Name:'Cursor up';Value:$26),
  (Name:'Cursor right';Value:$27),
  (Name:'Cursor down';Value:$28),
  (Name:'Insert';Value:$2D),
  (Name:'Delete';Value:$2E),
//  (Name:'Help';Value:$2F),
  (Name:'NumPad0';Value:$60),
  (Name:'NumPad1';Value:$61),
  (Name:'NumPad2';Value:$62),
  (Name:'NumPad3';Value:$63),
  (Name:'NumPad4';Value:$64),
  (Name:'NumPad5';Value:$65),
  (Name:'NumPad6';Value:$66),
  (Name:'NumPad7';Value:$67),
  (Name:'NumPad8';Value:$68),
  (Name:'NumPad9';Value:$69),
  (Name:'NumPad decimal';Value:$6E),
  (Name:'NumPad add';Value:$6B),
  (Name:'NumPad subtract';Value:$6D),
  (Name:'NumPad multiply';Value:$6A),
  (Name:'NumPad divide';Value:$6F)
//  (Name:'NumPad separator';Value:$6C),
);


implementation

end.
