UNIT Unit9;

INTERFACE

USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, Math, StrUtils;

TYPE
  TForm9 = Class(TForm)
    HotKeysTable: TStringGrid;
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE HotKeysTableKeyPress(Sender: TObject; var Key: Char);
    PROCEDURE FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    PROCEDURE HotKeysTableSelectCell(Sender: TObject; ACol, ARow: Integer; var CanSelect: Boolean);
    PROCEDURE HotKeysTableDblClick(Sender: TObject);
    PROCEDURE DrawTable;
    PROCEDURE UnregisterHotkeys;
  PRIVATE
    PROCEDURE WMHotKey(VAR Msg : TWMHotKey); MESSAGE WM_HOTKEY;
  PUBLIC
  END;

VAR
  Form9: TForm9;

IMPLEMENTATION

USES Unit1, Unit2, Unit3, Unit8, Unit10;

VAR
  _sel_col:Byte;
  _sel_row:Byte;

{$R *.dfm}

PROCEDURE TForm9.HotKeysTableDblClick(Sender: TObject);
  BEGIN
    Form10.Visible:=True;
    Form9.Enabled:=False;
    IF HotKeysTable.Cells[_sel_col,_sel_row]='' THEN Form10.InitStuff(0)
    ELSE Form10.InitStuff(_sel_row);
  END;

PROCEDURE TForm9.HotKeysTableSelectCell(Sender: TObject; ACol, ARow: Integer; VAR CanSelect: Boolean);
  BEGIN
    _sel_col:=ACol;
    _sel_row:=ARow;
    CanSelect:=True;
  END;

PROCEDURE TForm9.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    Form9.Visible:=False;
    CanClose:=False;
  END;

PROCEDURE TForm9.HotKeysTableKeyPress(Sender: TObject; var Key: Char);
  VAR i:Byte;
    _temp:String;
  BEGIN
    IF key=#13 THEN BEGIN
      Form10.Visible:=True;
      Form9.Enabled:=False;
      IF HotKeysTable.Cells[_sel_col,_sel_row]='' THEN Form10.InitStuff(0)
      ELSE Form10.InitStuff(_sel_row);
    END;
    IF key=#8 THEN BEGIN
      IF NOT (Form9.HotKeysTable.Cells[0,_sel_row]='') THEN BEGIN
        _temp:='Do you really want to remove the hotkey "';
        IF Hotkeys.Items[_sel_row-1].MOD_Alt THEN _temp:=_temp+'ALT+';
        IF Hotkeys.Items[_sel_row-1].MOD_Ctrl THEN _temp:=_temp+'CTRL+';
        _temp:=_temp+VKKeys[Hotkeys.Items[_sel_row-1].Key].Name+'"?';
        IF MessageBox(Form9.Handle,PChar(_temp),PChar('Really???'),MB_OKCANCEL)=IDOK THEN BEGIN
          UnregisterHotkeys;
          IF Hotkeys.Size>1 THEN BEGIN
            FOR i:=_sel_row-1 TO Hotkeys.Size-2 DO BEGIN
              Hotkeys.Items[i]:=Hotkeys.Items[i+1];
            END;
            Hotkeys.Size:=Hotkeys.Size-1;
          END ELSE BEGIN
            IF Hotkeys.Size=1 THEN BEGIN
              Hotkeys.Size:=0;
            END;
          END;
          Form9.DrawTable;
        END;
      END;
    END;
  END;

PROCEDURE TForm9.DrawTable;
  VAR i:Byte;
    _temp:String;
    modifiers:Integer;
  BEGIN
    Form9.HotKeysTable.Cells[0,0]:='Hotkey';
    Form9.HotKeysTable.Cells[1,0]:='Target';
    Form9.HotKeysTable.Cells[2,0]:='ActionType';
    Form9.HotKeysTable.Cells[3,0]:='Value';
    Form9.HotKeysTable.Cells[4,0]:='Value2';
    Form9.HotKeysTable.RowCount:=Hotkeys.Size+2;
    IF Hotkeys.Size>0 THEN BEGIN
      FOR i:=0 TO Hotkeys.Size-1 DO BEGIN
        WITH Hotkeys.Items[i] DO BEGIN
          modifiers:=0;
          IF MOD_Ctrl THEN modifiers:=modifiers+MOD_Ctrl_Key;
          IF MOD_Alt THEN modifiers:=modifiers+MOD_Alt_Key;

          RegisterHotkey(Form9.Handle,i,modifiers,VKKeys[key].Value);

          _temp:='';
          IF MOD_Ctrl THEN _temp:=_temp+'CTRL+';
          IF MOD_Alt THEN _temp:=_temp+'ALT+';
          Form9.HotKeysTable.Cells[0,i+1]:=_temp+VKKeys[Key].Name;
          IF Pos('Char',HK_Target_Types[Target_Type])>0 THEN BEGIN
            _temp:=HK_Target_Types[Target_Type];
            IF NOT (Target_Charname='') THEN BEGIN
              _temp:=_temp+' (Char "'+Target_Charname+'"): ';
            END ELSE BEGIN
              _temp:=_temp+' (Char'+IntToStr(Target_CharID)+'): ';
            END;
            _temp:=_temp+CharDataStuff[Target_Item].Name;
          END;
          IF Pos('Global',HK_Target_Types[Target_Type])>0 THEN BEGIN
            _temp:=HK_Target_Types[Target_Type]+': ';
            IF Settings[Target_Item].has_box THEN
              _temp:=_temp+Settings[Target_Item].Item_Checkbox.Caption
            ELSE _temp:=_temp+Settings[Target_Item].Item_Label.Caption;
          END;
          Form9.HotKeysTable.Cells[1,i+1]:=_temp;
          Form9.HotKeysTable.Cells[2,i+1]:=HK_Actions[Action];
          IF ('Toggle'=HK_Actions[Action]) OR ('Freeze'=HK_Actions[Action]) THEN BEGIN
            Form9.HotKeysTable.Cells[3,i+1]:='';
          END ELSE BEGIN
            Form9.HotKeysTable.Cells[3,i+1]:=FloatToStr(Value);
            IF 'Switch value'=HK_Actions[Action] THEN BEGIN
              Form9.HotKeysTable.Cells[4,i+1]:=FloatToStr(Value2);
            END ELSE BEGIN
              Form9.HotKeysTable.Cells[4,i+1]:='';
            END;
          END;
        END;
      END;
    END;
    FOR i:=0 TO 3 DO Form9.HotKeysTable.Cells[i,Form9.HotKeysTable.RowCount-1]:='';
  END;

PROCEDURE TForm9.FormCreate(Sender: TObject);
  BEGIN
    Sleep(50);
    AssignFile(HotKeysFile,_path+'\hotkeys.cfg');
    Reset(HotKeysFile);
    Read(HotKeysFile,HotKeys);
    CloseFile(HotKeysFile);
    _sel_row:=1;
    _sel_col:=0;
    Form9.DrawTable;
    Form9.UnregisterHotkeys;
  END;

PROCEDURE TForm9.WMHotkey(var Msg : TWMHotKey);
  VAR hk_id:Byte;
    i,chid:Byte;
  BEGIN
    IF _connected THEN BEGIN
      hk_id:=Msg.HotKey;
      WITH Hotkeys.Items[hk_id] DO BEGIN
        IF Pos('Global',HK_Target_Types[Target_Type])>0 THEN BEGIN
          IF 'Toggle'=HK_Actions[Action] THEN BEGIN
            Settings[Target_Item].Item_Checkbox.Checked:=NOT Settings[Target_Item].Item_Checkbox.Checked;
            Form1.Debug_Click(Settings[Target_Item].Item_Checkbox);
            IF Settings[Target_Item].Item_Checkbox.Checked THEN
              SendMessageToOni('[b. "'+Settings[Target_Item].Item_Checkbox.Caption+'" activated.]')
            ELSE
              SendMessageToOni('[b. "'+Settings[Target_Item].Item_Checkbox.Caption+'" deactivated.]');
          END;
          IF 'Set'=HK_Actions[Action] THEN BEGIN
            IF Settings[Target_Item].edit_type=5 THEN BEGIN
              SendMessageToOni('[b. Set "'+Settings[Target_Item].Item_Checkbox.Caption+'" to '+FloatToStr(Value)+'.]');
              Settings[Target_Item].Item_Edit.Text:=FloatToStr( Value );
            END ELSE BEGIN
              SendMessageToOni('[b. Set "'+Settings[Target_Item].Item_Checkbox.Caption+'" to '+IntToStr(Floor(Value))+'.]');
              Settings[Target_Item].Item_Edit.Text:=IntToStr( Floor(Value) );
            END;
          END;
          IF 'Add'=HK_Actions[Action] THEN BEGIN
            IF Settings[Target_Item].edit_type=5 THEN BEGIN
              SendMessageToOni('[b. Added '+FloatToStr(Value)+' to "'+Settings[Target_Item].Item_Checkbox.Caption+'" (now='+FloatToStr( StrToFloat(Settings[Target_Item].Item_Edit.Text) + Value )+').]');
              Settings[Target_Item].Item_Edit.Text:=FloatToStr( StrToFloat(Settings[Target_Item].Item_Edit.Text) + Value );
            END ELSE BEGIN
              SendMessageToOni('[b. Added '+IntToStr(Floor(Value))+' to "'+Settings[Target_Item].Item_Checkbox.Caption+'" (now='+IntToStr( StrToInt(Settings[Target_Item].Item_Edit.Text) + Floor(Value) )+').]');
              Settings[Target_Item].Item_Edit.Text:=IntToStr( StrToInt(Settings[Target_Item].Item_Edit.Text) + Floor(Value) );
            END;
          END;
          IF 'Multiply'=HK_Actions[Action] THEN BEGIN
            IF Settings[Target_Item].edit_type=5 THEN BEGIN
              SendMessageToOni('[b. Multiplied "'+Settings[Target_Item].Item_Checkbox.Caption+'" with '+FloatToStr(Value)+' (now='+FloatToStr( StrToFloat(Settings[Target_Item].Item_Edit.Text) * Value )+').]');
              Settings[Target_Item].Item_Edit.Text:=FloatToStr( StrToFloat(Settings[Target_Item].Item_Edit.Text) * Value );
            END ELSE BEGIN
              SendMessageToOni('[b. Multiplied "'+Settings[Target_Item].Item_Checkbox.Caption+'" with '+IntToStr(Floor(Value))+' (now='+IntToStr( StrToInt(Settings[Target_Item].Item_Edit.Text) * Floor(Value) )+').]');
              Settings[Target_Item].Item_Edit.Text:=IntToStr( StrToInt(Settings[Target_Item].Item_Edit.Text) * Floor(Value) );
            END;
          END;
          IF 'Switch value'=HK_Actions[Action] THEN BEGIN
            IF Settings[Target_Item].edit_type=5 THEN BEGIN
              IF StrToFloat(Settings[Target_Item].Item_Edit.Text)=Value THEN BEGIN
                SendMessageToOni('[b. Switched "'+Settings[Target_Item].Item_Checkbox.Caption+'" to '+FloatToStr(Value2)+'.]');
                Settings[Target_Item].Item_Edit.Text:=FloatToStr( Value2 );
              END ELSE BEGIN
                SendMessageToOni('[b. Switched "'+Settings[Target_Item].Item_Checkbox.Caption+'" to '+FloatToStr(Value)+'.]');
                Settings[Target_Item].Item_Edit.Text:=FloatToStr( Value );
              END;
            END ELSE BEGIN
              IF StrToInt(Settings[Target_Item].Item_Edit.Text)=Floor(Value) THEN BEGIN
                SendMessageToOni('[b. Switched "'+Settings[Target_Item].Item_Checkbox.Caption+'" to '+IntToStr(Floor(Value2))+'.]');
                Settings[Target_Item].Item_Edit.Text:=IntToStr( Floor(Value2) );
              END ELSE BEGIN
                SendMessageToOni('[b. Switched "'+Settings[Target_Item].Item_Checkbox.Caption+'" to '+IntToStr(Floor(Value))+'.]');
                Settings[Target_Item].Item_Edit.Text:=IntToStr( Floor(Value) );
              END;
            END;
          END;
        END;
        IF Pos('Char',HK_Target_Types[Target_Type])>0 THEN BEGIN
          IF NOT (Target_Charname='') THEN BEGIN
            chid:=255;
            FOR i:=0 TO ais_controlled DO BEGIN
              IF CharData[i].Items[1].Item_Edit.Text=Target_Charname THEN BEGIN
                chid:=i;
                break;
              END;
            END;
            IF chid=255 THEN exit;
          END ELSE BEGIN
            chid:=Target_CharID;
          END;
{          IF Pos('Toggle',HK_Actions[Action])>0 THEN BEGIN
            Settings[Target_Item].Item_Checkbox.Checked:=NOT Settings[Target_Item].Item_Checkbox.Checked;
            Form1.Debug_Click(Settings[Target_Item].Item_Checkbox);
          END;}
          IF 'Set'=HK_Actions[Action] THEN BEGIN
            IF CharData[chid].Items[Target_Item].data_type=5 THEN BEGIN
              SendMessageToOni('[b. Set "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' to '+FloatToStr(Value)+'.]');
              CharData[chid].Items[Target_Item].Item_Edit.Text:=FloatToStr( Value );
            END ELSE BEGIN
              SendMessageToOni('[b. Set "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' to '+IntToStr(Floor(Value))+'.]');
              CharData[chid].Items[Target_Item].Item_Edit.Text:=IntToStr( Floor(Value) );
            END;
          END;
          IF 'Add'=HK_Actions[Action] THEN BEGIN
            IF CharData[chid].Items[Target_Item].data_type=5 THEN BEGIN
              SendMessageToOni('[b. Added '+FloatToStr(Value)+' to "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' (now='+FloatToStr( StrToFloat(CharData[chid].Items[Target_Item].Item_Edit.Text) + Value )+').]');
              CharData[chid].Items[Target_Item].Item_Edit.Text:=FloatToStr( StrToFloat(CharData[chid].Items[Target_Item].Item_Edit.Text) + Value )
            END ELSE BEGIN
              SendMessageToOni('[b. Added '+IntToStr(Floor(Value))+' to "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' (now='+FloatToStr( StrToFloat(CharData[chid].Items[Target_Item].Item_Edit.Text) + Value )+').]');
              CharData[chid].Items[Target_Item].Item_Edit.Text:=IntToStr( StrToInt(CharData[chid].Items[Target_Item].Item_Edit.Text) + Floor(Value) );
            END;
          END;
          IF 'Multiply'=HK_Actions[Action] THEN BEGIN
            IF CharData[chid].Items[Target_Item].data_type=5 THEN BEGIN
              SendMessageToOni('[b. Multiplied "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' with '+FloatToStr(Value)+' (now='+FloatToStr( StrToFloat(CharData[chid].Items[Target_Item].Item_Edit.Text) * Value )+').]');
              CharData[chid].Items[Target_Item].Item_Edit.Text:=FloatToStr( StrToFloat(CharData[chid].Items[Target_Item].Item_Edit.Text) * Value )
            END ELSE BEGIN
              SendMessageToOni('[b. Multiplied "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' with '+IntToStr(Floor(Value))+' (now='+FloatToStr( StrToFloat(CharData[chid].Items[Target_Item].Item_Edit.Text) * Value )+').]');
              CharData[chid].Items[Target_Item].Item_Edit.Text:=IntToStr( StrToInt(CharData[chid].Items[Target_Item].Item_Edit.Text) * Floor(Value) );
            END;
          END;
          IF 'Freeze'=HK_Actions[Action] THEN BEGIN
            CharData[chid].Items[Target_Item].Item_Freeze.Checked:=NOT CharData[chid].Items[Target_Item].Item_Freeze.Checked;
            IF CharData[chid].Items[Target_Item].Item_Freeze.Checked THEN
              SendMessageToOni('[b. Freeze "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' activated.]')
            ELSE
              SendMessageToOni('[b. Freeze "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' deactivated.]');
          END;
          IF 'Set & Freeze'=HK_Actions[Action] THEN BEGIN
            IF CharData[chid].Items[Target_Item].Item_Freeze.Checked=False THEN BEGIN
              IF CharData[chid].Items[Target_Item].data_type=5 THEN BEGIN
                SendMessageToOni('[b. Set "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' to '+FloatToStr(Value)+' and activated freeze.]');
                CharData[chid].Items[Target_Item].Item_Edit.Text:=FloatToStr( Value )
              END ELSE BEGIN
                SendMessageToOni('[b. Set "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' to '+IntToStr(Floor(Value))+' and activated freeze.]');
                CharData[chid].Items[Target_Item].Item_Edit.Text:=IntToStr( Floor(Value) );
              END;
              CharData[chid].Items[Target_Item].Item_Freeze.Checked:=True;
            END ELSE BEGIN
              SendMessageToOni('[b. Freeze "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' deactivated.]');
              CharData[chid].Items[Target_Item].Item_Freeze.Checked:=False;
            END;
          END;
          IF 'Switch value'=HK_Actions[Action] THEN BEGIN
            IF CharData[chid].Items[Target_Item].data_type=5 THEN BEGIN
              IF StrToFloat(CharData[chid].Items[Target_Item].Item_Edit.Text)=Value THEN BEGIN
                SendMessageToOni('[b. Switched "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' to '+FloatToStr(Value2)+'.]');
                CharData[chid].Items[Target_Item].Item_Edit.Text:=FloatToStr( Value2 )
              END ELSE BEGIN
                SendMessageToOni('[b. Switched "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' to '+FloatToStr(Value)+'.]');
                CharData[chid].Items[Target_Item].Item_Edit.Text:=FloatToStr( Value );
              END;
            END ELSE BEGIN
              IF StrToInt(CharData[chid].Items[Target_Item].Item_Edit.Text)=Floor(Value) THEN BEGIN
                SendMessageToOni('[b. Switched "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' to '+IntToStr(Floor(Value2))+'.]');
                CharData[chid].Items[Target_Item].Item_Edit.Text:=IntToStr( Floor(Value2) )
              END ELSE BEGIN
                SendMessageToOni('[b. Switched "'+CharData[chid].Items[Target_Item].Item_Freeze.Caption+'" for char'+IntToStr(chid)+' to '+IntToStr(Floor(Value))+'.]');
                CharData[chid].Items[Target_Item].Item_Edit.Text:=IntToStr( Floor(Value) );
              END;
            END;
          END;
        END;
      END;
    END;
  END;

PROCEDURE TForm9.UnregisterHotkeys;
  VAR i:Byte;
  BEGIN
    FOR i:=0 TO Hotkeys.Size-1 DO BEGIN
      UnregisterHotkey(Form9.Handle,i);
    END;
  END;

END.
