UNIT Unit12;

INTERFACE

USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, StrUtils;

TYPE
  TForm12 = Class(TForm)
    label_colors: TLabel;
    Message_Edit: TEdit;
    send_message: TButton;
    timer_check: TTimer;
    Label1: TLabel;
    Label2: TLabel;
    PROCEDURE FormShow(Sender: TObject);
    PROCEDURE timer_checkTimer(Sender: TObject);
    PROCEDURE send_messageClick(Sender: TObject);
    PROCEDURE FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  PRIVATE
  PUBLIC
  END;

VAR
  Form12: TForm12;

IMPLEMENTATION

USES Unit1,Unit2,Unit3,Unit5,Unit6,Unit7,Unit8,Unit9,Unit10,Unit11;

{$R *.dfm}

PROCEDURE TForm12.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    Self.Visible:=False;
    CanClose:=False;
    Form1.Menu_Patch_Messages.Checked:=False;
  END;

PROCEDURE TForm12.send_messageClick(Sender: TObject);
  VAR adr_message:LongWord;
  BEGIN
    IF _connected AND patch_messages_loaded THEN BEGIN
      adr_message:=Decode_Int(ReadMem(address_message_pointer,4));

      IF adr_message=0 THEN BEGIN
        MessageBox(Form12.Handle,PChar('You have to load a level to which you added the script'+Chr(13)+Chr(10)+'before using this stuff.'),PChar('Error'),MB_OK);
      END ELSE BEGIN
        SendMessageToOni(Form12.Message_Edit.Text);
      END;
    END ELSE BEGIN
      IF _connected THEN BEGIN
        MessageBox(Form12.Handle,PChar('You have to apply the patch before using this stuff.'),PChar('Error'),MB_OK);
      END;
    END;
  END;

PROCEDURE TForm12.timer_checkTimer(Sender: TObject);
  VAR buffer:byte_array;
    adr_message:LongWord;
  BEGIN
    IF _connected AND patch_messages_loaded THEN BEGIN
      adr_message:=Decode_Int(ReadMem(address_message_pointer,4));

      buffer:=ReadMem(adr_message,200);
      IF NOT Message_Edit.Focused THEN BEGIN
        Message_Edit.Text:=Decode_Str(buffer);
      END;
    END;
  END;

PROCEDURE TForm12.FormShow(Sender: TObject);
  BEGIN
    Send_Message.SetFocus;
    Form12.timer_checkTimer(Self);
    label_colors.Caption:='Color-Codes:'+Chr(13)+Chr(10)+
                          'b. = blue'+Chr(13)+Chr(10)+
                          'c. = cyan (lighter blue)'+Chr(13)+Chr(10)+
                          'g. = green'+Chr(13)+Chr(10)+
                          'l. = purple'+Chr(13)+Chr(10)+
                          'o. = orange'+Chr(13)+Chr(10)+
                          'r. = red'+Chr(13)+Chr(10)+
                          'u. = umber (some brown :D )'+Chr(13)+Chr(10)+
                          'y. = yellow';
  END;

END.
