UNIT Unit15;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, StrUtils;
TYPE
  TForm15 = Class(TForm)
    Label2: TLabel;
    list: TListBox;
    check_ai: TCheckBox;
    GroupBox1: TGroupBox;
    check_atPlayer: TRadioButton;
    check_atCoords: TRadioButton;
    edit_player_x: TEdit;
    lbl_player_x: TLabel;
    edit_player_y: TEdit;
    lbl_player_y: TLabel;
    edit_player_z: TEdit;
    lbl_player_z: TLabel;
    edit_coords_x: TEdit;
    lbl_coords_x: TLabel;
    lbl_coords_y: TLabel;
    edit_coords_y: TEdit;
    lbl_coords_z: TLabel;
    edit_coords_z: TEdit;
    btn_create: TButton;
    tim_check: TTimer;
    check_multiple: TCheckBox;
    edit_multiple: TEdit;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label3: TLabel;
    procedure check_multipleClick(Sender: TObject);
    procedure check_atCoordsClick(Sender: TObject);
    PROCEDURE check_atPlayerClick(Sender: TObject);
    PROCEDURE btn_createClick(Sender: TObject);
    PROCEDURE tim_checkTimer(Sender: TObject);
    PROCEDURE FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  PRIVATE
  PUBLIC
  END;

VAR
  Form15: TForm15;

IMPLEMENTATION
USES Unit1, Unit2, Unit8,Unit11;
{$R *.dfm}
VAR
  lvl_shown:Byte;

FUNCTION patch_loader_loaded:Boolean;
  CONST check_for:LongWord=$0010656EE9;
    address_at:LongWord=$4228ED;
  BEGIN
    IF Decode_Int(ReadMem(address_at,4))=check_for THEN result:=True
    ELSE result:=False;
  END;

PROCEDURE TForm15.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    Self.Visible:=False;
    CanClose:=False;
    Form1.menu_Spawn.Checked:=False;
  END;

PROCEDURE TForm15.tim_checkTimer(Sender: TObject);
  VAR i,modelcount:Byte;
  BEGIN
    IF _connected AND (lvlnumber>0) AND patch_loader_loaded THEN BEGIN
      IF lvl_shown<>lvlnumber THEN BEGIN
        list.Items.Clear;
        modelcount:=Decode_Int(ReadMem($10F05,1));
        FOR i:=0 TO modelcount-1 DO BEGIN
          list.Items.Add('Model'+IntToStr(i+1)+' ('+IntToStr(Decode_Int(ReadMem($10F20+i*4,4)))+')');
        END;
        lvl_shown:=lvlnumber;
      END;
    END ELSE BEGIN
      list.Items.Clear;
      lvl_shown:=0;
    END;
  END;

PROCEDURE TForm15.btn_createClick(Sender: TObject);
  VAR x,y,z:Single;
    address_trigger:LongWord;
    address_counter:LongWord;
    start_count:Byte;
    base_name:String;
    ai:Byte;
  BEGIN
    IF _connected AND (lvlnumber>0) AND patch_loader_loaded THEN BEGIN
      //VALIDATIONS!
      IF Form15.check_atPlayer.Checked THEN BEGIN
      END;
      IF Form15.check_atCoords.Checked THEN BEGIN
      END;
      IF Form15.check_ai.Checked THEN ai:=2
      ELSE ai:=1;
      address_trigger:=Decode_Int(ReadMem(address_script_var_pointer,4))+3*$10E0;
      address_counter:=Decode_Int(ReadMem(address_script_var_pointer,4))+4*$10E0;
      start_count:=Decode_Int(ReadMem(address_counter,1));
      base_name:='spawned';
      IF Form15.check_multiple.Checked THEN BEGIN
        REPEAT
          WriteMem(address_trigger,1,Encode_Int(ai));
          Sleep(100);
        UNTIL Decode_Int(ReadMem(address_counter,1))=(start_count+StrToInt(Form15.edit_multiple.Text));
      END ELSE WriteMem(address_trigger,1,Encode_Int(ai));
    END ELSE BEGIN
      IF _connected AND (lvlnumber>0) THEN BEGIN
        MessageBox(Form15.Handle,PChar('Oni.exe is not patched.'),PChar('Error'),MB_OK);
      END;
    END;
  END;

PROCEDURE TForm15.check_atPlayerClick(Sender: TObject);
  BEGIN
      Form15.lbl_player_x.Enabled:=Form15.check_atPlayer.Checked;
      Form15.lbl_player_y.Enabled:=Form15.check_atPlayer.Checked;
      Form15.lbl_player_z.Enabled:=Form15.check_atPlayer.Checked;
      Form15.edit_player_x.Enabled:=Form15.check_atPlayer.Checked;
      Form15.edit_player_y.Enabled:=Form15.check_atPlayer.Checked;
      Form15.edit_player_z.Enabled:=Form15.check_atPlayer.Checked;
      Form15.lbl_coords_x.Enabled:=Form15.check_atCoords.Checked;
      Form15.lbl_coords_y.Enabled:=Form15.check_atCoords.Checked;
      Form15.lbl_coords_z.Enabled:=Form15.check_atCoords.Checked;
      Form15.edit_coords_x.Enabled:=Form15.check_atCoords.Checked;
      Form15.edit_coords_y.Enabled:=Form15.check_atCoords.Checked;
      Form15.edit_coords_z.Enabled:=Form15.check_atCoords.Checked;
  END;

PROCEDURE TForm15.check_atCoordsClick(Sender: TObject);
  BEGIN
      Form15.lbl_player_x.Enabled:=Form15.check_atPlayer.Checked;
      Form15.lbl_player_y.Enabled:=Form15.check_atPlayer.Checked;
      Form15.lbl_player_z.Enabled:=Form15.check_atPlayer.Checked;
      Form15.edit_player_x.Enabled:=Form15.check_atPlayer.Checked;
      Form15.edit_player_y.Enabled:=Form15.check_atPlayer.Checked;
      Form15.edit_player_z.Enabled:=Form15.check_atPlayer.Checked;
      Form15.lbl_coords_x.Enabled:=Form15.check_atCoords.Checked;
      Form15.lbl_coords_y.Enabled:=Form15.check_atCoords.Checked;
      Form15.lbl_coords_z.Enabled:=Form15.check_atCoords.Checked;
      Form15.edit_coords_x.Enabled:=Form15.check_atCoords.Checked;
      Form15.edit_coords_y.Enabled:=Form15.check_atCoords.Checked;
      Form15.edit_coords_z.Enabled:=Form15.check_atCoords.Checked;
  END;

PROCEDURE TForm15.check_multipleClick(Sender: TObject);
  BEGIN
    Form15.edit_multiple.Enabled:=Form15.check_multiple.Checked;
  END;

END.
