UNIT Unit5;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Unit8;
TYPE
  TForm5 = Class(TForm)
    timer_edit: TEdit;
    timer_label: TLabel;
    timer_ok: TButton;
    timer_cancel: TButton;
    PROCEDURE OnShow(Sender: TObject);
    PROCEDURE timer_okClick(Sender: TObject);
    PROCEDURE timer_cancelClick(Sender: TObject);
    PROCEDURE CloseQuery(Sender: TObject; var CanClose: Boolean);
  PRIVATE
  PUBLIC
  END;
VAR
  Form5: TForm5;

IMPLEMENTATION
USES unit1, unit2, unit3;
{$R *.dfm}

PROCEDURE TForm5.CloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    Self.Visible:=False;
    Form1.Menu_FreezeTime.Enabled:=True;
    Form1.Menu_RefreshTime.Enabled:=True;
    CanClose:=False;
  END;

PROCEDURE TForm5.timer_cancelClick(Sender: TObject);
  BEGIN
    Form5.Close;
  END;

PROCEDURE TForm5.timer_okClick(Sender: TObject);
  VAR time:Integer;
    i:Byte;
  BEGIN
    IF TryStrToInt(Form5.timer_edit.Text,time) THEN BEGIN
      IF (time>=50) AND (time<=10000) THEN BEGIN
        IF Pos('FreezeTimer',Form5.Caption)>0 THEN BEGIN
          FOR i:=0 TO ais_controlled DO BEGIN
            CharForms[i].timer_freeze.Interval:=time;
          END;
          Form5.Close;
        END ELSE BEGIN
          Form1.get_values.Interval:=time;
          FOR i:=0 TO ais_controlled DO BEGIN
            CharForms[i].timer_actualize.Interval:=time;
          END;
          Form5.Close;
        END;
      END ELSE BEGIN
        MessageBox(Form5.Handle,PChar('The value should be between 1 and 10000.'),PChar('Error'),MB_OK);
      END;
    END ELSE BEGIN
      MessageBox(Form5.Handle,PChar('The value isn''t an integer.'),PChar('Error'),MB_OK);
    END;
  END;

PROCEDURE TForm5.OnShow(Sender: TObject);
  BEGIN
    timer_edit.SelectAll;
    timer_edit.SetFocus;
  END;

END.