unit Unit7;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StrUtils,Unit8;

type
  TForm7 = class(TForm)
    grid: TStringGrid;
    procedure FormResize(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form7: TForm7;

PROCEDURE Check_CharInOverview(charnumber:Byte);
FUNCTION GetCharOverviewCol(charnumber:Byte):Byte;

implementation

uses unit1, unit2, unit3;
{$R *.dfm}

PROCEDURE Check_CharInOverview(charnumber:Byte);
  VAR i,colchar:Byte;
    found:Boolean;
  BEGIN
    found:=False;
    FOR i:=2 TO Form7.grid.ColCount-1 DO BEGIN
      IF NOT found=True THEN BEGIN
        IF StrLen(PChar(Form7.grid.Cells[i,0]))>0 THEN BEGIN
          colchar:=StrToInt(MidStr(Form7.grid.Cells[i,0], 3, 10));
          IF colchar=charnumber THEN BEGIN
            found:=True;
            IF NOT _ais_active[charnumber]=TRUE THEN BEGIN
              Form7.grid.Cells[i,0]:=Form7.grid.Cells[i+1,0];
              Form7.grid.Cells[i+1,0]:='';
            END ELSE exit;
          END;
        END;
      END ELSE BEGIN
        IF i<Form7.grid.ColCount-1 THEN BEGIN
          Form7.grid.Cells[i,0]:=Form7.grid.Cells[i+1,0];
          Form7.grid.Cells[i+1,0]:='';
        END;
      END;
    END;
    IF (found=True) AND (_ais_active[charnumber]=FALSE) THEN Form7.grid.ColCount:=Form7.grid.ColCount-1;
    IF (found=False) AND (_ais_active[charnumber]=TRUE) THEN BEGIN
      Form7.grid.ColCount:=Form7.grid.ColCount+1;
      FOR i:=Form7.grid.ColCount-1 DOWNTO 2 DO BEGIN
        IF StrLen(PChar(Form7.grid.Cells[i,0]))>0 THEN BEGIN
          colchar:=StrToInt(MidStr(Form7.grid.Cells[i,0], 3, 10));
          IF colchar>charnumber THEN BEGIN
            Form7.grid.Cells[i+1,0]:=Form7.grid.Cells[i,0];
          END ELSE BEGIN
            Form7.grid.Cells[i+1,0]:='AI'+IntToStr(charnumber);
            exit;
          END;
        END;
        IF i=2 THEN Form7.grid.Cells[i,0]:='AI'+IntToStr(charnumber);
      END;
    END;
  END;

FUNCTION GetCharOverviewCol(charnumber:Byte):Byte;
  VAR i,colchar:Byte;
  BEGIN
    FOR i:=2 TO Form7.grid.ColCount-1 DO BEGIN
      IF StrLen(PChar(Form7.grid.Cells[i,0]))>0 THEN BEGIN
        colchar:=StrToInt(MidStr(Form7.grid.Cells[i,0], 3, 10));
        IF colchar=charnumber THEN BEGIN result:=i; exit; END;
      END;
    END;
    result:=0;
  END;

PROCEDURE TForm7.FormCreate(Sender: TObject);
  VAR i:Byte;
  BEGIN
    grid.RowCount:=number_items+1;
    grid.Height:=(number_items+1)*17+4;
    Form7.Height:=grid.Height+22;
    grid.ColCount:=2;
    grid.FixedCols:=1;
    grid.FixedRows:=1;
    grid.ColWidths[0]:=120;
    grid.Cells[0,0]:=' ';
    FOR i:=1 TO number_items DO BEGIN
      grid.Cols[0].Add(CharDataStuff[i].overview_name);
    END;
    grid.Rows[0].Add('Player')
  END;

PROCEDURE TForm7.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    Self.Visible:=False;
    CanClose:=False;
    CharOverviewMenu.Checked:=False;
  END;

PROCEDURE TForm7.FormResize(Sender: TObject);
  BEGIN
    Form7.Height:=grid.Height+24;
    grid.Width:=Form7.Width-8;
    IF Form7.Width<300 THEN Form7.Width:=300;
  END;

END.
