UNIT Unit1;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CrossEdit, Math, ExtCtrls;

TYPE
  TForm1 = Class(TForm)
    grp_center: TGroupBox;
    group_setxy: TGroupBox;
    btn_center: TButton;
    edit_x: TCrossEdit;
    edit_y: TCrossEdit;
    btn_setxy: TButton;
    group_black: TGroupBox;
    btn_black: TButton;
    timer_check: TTimer;
    PROCEDURE timer_checkTimer(Sender: TObject);
    PROCEDURE btn_blackClick(Sender: TObject);
    PROCEDURE btn_setxyClick(Sender: TObject);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE btn_centerClick(Sender: TObject);
    PROCEDURE Button1Click(Sender: TObject);
  PRIVATE
  PUBLIC
  END;

VAR
  Form1: TForm1;

IMPLEMENTATION
USES Unit2;
{$R *.dfm}
VAR
  ONIHandle:LongWord;

PROCEDURE TForm1.Button1Click(Sender: TObject);
  BEGIN
    ONIHandle:=FindWindow(PChar('ONI '),PChar('ONI '));
    Form1.Caption:=IntToStr(ONIHandle);
  END;

PROCEDURE TForm1.btn_centerClick(Sender: TObject);
  VAR
    Handle,NewX,NewY:LongWord;
    Screen,Cur:TRect;
    ScreenWidth,ScreenHeight,Width,Height:LongWord;
  BEGIN
    Handle:=FindWindow(PChar('ONI '),PChar('ONI '));
    IF Handle>0 THEN BEGIN
      GetWindowRect(Handle,Cur);
      GetWindowRect(GetDesktopWindow,Screen);
      ScreenWidth:=Screen.Right-Screen.Left;
      ScreenHeight:=Screen.Bottom-Screen.Top;
      Width:=Cur.Right-Cur.Left;
      Height:=Cur.Bottom-Cur.Top;
      IF (Width<ScreenWidth) AND (Height<ScreenHeight) THEN BEGIN
        NewX:=(ScreenWidth DIV 2)-(Width DIV 2);
        NewY:=(ScreenHeight DIV 2)-(Height DIV 2);
        IF NOT SetWindowPos(Handle,0,NewX,NewY,0,0,SWP_NOSIZE OR SWP_NOACTIVATE OR SWP_NOZORDER) THEN
          ShowMessage('Couldn''t set the position of ONIs window!');
      END ELSE ShowMessage('ONIs window is at fullscreen!');
    END ELSE ShowMessage('Couldn''t find ONIs window!');
  END;

PROCEDURE TForm1.FormCreate(Sender: TObject);
  VAR
    Screen:TRect;
  BEGIN
    GetWindowRect(GetDesktopWindow,Screen);
    edit_x.Max:=Screen.Right;
    edit_y.Max:=Screen.Bottom;
    edit_x.BorderStyle:=bsSingle;
    edit_y.BorderStyle:=bsSingle;
  END;

PROCEDURE TForm1.btn_setxyClick(Sender: TObject);
  VAR
    Handle:LongWord;
  BEGIN
    IF edit_x.CheckError THEN BEGIN
      ShowMessage('x-value has to be between 0 and '+IntToStr(Floor(edit_x.Max))+'!');
      Exit;
    END;
    IF edit_y.CheckError THEN BEGIN
      ShowMessage('y-value has to be between 0 and '+IntToStr(Floor(edit_y.Max))+'!');
      Exit;
    END;
    Handle:=FindWindow(PChar('ONI '),PChar('ONI '));
    IF Handle>0 THEN BEGIN
      IF NOT SetWindowPos(Handle,0,edit_x.GetInteger,edit_y.GetInteger,0,0,SWP_NOSIZE OR SWP_NOACTIVATE OR SWP_NOZORDER) THEN
        ShowMessage('Couldn''t set the position of ONIs window!');
    END ELSE ShowMessage('Couldn''t find ONIs window!');
  END;

PROCEDURE TForm1.btn_blackClick(Sender: TObject);
  BEGIN
    IF FindWindow(PChar('ONI '),PChar('ONI '))>0 THEN BEGIN
      Form2.Visible:=NOT Form2.Visible;
      SetForeGroundWindow(FindWindow(PChar('ONI '),PChar('ONI ')));
    END;
  END;

PROCEDURE TForm1.timer_checkTimer(Sender: TObject);
  BEGIN
    IF Form2.Visible THEN BEGIN
      IF FindWindow(PChar('ONI '),PChar('ONI '))=0 THEN Form2.Visible:=False;
    END;
  END;

END.
