UNIT Unit3_data;
INTERFACE
USES Classes;

CONST
  version:String='v0.25a';
  dbversion:String='0.2';
  CrLf:String[2]=#13+#10;

TYPE
  Tdata=Array OF Byte;
  Theader=PACKED RECORD
    Ident:Array[0..$13] OF Byte;
    Files:LongWord;
    NamedFiles:LongWord;
    Extensions:LongWord;
    DataAddr:LongWord;
    DataSize:LongWord;
    NamesAddr:LongWord;
    NamesSize:LongWord;
    Ident2:Array[0..$F] OF Byte;
  END;
  Tfilesmap=Array OF PACKED RECORD
    Extension:Array[0..$3] OF Char;
    DataAddr:LongWord;
    NameAddr:LongWord;
    FileSize:LongWord;
    FileType:LongWord;
  END;
  TFileInfo=PACKED RECORD
    ID:LongWord;
    FileName:String;
    Extension:String[4];
    Name:String;
    Size:LongWord;
    FileType:LongWord;
    DatAddr:LongWord;
    opened:Boolean;
  END;
  Tfiles=Array OF TFileInfo;

  Tnamedfilesmap=Array OF PACKED RECORD
  	FileNumber:LongWord;
	  blubb:LongWord;
  END;
  Textensionsmap=Array OF PACKED RECORD
  	Ident:Array[0..$7] OF Byte;
	  Extension:Array[0..$3] OF Char;
  	ExtCount:LongWord;
  END;

  TAppSettings=RECORD
    DatPath:String[250];
    ExtractPath:String[250];
  END;

  TExportHandlers=RECORD
    Ext:String[4];
    needed:Boolean;
    Handler:Function(fileid:LongWord; filename:String; convert:Boolean):Integer;
  END;

  TStringList=Array OF String;
  TExtList=Array OF RECORD
    Ext:String;
    count:LongWord;
  END;

  TRawInfo=RECORD
    src_id:LongWord;
    src_offset:LongWord;
    raw_addr:LongWord;
    raw_size:LongWord;
  END;
  TRawList=Array OF TRawInfo;

VAR
  opened_state:Byte=0;
  dat_filename:String='';
  raw_filename:String='';
  dat_header:Theader;
  dat_filesmap:Tfilesmap;
  dat_files:Tfiles;
  dat_namedfilesmap:Tnamedfilesmap;
  dat_extensionsmap:Textensionsmap;
  AppSettings:TAppSettings;
  AppSettingsFile:File OF TAppSettings;

  database_level:LongWord;
  database_ident:Array[0..$13] OF Byte;

CONST
  header_ident1:Array[0..$13] OF Byte=
      ($1F,$27,$DC,$33,$DF,$BC,$03,$00,$31,$33,$52,$56,$40,$00,$14,$00,$10,$00,$08,$00);
  header_ident2:Array[0..$F] OF Byte=
      ($99,$CF,$40,$00,$90,$4F,$63,$00,$F4,$55,$5F,$00,$90,$4F,$63,$00);

  export_noerror:Integer=0;
  export_nohandler:Integer=1;
  export_handlererror:Integer=2;
  export_error:Integer=3;

  opened_nothing:Byte=0;
  opened_dat:Byte=1;
  opened_db:Byte=2;

IMPLEMENTATION

END.

