UNIT Unit12_ValueEdit;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CrossEdit, Math;
TYPE
  TForm12 = Class(TForm)
    group: TGroupBox;
    btn_ok: TButton;
    btn_cancel: TButton;
    lbl_current: TLabel;
    edit_current: TEdit;
    lbl_new: TLabel;
    lbl_offset: TLabel;
    lbl_datatype: TLabel;
    edit_offset: TEdit;
    edit_datatype: TEdit;
    edit_new: TCrossEdit;
    PROCEDURE btn_cancelClick(Sender: TObject);
    PROCEDURE btn_okClick(Sender: TObject);
    PROCEDURE MakeVarInput(objectname:String; offset:LongWord; datatype:Word; current:String; caller:TObject);
  PRIVATE
  PUBLIC
  END;

VAR
  Form12: TForm12;


IMPLEMENTATION
USES Unit8_binedit, Unit13_rawedit,Unit9_data_structures, Unit1_main;
{$R *.dfm}
VAR
  caller_win_dat:TForm8;
  caller_win_raw:TForm13;
  _datatype:Word;
  _offset:LongWord;


PROCEDURE TForm12.MakeVarInput(objectname:String; offset:LongWord; datatype:Word; current:String; caller:TObject);
  BEGIN
    caller_win_dat:=NIL;
    caller_win_raw:=NIL;
    IF Pos('rawedit',TComponent(caller).Name)>0 THEN
      caller_win_raw:=TForm13(caller)
    ELSE
      caller_win_dat:=TForm8(caller);
    Form1.Enabled:=False;
    Self.Visible:=True;
    group.Caption:='Edit value';
    _datatype:=datatype;
    _offset:=offset;
    IF Length(objectname)>0 THEN group.Caption:=group.Caption+' for '+objectname;
    edit_offset.Text:='0x'+IntToHex(offset,8);
    edit_datatype.Text:=GetDataType(datatype);
    edit_current.Text:=current;
    edit_new.EditType:=etString;
    edit_new.Text:='';
    edit_new.LimitCheck:=False;
    edit_new.MaxLength:=0;
    edit_new.Max:=0;
    edit_new.BorderStyle:=bsSingle;
    Form12.Width:=300;
    CASE datatype OF
      1..4: BEGIN
              edit_new.EditType:=etUnsignedInt;
              edit_new.LimitCheck:=True;
              edit_new.Max:=Int(Power(256,datatype))-1;
            END;
      5..8: BEGIN
              edit_new.MaxLength:=2*(datatype-4);
              edit_new.EditType:=etHex;
            END;
      9:    BEGIN
              edit_new.EditType:=etFloat;
              edit_new.LimitCheck:=False;
            END;
      10:   BEGIN
              edit_new.EditType:=etBinary;
              edit_new.LimitCheck:=False;
              edit_new.MaxLength:=8;
            END;
      10000..65535: BEGIN
              edit_new.EditType:=etString;
              edit_new.LimitCheck:=False;
              edit_new.MaxLength:=datatype-10000;
              Form12.Width:=700;
            END;
    END;
    edit_new.SetFocus;
    edit_new.SelectAll;
  END;

PROCEDURE TForm12.btn_okClick(Sender: TObject);
  BEGIN
    IF NOT edit_new.NoValidValue THEN BEGIN
      Form1.Enabled:=True;
      Self.Visible:=False;
      IF caller_win_dat=NIL THEN
        caller_win_raw.SetNewValue(_datatype,_offset,edit_new.Text)
      ELSE
        caller_win_dat.SetNewValue(_datatype,_offset,edit_new.Text);
    END;
  END;

PROCEDURE TForm12.btn_cancelClick(Sender: TObject);
  BEGIN
    Form1.Enabled:=True;
    Self.Visible:=False;
  END;

END.
