#include <windows.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdint.h>
#include "oni_stdio.h"

#include "Daodan_Utility.h"
#include "BFW_Utility.h"

void __cdecl DDrStartupMessage(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	char* buffer = malloc(vsnprintf(NULL, 0, fmt, ap) + 1);
	
	vsprintf(buffer, fmt, ap);
	va_end(ap);

	if (!ONgFileStartup)
		if (!(ONgFileStartup = oni_fopen("startup.txt", "w")))
			return;

	oni_fprintf(ONgFileStartup, "%s\n", buffer);
	free(buffer);
	
	oni_fflush(ONgFileStartup);
	return;
}

int64_t DDrMachineTime_Sixtieths()
{
	static int64_t LastTime, Time;
	int64_t Current;

	Current = LastTime + GetTickCount();

	if (Current > Time)
	{
		LastTime += 1;
		Current += 1;
	}

	Time = Current;

	return (Time * 3) / 50;
}

int64_t DDrMachineTime_High()
{
//	LARGE_INTEGER PerfCount;
//	
//	if (!QueryPerformanceCounter(&PerfCount))
//		PerfCount.QuadPart = GetTickCount();
//	
//	return PerfCount.QuadPart;
	return GetTickCount();
}

double DDrMachineTime_High_Frequency()
{
//	LARGE_INTEGER Frequency;
//
//	if (!QueryPerformanceFrequency(&Frequency))
		return 1000.0;

//	return Frequency.QuadPart;
}
