UNIT Unit5_preview;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Math, ExtCtrls, Unit2_functions, Unit3_data, Unit4_exporters, Unit6_imgfuncs,
  StdCtrls, StrUtils, Menus;

TYPE
  TForm5 = Class(TForm)
    timer: TTimer;
    panel_preview: TPanel;
    img: TImage;
    panel_buttons: TPanel;
    btn_dec: TButton;
    btn_startstop: TButton;
    btn_inc: TButton;
    Splitter1: TSplitter;
    lbl_notpossible: TLabel;
    panel_files: TPanel;
    list: TListBox;
    panel_extension: TPanel;
    lbl_filter: TLabel;
    combo_extension: TComboBox;
    check_zerobyte: TCheckBox;
    edit_filtername: TEdit;
    check_filtername: TCheckBox;
    PROCEDURE LoadFileNames;
    PROCEDURE check_filternameClick(Sender: TObject);
    PROCEDURE check_zerobyteClick(Sender: TObject);
    PROCEDURE combo_extensionClick(Sender: TObject);
    PROCEDURE panel_extensionResize(Sender: TObject);
    PROCEDURE listClick(Sender: TObject);
    PROCEDURE Recreatelist;

    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE PreviewTXAN;
    PROCEDURE PreviewTXMB;
    PROCEDURE PreviewTXMP;
    PROCEDURE btn_incClick(Sender: TObject);
    PROCEDURE btn_decClick(Sender: TObject);
    PROCEDURE FormResize(Sender: TObject);
    PROCEDURE btn_startstopClick(Sender: TObject);
    PROCEDURE panel_buttonsResize(Sender: TObject);
    PROCEDURE timerTimer(Sender: TObject);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
  PRIVATE
  PUBLIC
  END;

VAR
  Form5: TForm5;

IMPLEMENTATION
{$R *.dfm}
USES Unit1_main;
VAR
  memstreams:Array OF TMemoryStream;
  actualimg:Byte;
  _fileid:LongWord;



PROCEDURE TForm5.Recreatelist;
  VAR
    i:LongWord;
    exts:TStringList;
  BEGIN
    combo_extension.Items.Clear;
    combo_extension.Items.Add('_All files_ ('+IntToStr(GetFilesCount)+')');
    exts:=GetExtensionsList;
    FOR i:=0 TO High(exts) DO
      combo_extension.Items.Add(exts[i]);
    combo_extension.ItemIndex:=0;
    combo_extensionClick(Self);
  END;

PROCEDURE TForm5.LoadFileNames;
  VAR
    Extension:String[4];
    no_zero_bytes:Boolean;
    pattern:String;
    files:TStringList;
    i:LongWord;
  BEGIN
    Extension:=MidStr(combo_extension.Items.Strings[combo_extension.ItemIndex],1,4);
    no_zero_bytes:=NOT check_zerobyte.Checked;
    pattern:='';
    IF check_filtername.Checked THEN pattern:=edit_filtername.Text;
    IF Extension='_All' THEN Extension:='';

    files:=GetFilesList(extension,pattern,no_zero_bytes);
    list.Items.Clear;
    IF Length(files)>0 THEN
      FOR i:=0 TO High(files) DO
        list.Items.Add(files[i]);
  END;

PROCEDURE TForm5.panel_extensionResize(Sender: TObject);
  BEGIN
    combo_extension.Width:=panel_extension.Width-5;
    edit_filtername.Width:=panel_extension.Width-5;
  END;

PROCEDURE TForm5.combo_extensionClick(Sender: TObject);
  BEGIN
    LoadFileNames;
  END;

PROCEDURE TForm5.check_zerobyteClick(Sender: TObject);
  VAR
    i:Byte;
  BEGIN
    LoadFileNames;
  END;

PROCEDURE TForm5.check_filternameClick(Sender: TObject);
  BEGIN
    edit_filtername.Enabled:=NOT check_filtername.Checked;
    LoadFileNames;
  END;

PROCEDURE TForm5.listClick(Sender: TObject);
  BEGIN
    _fileid:=GetFileIDByName(list.Items.Strings[list.ItemIndex]);
    lbl_notpossible.Visible:=False;
    Self.img.Visible:=True;
    Self.timer.Enabled:=False;
    Self.panel_buttons.Visible:=False;
    IF RightStr(list.Items.Strings[list.ItemIndex],4)='TXAN' THEN PreviewTXAN
    ELSE
    IF RightStr(list.Items.Strings[list.ItemIndex],4)='TXMB' THEN PreviewTXMB
    ELSE
    IF RightStr(list.Items.Strings[list.ItemIndex],4)='TXMP' THEN PreviewTXMP
    ELSE BEGIN
      Self.lbl_notpossible.Visible:=True;
      Self.img.Visible:=False;
    END;
  END;



PROCEDURE TForm5.PreviewTXMB;
  VAR
    data:Tdata;
    img:TImgPackage;
  BEGIN
    SetLength(memstreams,1);
    img:=LoadTXMBconnected(_fileid);
    data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);

    memstreams[0].Clear;
    memstreams[0].Write(data[0],Length(data));
    memstreams[0].Seek(0,soFromBeginning);

    Self.img.Picture.Bitmap.LoadFromStream(memstreams[0]);
  END;

PROCEDURE TForm5.PreviewTXMP;
  VAR
    data:Tdata;
    img:TImgPackage;
  BEGIN
    SetLength(memstreams,1);
    img:=LoadImgData(_fileid);
    data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);

    memstreams[0].Clear;
    memstreams[0].Write(data[0],Length(data));
    memstreams[0].Seek(0,soFromBeginning);

    Self.img.Picture.Bitmap.LoadFromStream(memstreams[0]);
  END;

PROCEDURE TForm5.PreviewTXAN;
  VAR
    loop_speed:Word;
    linkcount:LongWord;
    link:LongWord;
    i:Byte;
    data:Tdata;
    img:TImgPackage;
  BEGIN
    LoadDatFilePart(_fileid,$14,SizeOf(loop_speed),@loop_speed);
    LoadDatFilePart(_fileid,$1C,SizeOf(linkcount),@linkcount);
    SetLength(memstreams,linkcount);
    FOR i:=0 TO linkcount-1 DO BEGIN
      LoadDatFilePart(_fileid,$20+i*4,SizeOf(link),@link);
      link:=link DIV 256;
      IF link=0 THEN link:=_fileid-1;
      memstreams[i]:=TMemoryStream.Create;
      img:=LoadImgData(link);
      data:=ImgdataToBmp(img.imgx,img.imgy,img.imgdepth,img.storetype,img.imgdata);
      memstreams[i].Clear;
      memstreams[i].Write(data[0],Length(data));
      memstreams[i].Seek(0,soFromBeginning);
    END;
    actualimg:=254;
    Self.timer.Interval:=Floor(loop_speed*(1/60)*1000);
    Self.timer.Enabled:=False;
    Self.btn_startstopClick(Self);
    Self.panel_buttons.Visible:=True;
  END;


PROCEDURE TForm5.FormCreate(Sender: TObject);
  BEGIN
    SetLength(memstreams,1);
    memstreams[0]:=TMemoryStream.Create;
    Self.Width:=260;
    Self.Height:=300;
  END;

PROCEDURE TForm5.timerTimer(Sender: TObject);
  BEGIN
    Inc(actualimg);
    IF actualimg>=Length(memstreams) THEN actualimg:=0;
    Self.img.Picture.Bitmap.LoadFromStream(memstreams[actualimg]);
    memstreams[actualimg].Seek(0,soFromBeginning);
    Self.Caption:='Preview '+GetFileInfo(_fileid).FileName+' ('+IntToStr(actualimg+1)+'/'+IntToStr(Length(memstreams))+')';
  END;

PROCEDURE TForm5.panel_buttonsResize(Sender: TObject);
  BEGIN
    btn_startstop.Width:=panel_buttons.Width-45;
    btn_inc.Left:=panel_buttons.Width-23;
  END;

PROCEDURE TForm5.btn_startstopClick(Sender: TObject);
  BEGIN
    Self.timer.Enabled:=NOT Self.timer.Enabled;
    Self.btn_dec.Enabled:=NOT Self.timer.Enabled;
    Self.btn_inc.Enabled:=NOT Self.timer.Enabled;
    IF Self.timer.Enabled THEN
      Self.btn_startstop.Caption:='Stop automatic'
    ELSE
      Self.btn_startstop.Caption:='Start automatic';
  END;

PROCEDURE TForm5.FormResize(Sender: TObject);
  BEGIN
    IF Self.Width>=300 THEN BEGIN
    END ELSE Self.Width:=300;
    IF Self.Height>=200 THEN BEGIN
    END ELSE Self.Height:=200;
  END;

PROCEDURE TForm5.btn_decClick(Sender: TObject);
  BEGIN
    IF actualimg>0 THEN
      Dec(actualimg)
    ELSE
      actualimg:=High(memstreams);
    Self.Caption:='Preview '+GetFileInfo(_fileid).FileName+' ('+IntToStr(actualimg+1)+'/'+IntToStr(Length(memstreams))+')';
    Self.img.Picture.Bitmap.LoadFromStream(memstreams[actualimg]);
    memstreams[actualimg].Seek(0,soFromBeginning);
  END;

PROCEDURE TForm5.btn_incClick(Sender: TObject);
  BEGIN
    IF actualimg<High(memstreams) THEN
      Inc(actualimg)
    ELSE
      actualimg:=0;
    Self.Caption:='Preview '+GetFileInfo(_fileid).FileName+' ('+IntToStr(actualimg+1)+'/'+IntToStr(Length(memstreams))+')';
    Self.img.Picture.Bitmap.LoadFromStream(memstreams[actualimg]);
    memstreams[actualimg].Seek(0,soFromBeginning);
  END;


PROCEDURE TForm5.FormClose(Sender: TObject; var Action: TCloseAction);
  BEGIN
    Action:=caFree;
    Form1.close_window(Self.Name);
  END;


PROCEDURE TForm5.FormActivate(Sender: TObject);
  BEGIN
    Form1.SetActiveWindow(Self.Name);
  END;

END.
