/*
AE\Mod Installer.

Needs getPackages() now!
*/

#include <string>
#include <iostream>
#include "methods.h"
#include <vector>
#include <fstream>

#include <errno.h>
#ifdef WIN32
	#include "Include\dirent.h"
#else
	#include <dirent.h> //??? is this included for Macs?
#endif
#include <stdio.h>
#include <stdlib.h>


using namespace std;
bool FALSE = 0;
bool TRUE = 0;


int main(void)
{

	//	SetConsoleTitle("AE Installer"); windows junk, convert to SDL
	//	system("color 0A"); 
	
	cout << "\nWelcome to the AE installer!\n";

	cout << "\nWhat would you like to do?\n";
	
	return mainMenu();
}
 
vector<ModPackage> getPackages(void) {
	vector<ModPackage> packages;
	packages.reserve(256); //thats 63 or 64 pointers to packages...i think. :P Reserving this improves performance when we add new pointers
	
	fstream file;
	
	#ifdef WIN32
		string path = "K:\\Oni\\edition\\install\\packages"; //only for my build. :P
	#else
		string path = "K:\\Oni\\edition\\install\\packages"; //change this, 'scen.
	#endif

	string filename = "\0";
	string MODINFO_CFG = "\\Mod_Info.cfg";

	

	DIR *pdir;
	struct dirent *pent;

	pdir = opendir( path.c_str() ); //"." refers to the current dir
	if (!pdir){
		printf ("opendir() failure; terminating");
		exit(1);
	}
	errno=0; 

	while (( pent = readdir(pdir) )){
		
		filename = path + '\\' + pent->d_name + MODINFO_CFG;
		file.open(filename.c_str());

		//cout << filename << "\n";

		if(!file.fail() )
		{
			//file.open(filename.c_str(), fstream::out);
				
			//do stuff like adding to vector :P

			//would prefer to push a pointer to a package, but this will do for now
			packages.push_back( fileToModPackage(file) );
			
		}	
		file.close();
		file.clear();
		
	}

	
	if (errno){
		printf ("readdir() failure; terminating");
	exit(1);
	}
	closedir(pdir);
	
	
	return packages;
}

ModPackage fileToModPackage(fstream &file) {
	ModPackage package = {0, ""};
	string line;
	static string NameOfMod = "NameOfMod"; //used for comparing to the current token
	static string SLASHSLASH = "//";
	static string ARROW = "->";
			while (! file.eof() )
			{
				getline (file,line);
				     vector<string> tokens; 
					 vector<string>::iterator iter;
				Tokenize(line, tokens);					//string to vector of "words"
				if (tokens.capacity() >= 2) {			//make sure they are using enough stuff
					iter = tokens.begin();				//what word we are on, starts at first word
										/*
					if (!AEInstallVersion.compare(*iter))
						If mod is too old, skip this mod.
					*/
					/*else*/if (!NameOfMod.compare(*iter))  {	//if it contains the name
						for ( ; iter !=tokens.end() && SLASHSLASH.compare(*iter); iter++) {	//interates through the words, ends if it reaches the end of the line or a "//" comment
							if (ARROW.compare(*iter) && NameOfMod.compare(*iter)) {			//ignores "->" and "NameOfMod"
								//cout << *iter; 
								//cout << " ";
								package.name += *iter + " ";
							}
						}
						cout << package.name; cout << "\n"; //remove this when done
					/*
					else if (!ModString.compare(*iter)
					else if (!HasOnis.compare(*iter)
					else if (!HasDeltas.compare(*iter)
					else if (!HasBSL.compare(*iter)
					else if (!HasDats.compare(*iter)
					else if (!Category.compare(*iter)
					else if (!Creator.compare(*iter)
					else if (!IsEngine.compare(*iter)
					else if (!Readme.compare(*iter)
					else if (!GlobalNeeded.compare(*iter)
					*/
					}
					//cout << *iter;
				}
			
			}
			
	return package;
}

int mainMenu(void) {
	int choice = '0';
	bool ok = FALSE;
	cout << "1. Install new packages\n";
	cout << "2. Uninstall packages\n";
	cout << "3. See what is installed\n";
	cout << "4. About AE\n";
	cout << "5. Quit\n\n";
	
	do {
		ok = TRUE;
		choice = cin.get();
		cin.ignore(1);
		switch(choice) {
			case '1':
				installPackages();
				break;
			case '2':
				uninstallPackages();
				break;
			case '3':
				//listInstalledPackages();
				break;
			case '5':
				return 0;
			default:
				ok = FALSE;
		}
	} while(ok == FALSE);
	return 0;
}


void installPackages() {
	ModPackage package;
	vector<string> installed_packages;
	vector<ModPackage> packages; // = getPackages()
	vector<ModPackage>::iterator iter;
	iter = packages.begin();
	
	getPackages();

	if (packages.empty()) {
		cout << "Error: You have no packages!\n";
		return;
	}
			
	cout << "Detecting installed packages...\n";
	
		for(int i = 0; i < packages.size();) {
		package = *iter;
		if(!package.isInstalled){
			packages.erase(iter);
		}
		else { 
			i++;
			iter++;
		}
		
	}
	
	if (packages.empty()) {
		cout << "Error: You have no installed packages!\n";
		return;
	}
	
	//listInstalledPackages(packages);
	
}
void uninstallPackages() {
;
}

void getInstalledPackages() {
;
}
