#include "daodan_gl.h"

#define maxmodes (104) // Dirty hack to add more resolutions, it really should only be 16 ^_^

const M3tDisplayMode daodan_reslist[] = {
	{ 640,  480,  0, 0 },
	{ 800,  600,  0, 0 },
	{ 1024, 768,  0, 0 },
	{ 1280, 1024, 0, 0 },
	{ 1600, 1200, 0, 0 },
	{ 1920, 1080, 0, 0 },
};

const short daodan_resmodes[] = { 16, 32 };

unsigned int ONICALL daodan_enumerate_valid_display_modes(M3tDisplayMode modes[maxmodes])
{
	unsigned int vmodes = 0;
	unsigned int screen_x = GetSystemMetrics(SM_CXSCREEN);
	unsigned int screen_y = GetSystemMetrics(SM_CYSCREEN);
	
	int i, j;
	
	for (i = 0; i < sizeof(daodan_resmodes) / sizeof(short); i ++)
	{
		for (j = 0; j < sizeof(daodan_reslist) / sizeof(M3tDisplayMode); j ++)
			if (modes[vmodes].Width != screen_x && modes[vmodes].Height != screen_y)
			{
				modes[vmodes].Width  = daodan_reslist[j].Width;
				modes[vmodes].Height = daodan_reslist[j].Height;
				modes[vmodes].Depth  = daodan_resmodes[i];
				
				if (++vmodes == maxmodes - sizeof(daodan_reslist) / sizeof(M3tDisplayMode) + i)
					goto modesfull;
			}
		
		modes[vmodes].Width  = GetSystemMetrics(SM_CXSCREEN);
		modes[vmodes].Height = GetSystemMetrics(SM_CYSCREEN);
		modes[vmodes].Depth  = daodan_resmodes[i];
		if (++vmodes == maxmodes - sizeof(daodan_reslist) / sizeof(M3tDisplayMode) + i)
			goto modesfull;
	}
	
	modesfull:
	return vmodes;
}
