/* AE/Mod Installer header file */

#include <string>
#include <vector>
#include <fstream>

using namespace std;

static string SLASHSLASH = "//";
static string DIRSLASH = "\\";

#define STRUCT_DEFS 
struct ModPackage
{
	bool	isInstalled; //replace with function 
	string	name;
	string	modStringName;
	int	modStringVersion;
	bool	hasOnis;
	bool	hasDeltas;
	bool	hasBSL;
	bool	hasDats;
	string	category;
	string	creator;
	bool	isEngine;
	string	readme;
	bool	globalNeeded;
	ModPackage();
	void doOutput()
	{
		cout << "Mod: " << name; cout << "\n"; // remove this when done
		cout << "	String: " << modStringName << " v." << modStringVersion << "\n";
		cout << "	Category: " << category << "\n";
		cout << "	Creator: " << creator << "\n";
		cout << "	HasOnis: " << hasOnis << "\n";
		cout << "	HasBSL: " << hasBSL << "\n";
		cout << "	HasDeltas: " << hasDeltas << "\n";
		cout << "	HasDats: " << hasDats << "\n";
		cout << "	IsEngine: " << isEngine << "\n";
		cout << "	GlobalNeeded: " << globalNeeded << "\n";
		cout << "	Readme: " << readme << "\n";
		cout << "\n";
	}

};

#define METHOD_DEFS 
// Initialization to default values
ModPackage::ModPackage()
{
	isInstalled = true; // replace with function 
	name = "";
	modStringName = "";
	modStringVersion = 0;
	hasOnis = false;
	hasDeltas = false;
	hasBSL = false;
	hasDats = false;
	category = "";
	creator = "";
	isEngine = false;
	readme = "";
	globalNeeded = true;
	//		void doOutput() const
	//		{ };
}

#define FUNCTION_PROTOTYPES 
int mainMenu(void);
int globalizeData(void);
int installPackages(void);
int uninstallPackages(void);
int listInstalledPackages(void);
int printInstallerInfo(void);
vector<ModPackage> getPackages(void);
ModPackage fileToModPackage(fstream&);
void recompileAll(vector<string>);
vector<string> getInstallString(void);
void tokenize(const string&, vector<string>&, const string& delimiters = " ");
//bool getDirectoryContents(char , char &);