UNIT Unit8_binedit;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Wrapgrid, StdCtrls, Grids, StrUtils, MPHexEditor, ExtCtrls, Clipbrd,
  Unit3_data, Unit2_functions, Unit9_data_structures, Unit4_exporters, Menus, Math,
  VirtualTrees, VTHeaderPopup;

TYPE
  TForm8 = Class(TForm)
    Splitter1: TSplitter;
    panel_data: TPanel;
    hex: TMPHexEditor;
    Splitter2: TSplitter;
    panel_files: TPanel;
    list: TListBox;
    panel_extension: TPanel;
    lbl_filter: TLabel;
    combo_extension: TComboBox;
    Bevel1: TBevel;
    panel_imexport: TPanel;
    btn_export: TButton;
    btn_import: TButton;
    opend: TOpenDialog;
    saved: TSaveDialog;
    value_viewer: TWrapGrid;
    Splitter3: TSplitter;
    value_viewer_context: TPopupMenu;
    value_viewer_context_copy: TMenuItem;
    value_viewer_context_copyashex: TMenuItem;
    value_viewer_context_copyasdec: TMenuItem;
    value_viewer_context_copyasfloat: TMenuItem;
    value_viewer_context_copyasbitset: TMenuItem;
    value_viewer_context_copyasstring: TMenuItem;
    check_zerobyte: TCheckBox;
    edit_filtername: TEdit;
    check_filtername: TCheckBox;
    VST: TVirtualStringTree;
    VTHPopup: TVTHeaderPopupMenu;
    procedure VSTFocusChanged(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex);
    procedure VSTDblClick(Sender: TObject);
    procedure VTHPopupColumnChange(const Sender: TBaseVirtualTree;
      const Column: TColumnIndex; Visible: Boolean);
    procedure VSTHeaderDragged(Sender: TVTHeader; Column: TColumnIndex;
      OldPosition: Integer);
    procedure VSTGetText(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex; TextType: TVSTTextType; var CellText: WideString);
    procedure hexKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    PROCEDURE LoadDat(_fileid:LongWord);
    PROCEDURE LoadFileNames;
    PROCEDURE check_filternameClick(Sender: TObject);
    PROCEDURE check_zerobyteClick(Sender: TObject);
    PROCEDURE combo_extensionClick(Sender: TObject);
    PROCEDURE panel_extensionResize(Sender: TObject);
    PROCEDURE listClick(Sender: TObject);
    PROCEDURE Recreatelist;

    PROCEDURE FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    PROCEDURE value_viewerDblClick(Sender: TObject);
    PROCEDURE value_viewer_context_copyClick(Sender: TObject);
    PROCEDURE value_viewerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    PROCEDURE value_viewer_contextPopup(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE btn_importClick(Sender: TObject);
    PROCEDURE btn_exportClick(Sender: TObject);
    PROCEDURE panel_imexportResize(Sender: TObject);
    FUNCTION Save:Boolean;
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
    FUNCTION GetValue(datatype:Word; offset:LongWord):String;
    PROCEDURE WriteStructureInfos; //(structinfoid:Integer);
    PROCEDURE hexSelectionChanged(Sender: TObject);
    PROCEDURE hexChange(Sender: TObject);
    PROCEDURE FormResize(Sender: TObject);
    PROCEDURE ClearStructViewer;
    PROCEDURE FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    PROCEDURE FormCreate(Sender: TObject);
    PROCEDURE ClearValues;
    PROCEDURE WriteValues;
    PROCEDURE SetNewValue(datatype:Word; offset:LongWord; value:String);
  PRIVATE
  PUBLIC
  END;

VAR
  Form8: TForm8;

IMPLEMENTATION
{$R *.dfm}
USES Unit1_main, Unit12_ValueEdit, Unit13_rawedit;
VAR
  fileid:LongWord;

TYPE
  PNodeData = ^TNodeData;
  TNodeData = record
    Caption:String;
    Offset:LongInt;
    DataType:Word;
    Value:String;
    Description:String;
  end;


function AddVSTEntry(AVST:TCustomVirtualStringTree; ANode:PVirtualNode; ARecord:TNodeData):PVirtualNode;
  var
    data:PNodeData;
  begin
    Result:=AVST.AddChild(ANode);
    data:=AVST.GetNodeData(Result);
    AVST.ValidateNode(Result,False);
    data^:=ARecord;
  end;



PROCEDURE TForm8.LoadDat(_fileid:LongWord);
  VAR
    i:LongWord;
    mem:TMemoryStream;
    data:Tdata;
  BEGIN
    IF hex.Modified THEN BEGIN
      IF NOT Save THEN BEGIN
        FOR i:=0 TO list.Count-1 DO BEGIN
          IF GetFileIDByName(list.Items.Strings[i])=fileid THEN BEGIN
            list.ItemIndex:=i;
            Exit;
          END;
        END;
      END;
    END;
    fileid:=_fileid;
    FOR i:=0 TO list.Count-1 DO
      IF GetFileIDByName(list.Items.Strings[i])=fileid THEN
        list.ItemIndex:=i;
    Self.ClearStructViewer;
    data:=LoadDatFile(fileid);
    IF Length(data)>0 THEN BEGIN
      mem:=TMemoryStream.Create;
      mem.Write(data[0],Length(data));
      mem.Seek(0,soFromBeginning);
      hex.LoadFromStream(mem);
      mem.Free;
      WriteStructureInfos; 
    END ELSE BEGIN
      ClearValues;
      hex.DataSize:=0;
    END;
  END;

PROCEDURE TForm8.Recreatelist;
  VAR
    i:LongWord;
    exts:TStringList;
  BEGIN
    combo_extension.Items.Clear;
    combo_extension.Items.Add('_All files_ ('+IntToStr(GetFilesCount)+')');
    exts:=GetExtensionsList;
    FOR i:=0 TO High(exts) DO
      combo_extension.Items.Add(exts[i]);
    combo_extension.ItemIndex:=0;
    combo_extensionClick(Self);
  END;

PROCEDURE TForm8.LoadFileNames;
  VAR
    Extension:String[4];
    no_zero_bytes:Boolean;
    pattern:String;
    files:TStringList;
    i:LongWord;
  BEGIN
    Extension:=MidStr(combo_extension.Items.Strings[combo_extension.ItemIndex],1,4);
    no_zero_bytes:=NOT check_zerobyte.Checked;
    pattern:='';
    IF check_filtername.Checked THEN pattern:=edit_filtername.Text;
    IF Extension='_All' THEN Extension:='';

    files:=GetFilesList(extension,pattern,no_zero_bytes);
    list.Items.Clear;
    IF Length(files)>0 THEN
      FOR i:=0 TO High(files) DO
        list.Items.Add(files[i]);
  END;

PROCEDURE TForm8.panel_extensionResize(Sender: TObject);
  BEGIN
    combo_extension.Width:=panel_extension.Width-5;
    edit_filtername.Width:=panel_extension.Width-5;
  END;

PROCEDURE TForm8.combo_extensionClick(Sender: TObject);
  BEGIN
    LoadFileNames;
  END;

PROCEDURE TForm8.check_zerobyteClick(Sender: TObject);
  VAR
    i:Byte;
  BEGIN
    LoadFileNames;
  END;

PROCEDURE TForm8.check_filternameClick(Sender: TObject);
  BEGIN
    edit_filtername.Enabled:=NOT check_filtername.Checked;
    LoadFileNames;
  END;

PROCEDURE TForm8.listClick(Sender: TObject);
  VAR
    mem:TMemoryStream;
    data:Tdata;
    i:LongWord;
  BEGIN
    LoadDat(GetFileIDByName(list.Items.Strings[list.ItemIndex]));
  END;




FUNCTION IntToBin(value:Byte):String;
  VAR i:Byte;
  BEGIN
    Result:='';
    FOR i:=7 DOWNTO 0 DO BEGIN
      Result:=Result+IntToStr((value SHR i) AND $01);
    END;
  END;

FUNCTION TForm8.GetValue(datatype:Word; offset:LongWord):String;
  VAR
    data:Tdata;
    i:Word;
  BEGIN
    CASE datatype OF
      1: Result:=IntToStr(hex.data[offset]);
      2: Result:=IntToStr(hex.data[offset]+hex.data[offset+1]*256);
      3: Result:=IntToStr(hex.data[offset]+hex.data[offset+1]*256+hex.data[offset+2]*256*256);
      4: Result:=IntToStr(hex.data[offset]+hex.data[offset+1]*256+hex.data[offset+2]*256*256+hex.data[offset+3]*256*256*256);
      5: Result:='0x'+IntToHex(hex.data[offset],2);
      6: Result:='0x'+IntToHex(hex.data[offset]+hex.data[offset+1]*256,4);
      7: Result:='0x'+IntToHex(hex.data[offset]+hex.data[offset+1]*256+hex.data[offset+2]*256*256,6);
      8: Result:='0x'+IntToHex(hex.data[offset]+hex.data[offset+1]*256+hex.data[offset+2]*256*256+hex.data[offset+3]*256*256*256,8);
      9: BEGIN
          SetLength(data,4);
          data[0]:=hex.data[offset];
          data[1]:=hex.data[offset+1];
          data[2]:=hex.data[offset+2];
          data[3]:=hex.data[offset+3];
          Result:=FloatToStr(Decode_Float(data));
        END;
      10: Result:=IntToBin(hex.data[offset]);
      11: Result:='0x'+IntToHex(GetRawInfo(fileid,offset).raw_addr,8);
      12: Result:=FormatNumber(hex.data[offset+1]+hex.data[offset+2]*256+hex.data[offset+3]*256*256,5,'0');
      13: Result:=IntToStr(hex.data[offset]);
      14: Result:=IntToStr(hex.data[offset]+hex.data[offset+1]*256);
      15: Result:=IntToStr(hex.data[offset]+hex.data[offset+1]*256+hex.data[offset+2]*256*256);
      16: Result:=IntToStr(hex.data[offset]+hex.data[offset+1]*256+hex.data[offset+2]*256*256+hex.data[offset+3]*256*256*256);
      1000..9999: BEGIN
          Result:='';
          FOR i:=1 TO datatype-1000 DO BEGIN
            IF hex.Data[offset+i-1]>=32 THEN
              Result:=Result+Chr(hex.Data[offset+i-1])
            ELSE
              Result:=Result+'.';
          END;
        END;
      10000..65535: BEGIN
          Result:='';
          FOR i:=1 TO datatype-10000 DO BEGIN
            IF hex.Data[offset+i-1]>=32 THEN
              Result:=Result+Chr(hex.Data[offset+i-1])
            ELSE
              Result:=Result+'.';
          END;
        END;
    END;
  END;

PROCEDURE TForm8.WriteStructureInfos;
  VAR
    i,j:LongWord;
    pdata: PNodeData;
    data: TNodeData;
    node: PVirtualNode;
    structs: TStructDef;
  BEGIN
    VST.BeginUpdate;
    IF VST.RootNodeCount=0 THEN BEGIN
      structs:=LoadStructureDefinition(fileid);
      IF structs.data THEN BEGIN
        IF Length(structs.Global)>0 THEN BEGIN
          FOR i:=0 TO High(structs.Global) DO BEGIN
            data.Caption:=structs.Global[i].name;
            data.Offset:=structs.Global[i].offset;
            data.DataType:=structs.Global[i].datatype;
            data.Value:=GetValue(structs.Global[i].datatype, structs.Global[i].offset);
            data.Description:=structs.Global[i].description;
            AddVSTEntry(VST, nil, data);
          END;
        END;
        IF Length(structs.Subs)>0 THEN BEGIN
          FOR i:=0 TO High(structs.Subs) DO BEGIN
            WITH structs.Subs[i] DO BEGIN
              IF Length(Entries)>0 THEN BEGIN
                IF Pos('#',SubName)>0 THEN BEGIN
                  data.Offset:=HexToLong(MidStr(SubName, Pos('#',SubName)+1, 8));
                  data.Value:=MidStr(SubName, PosEx('#',SubName,Pos('#',SubName)+1)+1, 8);
                  data.Caption:=MidStr(SubName, 1, Pos('#',SubName)-1);
                  data.Description:=SubDesc;
                END ELSE BEGIN
                  data.Caption:=SubName;
                  data.Description:=SubDesc;
                  data.Offset:=0;
                  data.Value:='';
                END;
                data.DataType:=0;
                node:=AddVSTEntry(VST, nil, data);
                data.Description:='';
                FOR j:=0 TO High(Entries) DO BEGIN
                  data.Caption:=Entries[j].name;
                  data.Offset:=Entries[j].offset;
                  data.DataType:=Entries[j].datatype;
                  data.Value:=GetValue(Entries[j].datatype, Entries[j].offset);
                  data.Description:=Entries[j].description;
                  AddVSTEntry(VST, node, data);
                END;
              END;
            END;
          END;
        END;
      END;
      IF VST.RootNodeCount>0 THEN
        VST.FocusedNode:=VST.GetFirst;
    END ELSE BEGIN
      Node:=VST.GetFirst;
      WHILE Assigned(Node) DO BEGIN
        pdata:=VST.GetNodeData(Node);
        IF pdata.DataType>0 THEN
          pdata.Value:=GetValue(pdata.Datatype, pdata.Offset);
        Node:=VST.GetNext(Node);
      END;
    END;
    VST.EndUpdate;
  END;

PROCEDURE TForm8.ClearValues;
  VAR
    i:Byte;
  BEGIN
    FOR i:=1 TO value_viewer.RowCount-1 DO BEGIN
      value_viewer.Cells[1,i]:='';
    END;
  END;

PROCEDURE TForm8.WriteValues;
  VAR
    i,j:Byte;
    data:Tdata;
    str:String;
    value:LongWord;
  BEGIN
    FOR i:=1 TO value_viewer.RowCount-1 DO BEGIN
      IF value_viewer.Cells[0,i]='1 byte, unsigned' THEN BEGIN
        IF ((hex.SelCount=1) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+1)>hex.DataSize) THEN BEGIN
          value:=hex.Data[hex.SelStart];
          value_viewer.Cells[1,i]:=IntToStr( value )+' / 0x'+IntToHex( value , 2 );
        END ELSE
          value_viewer.Cells[1,i]:='';
      END;
      IF value_viewer.Cells[0,i]='2 bytes, unsigned' THEN BEGIN
        IF ((hex.SelCount=2) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+2)>hex.DataSize) THEN BEGIN
          value:=hex.Data[hex.SelStart] + hex.Data[hex.SelStart+1]*256;
          value_viewer.Cells[1,i]:=IntToStr( value )+' / 0x'+IntToHex( value , 4 );
        END ELSE
          value_viewer.Cells[1,i]:='';
      END;
      IF value_viewer.Cells[0,i]='4 bytes, unsigned' THEN BEGIN
        IF ((hex.SelCount=4) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+4)>hex.DataSize) THEN BEGIN
          value:=hex.Data[hex.SelStart]+hex.Data[hex.SelStart+1]*256+hex.Data[hex.SelStart+2]*256*256+hex.Data[hex.SelStart+3]*256*256*256;
          value_viewer.Cells[1,i]:=IntToStr( value )+' / 0x'+IntToHex( value , 8 );
        END ELSE
          value_viewer.Cells[1,i]:='';
      END;
      IF value_viewer.Cells[0,i]='Bitset' THEN BEGIN
        IF (hex.SelCount<=8) THEN BEGIN
          IF hex.SelCount=0 THEN BEGIN
            SetLength(data,1);
            data[0]:=hex.Data[hex.SelStart];
          END ELSE BEGIN
            SetLength(data,hex.SelCount);
            FOR j:=0 TO hex.SelCount-1 DO
              data[j]:=hex.Data[hex.SelStart+j];
          END;
          value_viewer.Cells[1,i]:=DataToBin(data);
        END ELSE
          value_viewer.Cells[1,i]:='';
      END;
      IF value_viewer.Cells[0,i]='Float' THEN BEGIN
        IF ((hex.SelCount=4) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+4)>hex.DataSize) THEN BEGIN
          SetLength(data,4);
          FOR j:=0 TO 3 DO
            data[j]:=hex.Data[hex.SelStart+j];
          value_viewer.Cells[1,i]:=FloatToStr(Decode_Float(data));
        END ELSE
          value_viewer.Cells[1,i]:='';
      END;
      IF value_viewer.Cells[0,i]='Selected length' THEN BEGIN
        value_viewer.Cells[1,i]:=IntToStr(hex.SelCount)+' bytes';
      END;
      IF value_viewer.Cells[0,i]='String' THEN BEGIN
        j:=0;
        str:='';
        IF hex.SelCount=0 THEN BEGIN
{          WHILE (hex.Data[hex.SelStart+j]>0) AND ((hex.SelStart+j)<hex.DataSize) DO BEGIN
            IF hex.Data[hex.selstart+j]>=32 THEN
              str:=str+Char(hex.Data[hex.SelStart+j])
            ELSE
              str:=str+'.';
            Inc(j);
          END;
}        END ELSE BEGIN
          FOR j:=1 TO hex.SelCount DO
            str:=str+Char(hex.Data[hex.SelStart+j-1]);
        END;
        value_viewer.Cells[1,i]:=str;
      END;
    END;
  END;

PROCEDURE TForm8.FormCreate(Sender: TObject);
  BEGIN
    Self.Caption:='';
    fileid:=0;
    VST.NodeDataSize:=SizeOf(TNodeData);
    value_viewer.ColCount:=2;
    value_viewer.RowCount:=8;
    value_viewer.FixedRows:=1;
    value_viewer.Cells[0,0]:='Type';
    value_viewer.Cells[1,0]:='Value';
    value_viewer.Cells[0,1]:='1 byte, unsigned';
    value_viewer.Cells[0,2]:='2 bytes, unsigned';
    value_viewer.Cells[0,3]:='4 bytes, unsigned';
    value_viewer.Cells[0,4]:='Bitset';
    value_viewer.Cells[0,5]:='Float';
    value_viewer.Cells[0,6]:='String';
    value_viewer.Cells[0,7]:='Selected length';
    value_viewer.ColWidths[0]:=100;
    hex.Height:=panel_data.Height-215;
  END;

FUNCTION TForm8.Save:Boolean;
  VAR
    mem:TMemoryStream;
    data:Tdata;
    i:LongWord;
  BEGIN
    CASE MessageBox(Self.Handle,PChar('Save changes to file '+GetFileInfo(fileid).FileName+'?'),PChar('Data changed...'),MB_YESNOCANCEL) OF
      IDYES: BEGIN
          mem:=TMemoryStream.Create;
          hex.SaveToStream(mem);
          mem.Seek(0,soFromBeginning);
          SetLength(data,mem.Size);
          mem.Read(data[0],mem.Size);
          mem.Free;
          UpdateDatFile(fileid,data);
          hex.Modified:=False;
          FOR i:=0 TO hex.Datasize-1 DO hex.ByteChanged[i]:=False;
          Result:=True;
        END;
      IDNO: Result:=True;
      IDCANCEL: BEGIN
          Result:=False;
        END;
    END;
  END;

PROCEDURE TForm8.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  BEGIN
    IF hex.Modified THEN BEGIN
      IF NOT Save THEN CanClose:=False;
    END;
  END;

PROCEDURE TForm8.ClearStructViewer;
  BEGIN
    VST.Clear;
  END;

PROCEDURE TForm8.FormResize(Sender: TObject);
  BEGIN
    IF Self.Width>=650 THEN BEGIN
    END ELSE Self.Width:=650;
    IF Self.Height>=450 THEN BEGIN
    END ELSE Self.Height:=450;
  END;

PROCEDURE TForm8.hexChange(Sender: TObject);
  BEGIN
    ClearValues;
    IF hex.DataSize>0 THEN BEGIN
      WriteStructureInfos;
      WriteValues;
    END;
  END;

PROCEDURE TForm8.hexKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
  VAR
    temps: String;
  BEGIN
    IF (Shift=[ssCtrl]) AND (Key=Ord('C')) THEN BEGIN
      IF hex.SelCount>0 THEN BEGIN
        IF hex.InCharField THEN
          Clipboard.AsText:=hex.SelectionAsText
        ELSE
          Clipboard.AsText:=hex.SelectionAsHex;
      END;
    END;
    IF (Shift=[ssCtrl]) AND (Key=Ord('V')) THEN BEGIN
{      temps:=Clipboard.AsText;
      IF hex.SelStart+Length(temps)>hex.DataSize THEN
        SetLength(temps, hex.DataSize-hex.SelStart);
      hex.Sel
      hex.SelCount:=Length(temps);
      hex.ReplaceSelection(temps,Length(temps));
}    END;
  END;

PROCEDURE TForm8.hexSelectionChanged(Sender: TObject);
  VAR
    selstart:Integer;
    i,j:Word;

    node:PVirtualNode;
    pdata:PNodeData;
  BEGIN
    IF hex.DataSize>0 THEN BEGIN
      WriteValues;
      selstart:=hex.SelStart;
      IF VST.RootNodeCount>0 THEN BEGIN
        Node:=VST.GetFirst;
        WHILE Assigned(Node) DO BEGIN
          pdata:=VST.GetNodeData(Node);
          IF pdata.DataType>0 THEN BEGIN
            IF ((selstart-pdata.Offset)<GetTypeDataLength(pdata.DataType)) AND ((selstart-pdata.Offset)>=0) THEN BEGIN
              VST.FocusedNode:=Node;
              VST.Selected[Node]:=True;
              Break;
            END;
          END;
          Node:=VST.GetNext(Node);
        END;
      END;
    END;
  END;

PROCEDURE TForm8.FormClose(Sender: TObject; var Action: TCloseAction);
  BEGIN
    Action:=caFree;
    Form1.close_window(Self.Name);
  END;

PROCEDURE TForm8.panel_imexportResize(Sender: TObject);
  BEGIN
    btn_import.Width:=panel_imexport.Width-8;
    btn_export.Width:=panel_imexport.Width-8;
  END;

PROCEDURE TForm8.btn_exportClick(Sender: TObject);
  BEGIN
    saved.Filter:='Files of matching extension (*.'+GetFileInfo(fileid).Extension+')|*.'+dat_files[fileid].Extension+'|All files|*.*';
    saved.DefaultExt:=GetFileInfo(fileid).Extension;
    IF saved.Execute THEN BEGIN
      ExportDatFile(fileid,saved.FileName);
    END;
  END;

PROCEDURE TForm8.btn_importClick(Sender: TObject);
  VAR
    data:Tdata;
    fs:TFileStream;
  BEGIN
    opend.Filter:='Files of matching extension (*.'+GetFileInfo(fileid).Extension+')|*.'+dat_files[fileid].Extension+'|All files|*.*';
    IF opend.Execute THEN BEGIN
      fs:=TFileStream.Create(opend.FileName,fmOpenRead);
      IF fs.Size<>hex.DataSize THEN BEGIN
        ShowMessage('Can''t import '+ExtractFilename(opend.FileName)+
                    ', file has to have same size as file in .dat.'+CrLf+
                    'Size of file in .dat: '+FormatFileSize(hex.datasize)+CrLf+
                    'Size of chosen file: '+FormatFileSize(fs.Size));
      END ELSE BEGIN
        hex.LoadFromStream(fs);
        hex.Modified:=True;
      END;
      fs.Free;
    END;
  END;

PROCEDURE TForm8.FormActivate(Sender: TObject);
  BEGIN
    Form1.SetActiveWindow(Self.Name);
  END;

PROCEDURE TForm8.value_viewer_contextPopup(Sender: TObject);
  VAR
    i:Byte;
  BEGIN
    FOR i:=0 TO value_viewer_context.Items.Count-1 DO
      value_viewer_context.Items.Items[i].Visible:=False;
    WITH value_viewer DO BEGIN
      IF (Col=1) AND (Row>0) AND (Length(Cells[Col,Row])>0) THEN BEGIN
        IF Pos(' byte',Cells[0,Row])=2 THEN BEGIN
          value_viewer_context.Items.Find('Copy to &clipboard').Visible:=True;
          value_viewer_context.Items.Find('Copy to clipboard (as &dec)').Visible:=True;
          value_viewer_context.Items.Find('Copy to clipboard (as &hex)').Visible:=True;
        END;
        IF Pos('Float',Cells[0,Row])=1 THEN
          value_viewer_context.Items.Find('Copy to clipboard (as &float)').Visible:=True;
        IF Pos('Bitset',Cells[0,Row])=1 THEN
          value_viewer_context.Items.Find('Copy to clipboard (as &bitset)').Visible:=True;
        IF Pos('String',Cells[0,Row])=1 THEN
          value_viewer_context.Items.Find('Copy to clipboard (as &string)').Visible:=True;
        IF Pos('Selected length',Cells[0,Row])=1 THEN
          value_viewer_context.Items.Find('Copy to &clipboard').Visible:=True;
      END;
    END;
  END;

PROCEDURE TForm8.value_viewerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  VAR
    ACol,ARow:Integer;
  BEGIN
    IF Button=mbRight THEN BEGIN
      value_viewer.MouseToCell(x,y,ACol,ARow);
      IF ARow>0 THEN BEGIN
        value_viewer.Col:=ACol;
        value_viewer.Row:=ARow;
      END;
    END;
  END;

PROCEDURE TForm8.value_viewer_context_copyClick(Sender: TObject);
  VAR
    i:Byte;
    name:String;
    value:LongWord;
  BEGIN
    name:=TMenuItem(Sender).Name;
    IF Pos('asstring',name)>0 THEN BEGIN
      Clipboard.AsText:=value_viewer.Cells[value_viewer.Col,value_viewer.Row];
    END ELSE
    IF Pos('asfloat',name)>0 THEN BEGIN
      Clipboard.AsText:=value_viewer.Cells[value_viewer.Col,value_viewer.Row];
    END ELSE
    IF Pos('asbitset',name)>0 THEN BEGIN
      Clipboard.AsText:=value_viewer.Cells[value_viewer.Col,value_viewer.Row];
    END ELSE
    IF (Pos('ashex',name)>0) OR (Pos('asdec',name)>0) THEN BEGIN
      IF value_viewer.Cells[0,value_viewer.Row]='1 byte, unsigned' THEN BEGIN
        IF ((hex.SelCount=1) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+1)>hex.DataSize) THEN
          value:=hex.Data[hex.SelStart];
      END;
      IF value_viewer.Cells[0,value_viewer.Row]='2 bytes, unsigned' THEN BEGIN
        IF ((hex.SelCount=2) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+2)>hex.DataSize) THEN
          value:=hex.Data[hex.SelStart] + hex.Data[hex.SelStart+1]*256;
      END;
      IF value_viewer.Cells[0,value_viewer.Row]='4 bytes, unsigned' THEN BEGIN
        IF ((hex.SelCount=4) OR (hex.SelCount=0)) AND NOT ((hex.SelStart+4)>hex.DataSize) THEN
          value:=hex.Data[hex.SelStart]+hex.Data[hex.SelStart+1]*256+hex.Data[hex.SelStart+2]*256*256+hex.Data[hex.SelStart+3]*256*256*256;
      END;
      IF Pos('asdec',name)>0 THEN BEGIN
        Clipboard.AsText:=IntToStr(value);
      END ELSE BEGIN
        IF value_viewer.Cells[0,value_viewer.Row]='1 byte, unsigned' THEN
          Clipboard.AsText:='0x'+IntToHex(value,2);
        IF value_viewer.Cells[0,value_viewer.Row]='2 bytes, unsigned' THEN
          Clipboard.AsText:='0x'+IntToHex(value,4);
        IF value_viewer.Cells[0,value_viewer.Row]='4 bytes, unsigned' THEN
          Clipboard.AsText:='0x'+IntToHex(value,8);
      END;
    END ELSE BEGIN
      Clipboard.AsText:=value_viewer.Cells[value_viewer.Col,value_viewer.Row];
    END;
  END;

procedure TForm8.VSTDblClick(Sender: TObject);
  var
    node:PVirtualNode;
    nodedata:PNodeData;
  begin
    if VST.FocusedColumn=3 then begin
      node:=VST.FocusedNode;
      nodedata:=VST.GetNodeData(node);

      IF NOT (nodedata.datatype IN [11,12]) THEN BEGIN
        Form12.MakeVarInput(nodedata.Caption,nodedata.offset,nodedata.datatype,nodedata.value,Self);
      END ELSE BEGIN
        IF nodedata.DataType=11 THEN BEGIN
          IF GetRawInfo(fileid,nodedata.offset).raw_size>0 THEN BEGIN
            IF Form1.open_child('rawedit') THEN BEGIN
              TForm13(Form1.ActiveMDIChild).LoadRaw(GetRawInfo(fileid,nodedata.offset));
            END;
          END;
        END;
        IF nodedata.DataType=12 THEN BEGIN
          IF (StrToInt(nodedata.Value)<GetFilesCount) AND
              (StrToInt(nodedata.Value)>0) AND
              (StrToInt(nodedata.Value)<>fileid) THEN BEGIN
            IF GetFileInfo(StrToInt(nodedata.Value)).Size>0 THEN BEGIN
              IF Form1.open_child('binedit') THEN BEGIN
                TForm8(Form1.ActiveMDIChild).LoadDat(StrToInt(nodedata.Value));
              END;
            END ELSE BEGIN
              ShowMessage('Linked filed is a zero-byte-file');
            END;
          END;
        END;
      END;

    end;
  end;

procedure TForm8.VSTFocusChanged(Sender: TBaseVirtualTree; Node: PVirtualNode;
  Column: TColumnIndex);
  var
    data:PNodeData;
  begin
    data:=VST.GetNodeData(node);
    IF data.DataType>0 THEN BEGIN
      hex.SelStart:=data.Offset;
      hex.SelEnd:=data.Offset+GetTypeDataLength(data.DataType)-1;
    END ELSE BEGIN
      hex.SelStart:=data.Offset;
      hex.SelEnd:=data.Offset+HexToLong(data.Value)-1;
    END;
  end;

procedure TForm8.VSTGetText(Sender: TBaseVirtualTree; Node: PVirtualNode;
  Column: TColumnIndex; TextType: TVSTTextType; var CellText: WideString);
  var
    data:PNodeData;
  begin
    data := Sender.GetNodeData(Node);
    CellText := '';
    if TextType = ttNormal then begin
      case Column of
        0: CellText := data.Caption;
        1:
          if data.DataType>0 then
            CellText := '0x'+IntToHex(data.Offset,8)
          else
            if data.Offset>0 then
              CellText := '0x'+IntToHex(data.Offset,8);
        2:
          if data.DataType>0 then
            CellText := GetDataType(data.DataType);
        3:
          if data.DataType>0 then
            CellText := GetValue(data.DataType, data.Offset)
          else
            if Length(data.Value)>0 then
              CellText := IntToStr(HexToLong(data.Value))+' Bytes';
        4:
          CellText := data.Description;
      end;
    end;
  end;

procedure TForm8.VSTHeaderDragged(Sender: TVTHeader; Column: TColumnIndex;
  OldPosition: Integer);
  begin
    if Sender.Columns.Items[column].Position<1 then
      Sender.Columns.Items[column].Position:=OldPosition;
  end;

procedure TForm8.VTHPopupColumnChange(const Sender: TBaseVirtualTree;
  const Column: TColumnIndex; Visible: Boolean);
  begin
    if column=0 then
      TVirtualStringTree(Sender).Header.Columns.Items[column].Options:=TVirtualStringTree(Sender).Header.Columns.Items[column].Options+[coVisible];
  end;

PROCEDURE TForm8.SetNewValue(datatype:Word; offset:LongWord; value:String);
  VAR
    data:Tdata;
    value_int:LongWord;
    value_float:Single;
    i:Word;
  BEGIN
    CASE datatype OF
      1..4: BEGIN
              value_int:=StrToInt(value);
              SetLength(data,datatype);
              FOR i:=0 TO datatype-1 DO BEGIN
                data[i]:=value_int MOD 256;
                value_int:=value_int DIV 256;
              END;
            END;
      5..8: BEGIN
              value_int:=StrToInt('$'+value);
              SetLength(data,datatype-4);
              FOR i:=0 TO datatype-5 DO BEGIN
                data[i]:=value_int MOD 256;
                value_int:=value_int DIV 256;
              END;
            END;
      9:    BEGIN
              value_float:=StrToFloat(value);
              data:=Encode_Float(value_float);
            END;
      10:   BEGIN
              value_int:=BinToInt(value);
              SetLength(data,1);
              data[0]:=value_int;
            END;
      10000..65535: BEGIN
              SetLength(data,datatype-10000);
              FOR i:=1 TO datatype-10000 DO BEGIN
                IF i<=Length(value) THEN
                  data[i-1]:=Ord(value[i])
                ELSE
                  data[i-1]:=0;
              END;
            END;
    END;
    FOR i:=0 TO High(data) DO BEGIN
      IF hex.Data[offset+i]<>data[i] THEN hex.ByteChanged[offset+i]:=True;
      hex.Data[offset+i]:=data[i];
    END;
    hex.Modified:=True;
    hexChange(Self);
    hex.Repaint;
  END;

PROCEDURE TForm8.value_viewerDblClick(Sender: TObject);
  VAR
    offset:LongWord;
    datatype:Word;
    objectname:String;
    value:String;
  BEGIN
    IF (value_viewer.Col=1) AND (Length(value_viewer.Cells[1,value_viewer.Row])>0) THEN BEGIN
      offset:=hex.SelStart;
      IF value_viewer.Cells[0,value_viewer.Row]='1 byte, unsigned' THEN
        datatype:=1;
      IF value_viewer.Cells[0,value_viewer.Row]='2 bytes, unsigned' THEN
        datatype:=2;
      IF value_viewer.Cells[0,value_viewer.Row]='4 bytes, unsigned' THEN
        datatype:=4;
      IF value_viewer.Cells[0,value_viewer.Row]='Bitset' THEN
        datatype:=10;
      IF value_viewer.Cells[0,value_viewer.Row]='Float' THEN
        datatype:=9;
      IF value_viewer.Cells[0,value_viewer.Row]='Selected length' THEN
        Exit;
      IF value_viewer.Cells[0,value_viewer.Row]='String' THEN BEGIN
        IF hex.SelCount>0 THEN
          datatype:=10000+hex.SelCount
        ELSE
          datatype:=10000+Length(value_viewer.Cells[1,value_viewer.Row]);
      END;
      objectname:='';
      value:=GetValue(datatype,offset);
      Form12.MakeVarInput(objectname,offset,datatype,value,Self);
    END;
  END;

PROCEDURE TForm8.FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
  BEGIN
    IF (Shift=[ssCtrl]) AND (Key=83) THEN
      IF hex.Modified THEN
        IF NOT Save THEN
          Exit;
  END;


END.
