/*
 AE/Mod Installer
 v1.0
 by Gumby and Iritscen
*/

#define DEBUG

#include <string>
#include <iostream>
#include <cctype>
#include <vector>
#include <fstream>
#include <errno.h>
#include "boost/filesystem.hpp" // includes all needed Boost.Filesystem declarations
#include "methods.h"

#ifdef WIN32
	#include <windows.h>
#else // assume we're on Mac
	#include <stdlib.h>
	#include <dirent.h>
#endif

#ifdef WIN32
	const string strOniSplit = "Onisplit.exe";
	const string strImportOption = "-import:nosep";
	const char* strClsCmd = "cls";
	const char* strPauseCmd = "PAUSE";
#else // set up Mac equivalents since we're in Mac OS
	const string strOniSplit = "mono Onisplit.exe";
	const string strImportOption = "-import:sep";
	const char* strClsCmd = "clear";
	const char* strPauseCmd = "read -n 1 -p \"Press any key to continue\"";
#endif

using namespace boost::filesystem; 
using namespace std;

const string strInstallerVersion = "1.0";
const bool SPLIT = 1;
const bool NOT_SPLIT = 0;
bool splitInstances = SPLIT;

int main(void)
{
	//	SetConsoleTitle("AE Installer"); windows junk, convert to SDL
	//	system("color 0A"); 
	
	cout << "\nWelcome to the AE installer!\n";
	cout << "\nWhat would you like to do?\n";
	
	return mainMenu();
}

int mainMenu(void)
{
	char choice = '0';
	bool exit = false;
	int err = 0;
	
	do
	{
		cout << "\n1. Globalize data\n";
		cout << "2. Install new packages\n";
		cout << "3. Uninstall packages\n";
		cout << "4. See what is installed\n";
		cout << "5. About AE\n";
		cout << "6. Quit\n\n";
		
		choice = cin.get();
		cin.ignore(128, '\n');
		switch(choice)
		{
			case '1':
				err = globalizeData();
				break;
			case '2':
				err = installPackages();
				break;
			case '3':
				err = uninstallPackages();
				break;
			case '4':
				err = listInstalledPackages();
				break;
			case '5':
				err = printInstallerInfo();
				break;
			case '6':
				exit = true;
				break;
			default:
				cout << "Please choose one of the above numbers, and press Enter.\n\n";
		}
		if (err) // if something fatal happened
			exit = true;
	} while(!exit);
	
	return err;
}

int globalizeData(void)
{
	int err = 0;
	
	try {
	int levels[15] = {0, 1, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13, 14, 18, 19}; // the levels Oni has
	char choice = 0;

	//SetCurrentDirectory("C:/Program Files/Oni/edition/install");
	char levelnum[3];
	path Characters = "../GameDataFolder/level0_Characters";
	path Particles = "../GameDataFolder/level0_Particles";
	path Archive = "../GameDataFolder/Archive";
	path Textures  = "../GameDataFolder/level0_Textures";
	path Sounds = "../GameDataFolder/level0_Sounds";
	path Animations = "../GameDataFolder/level0_Animations";
	path TRAC = Animations / "level0_TRAC";
	path TRAM = Animations / "level0_TRAM";
	
	if (exists("../GameDataFolder/"))
	{
		cout << "\nIt looks like you've already globalized Oni's data.\nDo you want to re-globalize?\n(This will erase existing mods installed to the AE's game data.)"
			 << "\n1. Re-globalize"
			 << "\n2. Return to main menu\n";
		choice = cin.get();
		cin.ignore(128, '\n');
		if (choice == '1')
			remove_all("../GameDataFolder"); // remove AE GDF
		if (choice == '2')
			return 0;
	}

	create_directory( "../GameDataFolder/" );
	create_directory( "packages" );
	if (exists("packages/VanillaDats")) remove_all("packages/VanillaDats");
	create_directory( "packages/VanillaDats" );
	
	create_directory( "packages/VanillaDats/level0_Final/" );
	create_directory( Characters );
	create_directory( Particles );
	create_directory( Archive );
	create_directory( Textures );
	create_directory( Sounds );
	create_directory( Animations );
	create_directory( TRAC );
	create_directory( TRAM );
	
	for(int i = 0; i < 15; i++)
	{
		sprintf(levelnum,"%d",levels[i]); // int to char array
		exists("../../GameDataFolder/level" + (string)levelnum + "_Final");
		system((strOniSplit + " -export ../GameDataFolder/level" + (string)levelnum + "_Final ../../GameDataFolder/level" + (string)levelnum + "_Final.dat").c_str());
		
		create_directory( "packages/VanillaDats/level" + (string)levelnum + "_Final" ); //remember to cast your arrays as strings :)
		create_directory( "packages/VanillaDats/level" + (string)levelnum + "_Final/level" + (string)levelnum + "_Final" );
		
		directory_iterator end_iter;
		for ( directory_iterator dir_itr( "../GameDataFolder/level" + (string)levelnum + "_Final" ); dir_itr != end_iter; ++dir_itr )
		{
			//cout << dir_itr->path().filename();
			if ( is_regular_file( dir_itr->status() ) )
			{
				
				if ( dir_itr->path().filename().substr(0,8) == "TXMPfail" || 
					dir_itr->path().filename().substr(0,9) == "TXMPlevel" ||
					( dir_itr->path().filename().substr(0,4) == "TXMP" && dir_itr->path().filename().find("intro")!=string::npos) ||
					dir_itr->path().filename().substr(0,4) == "TXMB" || 
					dir_itr->path().filename() == "M3GMpowerup_lsi.oni" ||
					dir_itr->path().filename() == "TXMPlsi_icon.oni" ||
					( dir_itr->path().filename().substr(0,4) == "TXMB" && dir_itr->path().filename().find("splash_screen.oni")!=string::npos)	)
				{
					cout <<dir_itr->path().filename() << "\n";
					create_directory( dir_itr->path().parent_path() / "NoGlobal");	
					if(!exists( dir_itr->path().parent_path() / "NoGlobal" / dir_itr->filename())) rename(dir_itr->path(), dir_itr->path().parent_path() / "NoGlobal" /
																										  dir_itr->filename());
					else remove(dir_itr->path());
				}
				else if (dir_itr->path().filename().substr(0,4) == "TRAC") {
					cout <<dir_itr->path().filename() << "\n";
					if(!exists( TRAC / dir_itr->filename())) rename(dir_itr->path(), TRAC / dir_itr->filename());
					else remove(dir_itr->path());
				}
				else if (dir_itr->path().filename().substr(0,4) == "TRAM") {
					cout <<dir_itr->path().filename() << "\n";
					if(!exists( TRAM / dir_itr->filename())) rename(dir_itr->path(), TRAM / dir_itr->filename());
					else remove(dir_itr->path());
				}
				else if (dir_itr->path().filename().substr(0,4) == "ONSK" ||
						 dir_itr->path().filename().substr(0,4) == "TXMP") {
					cout <<dir_itr->path().filename() << "\n";\
					create_directory( dir_itr->path().parent_path() / "TexFix");	
					if(!exists( Textures / dir_itr->filename())) rename(dir_itr->path(), Textures / dir_itr->filename());
					//rename(dir_itr->path(), dir_itr->path().parent_path() / "TexFix" / dir_itr->filename());
				}
				else if (dir_itr->path().filename().substr(0,4) == "ONCC" 
						 || dir_itr->path().filename().substr(0,4) == "TRBS"
						 || dir_itr->path().filename().substr(0,4) == "TRMA"
						 || dir_itr->path().filename().substr(0,4) == "TRSC"
						 || dir_itr->path().filename().substr(0,4) == "TRAS") {
					cout <<dir_itr->path().filename() << "\n";
					if(!exists( Characters / dir_itr->filename())) rename(dir_itr->path(), Characters / dir_itr->filename());
					else remove(dir_itr->path());
				}
				else if (dir_itr->path().filename().substr(0,4) == "OSBD"
						 || dir_itr->path().filename().substr(0,4) == "SNDD") {
					cout << dir_itr->path().filename() << "\n";
					if(!exists( Sounds / dir_itr->filename())) rename(dir_itr->path(), Sounds / dir_itr->filename());
					else remove(dir_itr->path());
				}
				else if (dir_itr->path().filename().substr(0,5) == "BINA3"
						 || dir_itr->path().filename().substr(0,10) == "M3GMdebris"
						 || dir_itr->path().filename() == "M3GMtoxic_bubble.oni"
						 || dir_itr->path().filename().substr(0,8) == "M3GMelec"
						 || dir_itr->path().filename().substr(0,7) == "M3GMrat"
						 || dir_itr->path().filename().substr(0,7) == "M3GMjet"
						 || dir_itr->path().filename().substr(0,9) == "M3GMbomb_"
						 || dir_itr->path().filename() == "M3GMbarab_swave.oni"
						 || dir_itr->path().filename() == "M3GMbloodyfoot.oni"
						 ){
					cout <<dir_itr->path().filename() << "\n";
					if(!exists( Particles / dir_itr->filename())) rename(dir_itr->path(), Particles / dir_itr->filename());
					else remove(dir_itr->path());
				}
				else if (dir_itr->path().filename().substr(0,4) == "AGDB"
						 || dir_itr->path().filename().substr(0,4) == "TRCM") {
					cout <<dir_itr->path().filename() << "\n";
					
					if(!exists( Archive / dir_itr->filename())) rename(dir_itr->path(), Archive / dir_itr->filename());
					else remove(dir_itr->path());
				}
			}
			
			
		}
		system( (strOniSplit + " -move:delete " + Textures.string() + " ../GameDataFolder/level" + (string)levelnum + "_Final/TXMP*.oni").c_str());
		
	}
	
	for (int i = 0; i < 15; i++)
	{
		sprintf(levelnum,"%d",levels[i]);
		system( (strOniSplit + " " + strImportOption + " ../GameDataFolder/level" + levelnum + "_Final packages/VanillaDats/level" + levelnum + "_Final/level"
				 + levelnum + "_Final/level" + levelnum + "_Final.oni").c_str());
	}
	path VanillaCharacters = "packages/VanillaDats/level0_Final/level0_Characters/level0_Characters.oni";
	path VanillaParticles = "packages/VanillaDats/level0_Final/level0_Particles/level0_Particles.oni";
	path VanillaTextures  = "packages/VanillaDats/level0_Final/level0_Textures/level0_Textures.oni";
	path VanillaSounds = "packages/VanillaDats/level0_Final/level0_Sounds/level0_Sounds.oni";
	path VanillaAnimations = "packages/VanillaDats/level0_Final/level0_Animations/level0_Animations.oni";
	path VanillaTRAC = "packages/VanillaDats/level0_Final/level0_Animations/level0_TRAC.oni";
	path VanillaTRAM = "packages/VanillaDats/level0_Final/level0_Animations/level0_TRAM.oni";
	create_directory( VanillaCharacters.parent_path() );
	create_directory( VanillaParticles.parent_path() );
	create_directory( VanillaTextures.parent_path() );
	create_directory( VanillaSounds.parent_path() );
	create_directory( VanillaAnimations.remove_filename() );
	system((strOniSplit + " " + strImportOption + " " + Characters.string() + " " + VanillaCharacters.string()).c_str());
	system((strOniSplit + " " + strImportOption + " " + Particles.string() + " " + VanillaParticles.string()).c_str());
	system((strOniSplit + " " + strImportOption + " " + Textures.string() + " " + VanillaTextures.string()).c_str());
	//system((strOniSplit	+ " " + strImportOption + (string)" " + Animations.string() + (string)" " + VanillaAnimations.string()).c_str());
	system((strOniSplit + " " + strImportOption + " " + TRAC.string() + " " + VanillaTRAC.string()).c_str());
	system((strOniSplit + " " + strImportOption + " " + Sounds.string() + " " + VanillaSounds.string()).c_str());
	system((strOniSplit + " " + strImportOption + " " + TRAM.string() + " " + VanillaTRAM.string()).c_str());
	
	create_directory("../GameDataFolder/IGMD");
	copy((path)"packages/VanillaBSL/IGMD", (path)"../GameDataFolder");
	}
	catch (exception ex) {
		cout << ex.what();
	}
	return err;
}

int installPackages(void)
{
	int err = 0;
	ModPackage package;
	vector<string> installed_packages;
	vector<ModPackage> packages; 
	vector<ModPackage>::iterator iter;
	vector<string> installString;
	
	iter = packages.begin();
	packages = getPackages();
	vector<string> installedMods = getInstallString();
	
	if (packages.empty())
	{
		cout << "Error: You have no packages!\n";
		return 0;
	}
	
	cout << "Detecting installed packages...\n";
	
	int index = 1;
	char choice = '0';
	
	for (vector<ModPackage>::iterator package_iter = packages.begin(); package_iter != packages.end(); ++package_iter)
	{
		if (!binary_search(installedMods.begin(), installedMods.end(), package_iter->modStringName))
		{ //package_iter->isInstalled :< I forgot about this...
			//cout << index << " ";
			system(strClsCmd);
			cout << (*package_iter).name << "\n";
			for (int character = 1; character <= (*package_iter).name.length() - 1; character++) cout << char(196); //does extended ASCII work in UNIX? 
			cout << "\n"
				 << (*package_iter).readme << "\n\n"
				 << "Please enter a number choice\n"
				 << " 1. Install\n"
				 << " 2. Don't Install\n"
				 << "";
			index++;
			choice = 0;
			
			do
			{
				choice = cin.get();
				cin.ignore(1280, '\n');
			} while(choice == 0);
			
			if (choice == '1')
			{
				cout << "\nInstalling...\n\n";
				if (package_iter->hasOnis || (package_iter->hasDeltas /*(*package_iter).isUnpacked */ ))
				{
					installedMods.push_back(package_iter->modStringName);
					system(strPauseCmd);
				}
			}
		}
	}
	if (index == 1)
	{
		cout << "Error: All packages are already installed\n";
		return 0;
	}
	
	sort(installedMods.begin(), installedMods.end());
	//system(Onisplit.c_str());
	recompileAll(installedMods);
	system(strPauseCmd);
	
	return err;
}

int uninstallPackages(void)
{
	cout << "\nThis feature not yet implemented.\n\n";
	
	return 0;
}

int listInstalledPackages(void)
{
	cout << "\nThis feature not yet implemented.\n\n";
	
	return 0;
}

int printInstallerInfo(void)
{
	cout << "\nAE/Mod Installer\n";
	cout << "version " << strInstallerVersion << "\n";
	cout << "by Gumby & Iritscen\n";
	cout << "see http://oni.bungie.org/community/forums for more info\n\n";
	
	return 0;
}

vector<ModPackage> getPackages(void)
{
	vector<ModPackage> packages;
	packages.reserve(65536); // come on, we shouldn't need this much space...right?!
	fstream file;
	string filename = "\0";
	string MODINFO_CFG = "Mod_Info.cfg";
	
	try
	{
		directory_iterator end_iter;
		for (directory_iterator dir_itr("./packages"); dir_itr != end_iter; ++dir_itr)
		{
			file.open((dir_itr->path().string() + "/" + MODINFO_CFG).c_str());
			//cout << filename << "\n";
			
			if(!file.fail())
			{
				cout << dir_itr->path().string() + MODINFO_CFG;
				//would prefer to push a pointer to a package, but this will do for now
				packages.push_back(fileToModPackage(file));
			}	
			file.close();
			file.clear();
		}
	}
	catch (const std::exception & ex)
	{
		cout << "Warning, something odd happened!\n";
	}
	
	return packages;
}

ModPackage fileToModPackage(fstream &file)
{
	/*
	 This converts a file to a ModPackage struct.
	 
	 A few notes...
	 "iter" is the current word we are on. I should have named it "token" or something, but I don't have multiple iterators, so its ok.
	 I refer to (*iter) at the beginning of each if statement block. I could probably store it as a variable, but I'm pretty sure that dereferencing a pointer\iterator isn't much
	 slower than reading a variable.
	 */
	ModPackage package;
	string line;
	static string NameOfMod = "NameOfMod";	//used for comparing to the current token...
	//I could have done it in reverse (*iter).compare("ModString") or  
	static string ARROW = "->";				//did something like "ModString".compare(*iter), and it would have been
	static string ModString = "ModString";	//functionably the same. 
	static string HasOnis = "HasOnis";
	static string HasDeltas = "HasDeltas";
	static string HasBSL = "HasBSL";
	static string HasDats = "HasDats";
	static string IsEngine = "IsEngine";
	static string Readme = "Readme";
	static string GlobalNeeded = "GlobalNeeded";
	static string Category = "Category";
	static string Creator = "Creator";
	while (! file.eof() )
	{
		getline (file,line);
		vector<string> tokens; 
		vector<string>::iterator iter;
		tokenize(line, tokens);					//string to vector of "words"
		if (tokens.capacity() >= 2) {			//make sure they are using enough stuff
			iter = tokens.begin();				//what word we are on, starts at first word
			/*
			 if (!AEInstallVersion.compare(*iter))
			 If mod is too old, skip this mod.
			 */
			/*else*/if (!NameOfMod.compare(*iter))  {	//if it contains the name
				for ( ; iter !=tokens.end() && SLASHSLASH.compare(*iter); iter++) {	//interates through the words, ends if it reaches the end of the line or a "//" comment
					if (ARROW.compare(*iter) && NameOfMod.compare(*iter)) {			//ignores "->" and "NameOfMod"
						//cout << *iter; 
						//cout << " ";
						package.name += *iter + " ";
					}
				}
				
			}
			else if (!ModString.compare(*iter)) {
				iter++; iter++;
				package.modStringName = *iter;
				iter++;
				package.modStringVersion = atoi((*iter).c_str());
			}
			else if (!HasOnis.compare(*iter)) {
				iter++; iter++;  
				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.hasOnis = 1; //Gotta love c++'s lack of a standard case-insensitive
				else if (!HasBSL.compare(*iter)) { // string comparer...I know my implementation here sucks. I need to change it to check each character one by one. At the moment,
				iter++; iter++;}  // using "YFR" would probably set it off. :<

				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.hasBSL = 1;
			}
			else if (!HasDeltas.compare(*iter)) {
				iter++; iter++;  
				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.hasDeltas = 1;
			}
			else if (!HasDats.compare(*iter)) {
				iter++; iter++;  
				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.hasDats = 1;
			}
			else if (!IsEngine.compare(*iter)) {
				iter++; iter++;  
				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.isEngine = 1;
			}
			else if (!GlobalNeeded.compare(*iter)) {
				iter++; iter++;  
				if (toupper((*iter)[0]) + toupper((*iter)[1]) + toupper((*iter)[2]) == 'Y' + 'E' + 'S') package.globalNeeded = 1;
				else if (toupper((*iter)[0]) + toupper((*iter)[1]) == 'N' + 'O') package.globalNeeded = 1; //Really the only place where checking for "No" is important atm.
			}
			else if (!Category.compare(*iter))  {	
				for ( ; iter !=tokens.end() && SLASHSLASH.compare(*iter); iter++) {	//interates through the words, ends if it reaches the end of the line or a "//" comment
					if (ARROW.compare(*iter) && Category.compare(*iter)) {			//ignores "->" and "Category"
						//cout << *iter; 
						//cout << " ";
						package.category += *iter + " ";
					}
				}
			}
			else if (!Creator.compare(*iter))  {	//if it contains the name
				for ( ; iter !=tokens.end() && SLASHSLASH.compare(*iter); iter++) {	//interates through the words, ends if it reaches the end of the line or a "//" comment
					if (ARROW.compare(*iter) && Creator.compare(*iter)) {			//ignores "->" and "Category"
						//cout << *iter; 
						//cout << " ";
						package.creator += *iter + " ";
					}
				}
			}
			else if (!Readme.compare(*iter))  {	//if it contains the name
				for ( ; iter !=tokens.end() && SLASHSLASH.compare(*iter); iter++) {	//interates through the words, ends if it reaches the end of the line or a "//" comment
					if (ARROW.compare(*iter) && Readme.compare(*iter)) {			//ignores "->" and "Category"
						//cout << *iter; 
						//cout << " ";
						package.readme += *iter + " ";
					}
				}
			}
		}
		
	}
	package.doOutput();
	return package;
}

void recompileAll(vector<string> installedMods)
{
	cout << "Recompiling Data...\n";
	path vanilla_dir = "./packages/VanillaDats/";
	string importCommand = "";
	if(splitInstances == SPLIT){
		recursive_directory_iterator end_iter;
		try {
			for ( recursive_directory_iterator dir_itr( vanilla_dir );
				 dir_itr != end_iter;
				 ++dir_itr )
			{
				try
				{
					if ( is_directory( dir_itr->status() ) &&  dir_itr.level() == 1)
					{
						importCommand = strOniSplit + " " + strImportOption + " " + dir_itr->path().parent_path().string() + '/' + dir_itr->path().filename();
						for (int i = 0; i < installedMods.size(); ++i) {
							if (exists("packages/" + installedMods[i] + "/oni/" + dir_itr->path().parent_path().filename() + '/' + dir_itr->path().filename()  ))
								importCommand += " packages/" + installedMods[i] + "/oni/" + dir_itr->path().parent_path().filename() + '/' + dir_itr->path().filename();
							
							//else cout << " packages/VanillaDats/" + installedMods[i] + "/oni/";
						}
						importCommand += " ../GameDataFolder/" + dir_itr->path().filename() + ".dat";
						system(importCommand.c_str());
						//cout << importCommand << "\n";
					}
				}
				catch ( const std::exception & ex )
				{
					cout << "Warning, exception " << ex.what() << "!";
				}
			}
		}
		catch( const std::exception & ex ) {
			cout << "Warning, exception " << ex.what() << "!\n"
			<< "You probably need to re-globalize.";
			create_directory( "./packages/VanillaDats" );
		}
		
	}
	else if(splitInstances == NOT_SPLIT){
		directory_iterator end_iter;
		for ( directory_iterator dir_itr( vanilla_dir );
			 dir_itr != end_iter;
			 ++dir_itr )
		{
			try
			{
				if ( is_directory( dir_itr->status() ) )
				{
					system((strOniSplit + " " + strImportOption + " " + vanilla_dir.string() + dir_itr->path().filename() + " " + "../GameDataFolder/" + dir_itr->path().filename()
							+ ".dat").c_str());
				}
			}
			catch ( const std::exception & ex )
			{
				cout << "Warning, something odd happened!\n";
			}
		}
	}
}

vector<string> getInstallString(void)
{
	system(strPauseCmd);
	vector<string> returnval;
	string file_name = "../GameDataFolder/ImportList.cfg";
	string line;
	fstream file;
	
	if (exists(file_name))
	{
		file.open(file_name.c_str());
		getline(file, line);
		tokenize(line, returnval);
		file.close();
		file.clear();
		sort(returnval.begin(), returnval.end());
	}
	else cout << "fail";
	
	return returnval;
}

//stolen token function...
void tokenize(const string& str, vector<string>& tokens, const string& delimiters)
{
	// Skip delimiters at beginning.
	string::size_type lastPos = str.find_first_not_of(delimiters, 0);
	// Find first "non-delimiter".
	string::size_type pos     = str.find_first_of(delimiters, lastPos);
	
	while (string::npos != pos || string::npos != lastPos)
	{
		// Found a token, add it to the vector.
		tokens.push_back(str.substr(lastPos, pos - lastPos));
		// Skip delimiters.  Note the "not_of"
		lastPos = str.find_first_not_of(delimiters, pos);
		// Find next "non-delimiter"
		pos = str.find_first_of(delimiters, lastPos);
	}
}