

/////////////////////////////////////////////////////////////////////////////
// Name:        main_window.h
// Purpose:     
// Author:      
// Modified by: 
// Created:     07/05/2009 20:38:25
// RCS-ID:      
// Copyright:   
// Licence:     
/////////////////////////////////////////////////////////////////////////////

#ifndef _MAINWINDOW_H_
#define _MAINWINDOW_H_


/*!
 * Includes
 */

////@begin includes
#include "wx/frame.h"
#include "wx/splitter.h"
#include "wx/statline.h"
#include "wx/statusbr.h"
////@end includes

/*!
 * Forward declarations
 */

////@begin forward declarations
class wxSplitterWindow;
class wxStatusBar;
////@end forward declarations

/*!
 * Control identifiers
 */

////@begin control identifiers
#define ID_MAINWINDOW 10000
#define ID_SPLITTERWINDOW 10001
#define ID_PANEL 10011
#define SelectAll_Checkbox 10012
#define Refresh_Button 10007
#define Mods_CheckboxList1 10002
#define DescriptionHolder_Panel 10003
#define Title_Text 10005
#define Author_Text 10004
#define Description_Text 10022
#define ID_STATUSBAR 10008
#define ProgressBar_Gauge 10009
#define Install_Button 10010
#define ID_PANEL1 10019
#define Sep_RadioButton 10013
#define NoSep_RadioButton 10014
#define Separated_RadioButton 10015
#define Complete_RadioButton 10016
#define ReGlobalize_Button 10018
#define wxID_LOAD 10006
#define wxID_OPTIONS 10017
#define SYMBOL_MAINWINDOW_STYLE wxCAPTION|wxRESIZE_BORDER|wxSYSTEM_MENU|wxMINIMIZE_BOX|wxMAXIMIZE_BOX|wxCLOSE_BOX
#define SYMBOL_MAINWINDOW_TITLE _("Installer")
#define SYMBOL_MAINWINDOW_IDNAME ID_MAINWINDOW
#define SYMBOL_MAINWINDOW_SIZE wxSize(400, 500)
#define SYMBOL_MAINWINDOW_POSITION wxDefaultPosition
////@end control identifiers


/*!
 * MainWindow class declaration
 */

using namespace std;

#include <vector>

class MainWindow: public wxFrame
{    
    DECLARE_CLASS( MainWindow )
    DECLARE_EVENT_TABLE()

public:
    /// Constructors
    MainWindow();
    MainWindow( wxWindow* parent, wxWindowID id = SYMBOL_MAINWINDOW_IDNAME, const wxString& caption = SYMBOL_MAINWINDOW_TITLE, const wxPoint& pos = SYMBOL_MAINWINDOW_POSITION, const wxSize& size = SYMBOL_MAINWINDOW_SIZE, long style = SYMBOL_MAINWINDOW_STYLE );

    bool Create( wxWindow* parent, wxWindowID id = SYMBOL_MAINWINDOW_IDNAME, const wxString& caption = SYMBOL_MAINWINDOW_TITLE, const wxPoint& pos = SYMBOL_MAINWINDOW_POSITION, const wxSize& size = SYMBOL_MAINWINDOW_SIZE, long style = SYMBOL_MAINWINDOW_STYLE );

    /// Destructor
    ~MainWindow();

    /// Initialises member variables
    void Init();

    /// Creates the controls and sizers
    void CreateControls();

////@begin MainWindow event handler declarations

    /// wxEVT_COMMAND_CHECKBOX_CLICKED event handler for SelectAll_Checkbox
    void OnSelectAllCheckboxClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for Refresh_Button
    void OnRefreshButtonClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_LISTBOX_SELECTED event handler for Mods_CheckboxList1
    void OnModsCheckboxList1Selected( wxCommandEvent& event );

    /// wxEVT_COMMAND_CHECKLISTBOX_TOGGLED event handler for Mods_CheckboxList1
    void OnModsCheckboxList1Toggled( wxCommandEvent& event );

    /// wxEVT_CREATE event handler for Mods_CheckboxList1
    void ModList_OnCreate( wxWindowCreateEvent& event );

    /// wxEVT_UPDATE_UI event handler for ID_STATUSBAR
    void OnStatusbarUpdate( wxUpdateUIEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for Install_Button
    void OnInstallButtonClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Sep_RadioButton
    void OnSepRadioButtonSelected( wxCommandEvent& event );

    /// wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for NoSep_RadioButton
    void OnNoSepRadioButtonSelected( wxCommandEvent& event );

    /// wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Separated_RadioButton
    void OnSeparatedRadioButtonSelected( wxCommandEvent& event );

    /// wxEVT_COMMAND_RADIOBUTTON_SELECTED event handler for Complete_RadioButton
    void OnCompleteRadioButtonSelected( wxCommandEvent& event );

    /// wxEVT_COMMAND_BUTTON_CLICKED event handler for ReGlobalize_Button
    void OnReGlobalizeButtonClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for wxID_LOAD
    void OnLoadClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for wxID_SAVE
    void OnSaveClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for wxID_EXIT
    void OnExitClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for wxID_OPTIONS
    void OnOptionsClick( wxCommandEvent& event );

    /// wxEVT_COMMAND_MENU_SELECTED event handler for wxID_ABOUT
    void OnAboutClick( wxCommandEvent& event );

////@end MainWindow event handler declarations

////@begin MainWindow member function declarations

    /// Retrieves bitmap resources
    wxBitmap GetBitmapResource( const wxString& name );

    /// Retrieves icon resources
    wxIcon GetIconResource( const wxString& name );
////@end MainWindow member function declarations

    /// Should we show tooltips?
    static bool ShowToolTips();

////@begin MainWindow member variables
    wxSplitterWindow* MainSplitter;
    wxCheckBox* SelectAll;
    wxBitmapButton* RefreshButton;
    wxCheckListBox* Mods_CheckboxList;
    wxTextCtrl* titleText;
    wxTextCtrl* creatorText;
    wxTextCtrl* descriptionText;
    wxStatusBar* StatusArea;
    wxGauge* ProgressBar;
    wxButton* InstallButton;
    wxPanel* OptionsPanel;
    wxRadioButton* SepRadio;
    wxRadioButton* NoSepRadio;
    wxRadioButton* SeparatedRadio;
    wxRadioButton* CompleteRadio;
    wxButton* ReglobalizeButton;
////@end MainWindow member variables

	void refreshMods( vector<string> );
};

#endif
    // _MAINWINDOW_H_
