unit Unit14_settings;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils;

type
  TForm14 = class(TForm)
    check_filesashex: TCheckBox;
    btn_ok: TButton;
    btn_cancel: TButton;
    btn_register_oldb: TButton;
    btn_register_opf: TButton;
    btn_register_dat: TButton;
    procedure btn_register_opfClick(Sender: TObject);
    procedure btn_register_oldbClick(Sender: TObject);
    procedure btn_register_datClick(Sender: TObject);
    procedure btn_cancelClick(Sender: TObject);
    procedure btn_okClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
    function RegisterExtension(ext:String):Integer;
  private
  public
  end;

var
  Form14: TForm14;

implementation
{$R *.dfm}
uses
  Unit1_main, Unit3_data, ftypesAPI;

function ExtensionRegistered(ext:String; var RegisteredAs:String):Boolean;
  var
    ftr:TFileTypeRegistration;
  begin
    ftr:=TFileTypeRegistration.Create;
    if(ftr <> nil) then begin
      try
        RegisteredAs:=ftr.GetInternalKey(ext);
        if RegisteredAs<>'' then
          Result:=True
        else
          Result:=False;
      finally
        ftr.Free;
      end;
    end;
  end;

function TForm14.RegisterExtension(ext:String):Integer;
  var
    ftr:TFileTypeRegistration;
    temps:String;
    warnmsg:String;
  begin
    Result:=-1;
    if ExtensionRegistered(ext,temps) then begin
      if temps<>'ONI'+ext then begin
        warnmsg:=ext+'-files are not registered to OUP but as "'+temps+'"-files.'+#13+#10+
                 'Do you really want to unregister'+ext+'-files?';
        if MessageBox(Self.Handle, PChar(warnmsg),PChar('Warning'),MB_YESNO)=ID_NO then
          Exit;
      end;
      ftr:=TFileTypeRegistration.Create;
      if ftr<>nil then
        try
          if not ftr.UnregisterExtension(ext) then
            ShowMessage('Could not unregister '+ext+'-files')
          else
            Result:=2;
        finally
          ftr.Free;
        end;
    end else begin
      ftr:=TFileTypeRegistration.Create;
      if ftr<>nil then begin
        try
          if ftr.RegisterType(ext,'ONI'+ext,'ONI '+ext+'-file',Application.EXEname+',1') then begin
            ftr.AddHandler('open','"'+Application.EXEname+'" '+MidStr(ext,2,Length(ext)-1)+' "%1"');
            ftr.SetDefaultHandler;
            Result:=1;
          end;
        finally
          ftr.Free;
        end;
      end;
    end;
  end;

procedure TForm14.btn_cancelClick(Sender: TObject);
  begin
    Self.Close;
  end;

procedure TForm14.btn_okClick(Sender: TObject);
  begin
    AppSettings.FilenumbersAsHex:=check_filesashex.Checked;
    Self.Close;
  end;

procedure TForm14.btn_register_datClick(Sender: TObject);
  begin
    case RegisterExtension('.dat') of
      2: btn_register_dat.Caption:='Register .dat files with OUP';
      1: btn_register_dat.Caption:='Unregister .dat files';
    end;
  end;

procedure TForm14.btn_register_oldbClick(Sender: TObject);
  begin
    case RegisterExtension('.oldb') of
      2: btn_register_oldb.Caption:='Register .oldb files with OUP';
      1: btn_register_oldb.Caption:='Unregister .oldb files';
    end;
  end;

procedure TForm14.btn_register_opfClick(Sender: TObject);
  begin
    case RegisterExtension('.opf') of
      2: btn_register_opf.Caption:='Register .opf files with OUP';
      1: btn_register_opf.Caption:='Unregister .opf files';
    end;
  end;

procedure TForm14.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  begin
    CanClose:=False;
    Self.Visible:=False;
    Form1.Enabled:=True;
    Form1.SetFocus;
  end;

procedure TForm14.FormShow(Sender: TObject);
  var
    temps:String;
  begin
    if ExtensionRegistered('.dat',temps) then
      btn_register_dat.Caption:='Unregister .dat files'
    else
      btn_register_dat.Caption:='Register .dat files with OUP';
    if ExtensionRegistered('.oldb',temps) then
      btn_register_oldb.Caption:='Unregister .oldb files'
    else
      btn_register_oldb.Caption:='Register .oldb files with OUP';
    if ExtensionRegistered('.opf',temps) then
      btn_register_opf.Caption:='Unregister .opf files'
    else
      btn_register_opf.Caption:='Register .opf files with OUP';
    check_filesashex.Checked:=AppSettings.FilenumbersAsHex;
  end;

end.
