#include "Daodan.h"
#include "Daodan_Patch.h"
#include "Daodan_Utility.h"
#include "Daodan_Win32.h"
#include "Daodan_Cheater.h"
#include "Daodan_Persistence.h"

#include "Oni.h"
#include "Oni_Persistence.h"

#include "BFW_Utility.h"

#include "oni_gl.h"
#include "daodan_gl.h"

HMODULE DDrDLLModule;
HMODULE DDrONiModule;

bool DDrPatch_Init()
{
	// Font texture cache doubled
	DDrPatch_Byte  (OniExe + 0x00020ea7, 0x20);
	DDrPatch_Byte  (OniExe + 0x00020f4a, 0x40);
	
	// Now supports textures up to 512x512
	DDrPatch_Byte  (OniExe + 0x00005251, 0x10);
	
	// Non-"_Final" levels are now valid
	DDrPatch_Byte  (OniExe + 0x000206a8, 0x01);
	
	// Pathfinding grid cache size x8
	DDrPatch_Byte  (OniExe + 0x0010b03b, 0x20);
	DDrPatch_Byte  (OniExe + 0x0010b04c, 0x20);
	
	// Projectile awareness fixed
	DDrPatch_Byte  (OniExe + 0x0009c07c, 0x6c);
	DDrPatch_Byte  (OniExe + 0x0009c080, 0x70);
	DDrPatch_Byte  (OniExe + 0x0009c084, 0x74);
	DDrPatch_Byte  (OniExe + 0x0009c110, 0x6c);
	
	// Forced DirectInput (for Windows NT)
	DDrPatch_Byte  (OniExe + 0x00002e6d, 0xeb);
	
	// Makes wp_fadetime actually have a function
	const char fadetime_patch[] = { 0x66, 0x8B, 0x1D, 0xC4, 0x7D, 0x62, 0x00, 0x66, 0x89, 0x5E, 0x46, 0x5B, 0x5E, 0x83, 0xC4, 0x14, 0xC3 };
	DDrPatch_Const (OniExe + 0x0011a889, fadetime_patch);
	DDrPatch_Byte  (OniExe + 0x0011a560, 0x31);
	
	// Sets the fadetime to 4800 by default
	DDrPatch_Int16 (OniExe + 0x0011ab0e, 0x12c0);
	
	
	// Hackish fix for Konoko not kicking guns
//	const char kickgun_patch[] = { 0x00, 0x05, 0x00, 0x00, 0x00, 0xC7, 0x05, 0x1C, 0xC9, 0x5E, 0x00, 0x70, 0xB8, 0x43, 0x00, 0xC7, 0x05, 0x20, 0xC9, 0x5E, 0x00, 0x20, 0xBE, 0x43 };
//	DDrPatch_Const (OniExe + 0x000dc420, kickgun_patch);
	
	// Cooldown timer exploit fix ^_^
	const char cooldown_patch[] = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 };
	DDrPatch_Const (OniExe + 0x0011a825, cooldown_patch);
	
//	const char throwtest_patch[] = { 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 };
//	DDrPatch_Const(OniExe + 0x000dc190, throwtest_patch);
	
	// Disable UUrPlatform_Initalize/Terminate, this enables the Alt-Tab and the Windows key but has the possible side effect of allowing the screensaver to enable itself in-game.
	DDrPatch_Byte  ((void*)UUrPlatform_Initialize, 0xC3);
	DDrPatch_Byte  ((void*)UUrPlatform_Terminate, 0xC3);
	
	// Unlocks particle action disabling/enabling bits for all events. (Will be controlled by a command line switch when I figure out how to do that without Win32 hacks.)
	//DDrPatch_Int16 (OniExe + 0x001b184, 0x9090);
	
	// Multi-byte patch (multiple language support)
	DDrPatch_Byte  (OniExe + 0x0002d8f8, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002d9ad, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002dbe2, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002dec3, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e2ab, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e2c4, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e379, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e48c, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e4d0, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e4f4, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e646, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e695, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e944, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e95d, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e98e, 0xeb);
	DDrPatch_Byte  (OniExe + 0x0002e9dc, 0xeb);
	
	// Cheat table patch
	DDrPatch_Int32 (OniExe + 0x000f616b, (int)&DDr_CheatTable[0].name);
	DDrPatch_Int32 (OniExe + 0x000f617a, (int)&DDr_CheatTable[0].message_on);
	
	return true;
}

void __cdecl DDrMain(int argc, char* argv[])
{
	DDrPatch_Init();
	
	// Safe startup message printer
	DDrPatch_MakeJump(UUrStartupMessage, DDrStartupMessage);
	
	// Daodan device mode enumeration function
	DDrPatch_MakeJump(gl_enumerate_valid_display_modes, daodan_enumerate_valid_display_modes);
	
	// Performance patch
	DDrPatch_MakeJump(UUrMachineTime_High, DDrMachineTime_High);
	DDrPatch_MakeJump(UUrMachineTime_High_Frequency, DDrMachineTime_High_Frequency);
	DDrPatch_MakeJump(UUrMachineTime_Sixtieths, DDrMachineTime_Sixtieths);
	
	// Cheats always enabled
	DDrPatch_MakeJump(ONrPersist_GetWonGame, DDrPersist_GetWonGame);
	
	// Windowed mode
//	DDrPatch_MakeJump(ONrPlatform_Initialize, DDrPlatform_Initialize);
//	DDrPatch_MakeJump(gl_platform_initialize, daodangl_platform_initialize);
	
//	init_daodan_gl();
	
	ONiMain(argc, argv);
}

BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpReserved)
{
	switch (fdwReason)
	{
		case DLL_PROCESS_ATTACH:
			DDrDLLModule = hinstDLL;
			DDrONiModule = GetModuleHandle(NULL);
			
			DDrPatch_MakeCall(OniExe + 0x0010fb49, DDrMain);
			
			break;
	}
	return TRUE;
}
