function GetAdminSid: PSID;
const
  // bekannte SIDs ... (WinNT.h)
  SECURITYNTAUTHORITY: TSIDIdentifierAuthority = (Value: (0, 0, 0, 0, 0, 5));
  // bekannte RIDs ... (WinNT.h)
  SECURITYBUILTINDOMAINRID: DWORD = $00000020;
  DOMAINALIASRIDADMINS: DWORD = $00000220;
begin
  Result := nil;
  AllocateAndInitializeSid(SECURITYNTAUTHORITY,
    2,
    SECURITYBUILTINDOMAINRID,
    DOMAINALIASRIDADMINS,
    0,
    0,
    0,
    0,
    0,
    0,
    Result);
end;

function IsAdmin: LongBool;
var
  TokenHandle      : THandle;
  ReturnLength     : DWORD;
  TokenInformation : PTokenGroups;
  AdminSid         : PSID;
  Loop             : Integer;
  wv               : TOSVersionInfo;
begin
  wv.dwOSVersionInfoSize := sizeof(TOSversionInfo);
  GetVersionEx(wv);

  Result := (wv.dwPlatformId = VER_PLATFORM_WIN32_WINDOWS);

  if(wv.dwPlatformId = VER_PLATFORM_WIN32_NT) then
    begin
      TokenHandle := 0;
      if OpenProcessToken(GetCurrentProcess, TOKEN_QUERY, TokenHandle) then
        try
          ReturnLength := 0;
          GetTokenInformation(TokenHandle, TokenGroups, nil, 0, ReturnLength);
          TokenInformation := GetMemory(ReturnLength);
          if Assigned(TokenInformation) then
            try
              if GetTokenInformation(TokenHandle, TokenGroups,
                TokenInformation, ReturnLength, ReturnLength) then
              begin
                AdminSid := GetAdminSid;
                for Loop := 0 to TokenInformation^.GroupCount - 1 do
                  begin
                    if EqualSid(TokenInformation^.Groups[Loop].Sid, AdminSid) then
                      begin
                        Result := True; break;
                      end;
                  end;
                FreeSid(AdminSid);
              end;
            finally
              FreeMemory(TokenInformation);
            end;
        finally
          CloseHandle(TokenHandle);
        end;
    end;
end;

function WVersion: string; 
var 
  OSInfo: TOSVersionInfo; 
begin 
  Result := '3X'; 
  OSInfo.dwOSVersionInfoSize := sizeof(TOSVERSIONINFO); 
  GetVersionEx(OSInfo); 
  case OSInfo.dwPlatformID of 
    VER_PLATFORM_WIN32S: begin 
        Result := '3X'; 
        Exit; 
      end; 
    VER_PLATFORM_WIN32_WINDOWS: begin 
        Result := '9X'; 
        Exit; 
      end; 
    VER_PLATFORM_WIN32_NT: begin 
        Result := 'NT'; 
        Exit; 
      end; 
  end; //case 
end;