UNIT Unit7_txmpreplace;
INTERFACE
USES
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, StrUtils, Unit2_functions, Unit3_data, Unit6_imgfuncs;

TYPE
  TForm7 = Class(TForm)
    panel_12: TPanel;
    group_txmpselect: TGroupBox;
    splitter_txmp: TSplitter;
    list_txmp: TListBox;
    Splitter1: TSplitter;
    group_bmpselect: TGroupBox;
    panel_load: TPanel;
    btn_load: TButton;
    image_bmppreview: TImage;
    opend: TOpenDialog;
    group_options: TGroupBox;
    btn_replace: TButton;
    check_transparency: TCheckBox;
    check_fading: TCheckBox;
    panel_txmppreview: TPanel;
    btn_save: TButton;
    image_txmppreview: TImage;
    saved: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    PROCEDURE btn_saveClick(Sender: TObject);
    PROCEDURE FormActivate(Sender: TObject);
    PROCEDURE FormClose(Sender: TObject; var Action: TCloseAction);
    PROCEDURE btn_replaceClick(Sender: TObject);
    PROCEDURE btn_loadClick(Sender: TObject);
    PROCEDURE list_txmpClick(Sender: TObject);
    PROCEDURE Recreatelist;
  PRIVATE
    OniImage_Old:TOniImage;
    OniImage_New:TOniImage;
  PUBLIC
  END;

VAR
  Form7: TForm7;

IMPLEMENTATION
USES Unit1_main, Unit15_Classes;
{$R *.dfm}

PROCEDURE TForm7.Recreatelist;
  VAR
    files:TStringArray;
    i:LongWord;
  BEGIN
    list_txmp.Items.Clear;
    files:=OniDataConnection.GetFilesList('TXMP','',True);
    IF Length(files)>0 THEN
      FOR i:=0 TO High(files) DO
        list_txmp.Items.Add(files[i]);
    group_bmpselect.Enabled:=False;
    check_transparency.Checked:=False;
    check_fading.Checked:=False;
  END;

  
PROCEDURE TForm7.list_txmpClick(Sender: TObject);
  VAR
    id:LongWord;
    data:Tdata;
    mem:TMemoryStream;
    fadingbyte,depthbyte,storebyte:Byte;
  BEGIN
    id:=OniDataConnection.ExtractFileID(list_txmp.Items.Strings[list_txmp.ItemIndex]);
    OniDataConnection.LoadDatFilePart(id,$88,SizeOf(fadingbyte),@fadingbyte);
    OniDataConnection.LoadDatFilePart(id,$89,SizeOf(depthbyte),@depthbyte);
    OniDataConnection.LoadDatFilePart(id,$90,SizeOf(storebyte),@storebyte);
    check_fading.Checked:=(fadingbyte AND $01)>0;
    check_transparency.Checked:=(depthbyte AND $04)>0;

    OniImage_Old.LoadFromTXMP(id);
    data:=OniImage_Old.GetAsBMP;
    mem:=TMemoryStream.Create;
    mem.Write(data[0],Length(data));
    mem.Seek(0,soFromBeginning);
    image_txmppreview.Picture.Bitmap.LoadFromStream(mem);
    mem.Free;

    group_bmpselect.Enabled:=True;
  END;

PROCEDURE TForm7.btn_loadClick(Sender: TObject);
  VAR
    mem:TMemoryStream;
    tempd:Tdata;
  BEGIN
    IF opend.Execute THEN BEGIN
      OniImage_New.LoadFromBMP(opend.FileName);
      tempd:=OniImage_New.GetAsBMP;
      mem:=TMemoryStream.Create;
      mem.Write(tempd[0],Length(tempd));
      mem.Seek(0,soFromBeginning);
      image_bmppreview.Picture.Bitmap.LoadFromStream(mem);
      mem.Free;
      group_options.Enabled:=True;
    END;
  END;

PROCEDURE TForm7.btn_replaceClick(Sender: TObject);
  VAR
    id:LongWord;

    oldsize,newsize:LongWord;
    old_rawaddr,new_rawaddr:LongWord;
    oldfading:Byte;
    tempd:Tdata;

    datbyte:Word;
  BEGIN
    IF list_txmp.ItemIndex>=0 THEN BEGIN
      id:=OniDataConnection.ExtractFileID(list_txmp.Items.Strings[list_txmp.ItemIndex]);
      OniDataConnection.LoadDatFilePart(id,$88,1,@oldfading);
      if OniDataConnection.OSisMac then
        OniDataConnection.UpdateDatFilePart(id,$A0,4,@old_rawaddr)
      else
        OniDataConnection.LoadDatFilePart(id,$9C,4,@old_rawaddr);

      IF (OniImage_Old.Width<>OniImage_New.Width) OR (OniImage_Old.Height<>OniImage_New.Height) THEN BEGIN
        IF MessageBox(Self.Handle,
                    PChar('Current image and new image have different size'+CrLf+
                            '(Current: '+IntToStr(OniImage_Old.Width)+'x'+IntToStr(OniImage_Old.Height)+
                            ' - New: '+IntToStr(OniImage_New.Width)+'x'+IntToStr(OniImage_New.Height)+')'+CrLf+
                            'Replace anyways?'),
                    PChar(list_txmp.Items.Strings[list_txmp.ItemIndex]),
                    MB_YESNO)=IDNO THEN Exit;
      END;

      oldsize:=OniImage_Old.GetImageDataSize((oldfading and $01)>0);

      IF check_fading.Checked THEN
        IF NOT OniImage_New.GetMipMappedImage(tempd) THEN
          IF MessageBox(Self.Handle, PChar('Can not create a MipMapped-image (probably because of a wrong dimension).'+#13+#10+'Do you want to continue without MipMapping?'), PChar('Warning'), MB_YESNO)=ID_YES THEN
            check_fading.Checked:=False
          ELSE
            Exit;

      IF NOT check_fading.Checked THEN
        tempd:=OniImage_New.GetAsData;

      newsize:=OniImage_New.GetImageDataSize(check_fading.Checked);
      ShowMessage(IntToStr(newsize));

      IF (newsize>oldsize) AND (OniDataConnection.Backend=ODB_Dat) THEN
        new_rawaddr:=OniDataConnection.AppendRawFile(OniDataConnection.OSisMac,Length(tempd),tempd)
      ELSE BEGIN
        new_rawaddr:=old_rawaddr;
        OniDataConnection.UpdateRawFile(id,$9C,Length(tempd),tempd);
      END;

      datbyte:=$00;
      IF check_fading.Checked THEN datbyte:=datbyte OR $01;
      OniDataConnection.UpdateDatFilePart(id,$88,1,@datbyte);
      datbyte:=$10;
      IF check_transparency.Checked THEN datbyte:=datbyte OR $04;
      OniDataConnection.UpdateDatFilePart(id,$89,1,@datbyte);
      OniDataConnection.UpdateDatFilePart(id,$8C,2,@OniImage_New.Width);
      OniDataConnection.UpdateDatFilePart(id,$8E,2,@OniImage_New.Height);
      datbyte:=$08;
      OniDataConnection.UpdateDatFilePart(id,$90,1,@datbyte);
      if OniDataConnection.OSisMac then
        OniDataConnection.UpdateDatFilePart(id,$A0,4,@new_rawaddr)
      else
        OniDataConnection.UpdateDatFilePart(id,$9C,4,@new_rawaddr);

      ShowMessage('TXMP-image replaced');
    END;
  END;

PROCEDURE TForm7.FormClose(Sender: TObject; var Action: TCloseAction);
  BEGIN
    OniImage_Old.Free;
    OniImage_New.Free;
    Action:=caFree;
    Form1.close_window(Self.Name);
  END;

PROCEDURE TForm7.FormCreate(Sender: TObject);
  BEGIN
    OniImage_Old:=TOniImage.Create;
    OniImage_New:=TOniImage.Create;
  END;

PROCEDURE TForm7.FormActivate(Sender: TObject);
  BEGIN
    Form1.SetActiveWindow(Self.Name);
  END;

PROCEDURE TForm7.btn_saveClick(Sender: TObject);
  BEGIN
    IF saved.Execute THEN
      OniImage_Old.WriteToBMP(saved.FileName);
  END;

END.
