unit Tool_Extractor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, StrUtils, ComCtrls;

type
  TForm_Extractor = class(TForm)
    group_select: TGroupBox;
    group_extract: TGroupBox;
    group_singlefiles: TGroupBox;
    btn_sel_dat: TButton;
    btn_sel_datraw: TButton;
    btn_sel_datraw_convert: TButton;
    btn_all_dat: TButton;
    btn_all_datraw: TButton;
    btn_all_datraw_convert: TButton;
    group_onefile: TGroupBox;
    btn_sel_files_toone: TButton;
    btn_all_files_toone: TButton;
    group_progress: TGroupBox;
    progress: TProgressBar;
    lbl_progress: TLabel;
    lbl_estimated: TLabel;
    btn_abort: TButton;
    saved: TSaveDialog;
    panel_extension: TPanel;
    lbl_filter: TLabel;
    combo_extension: TComboBox;
    check_zerobyte: TCheckBox;
    edit_filtername: TEdit;
    check_filtername: TCheckBox;
    list: TListBox;
    procedure LoadFileNames;
    procedure check_filternameClick(Sender: TObject);
    procedure check_zerobyteClick(Sender: TObject);
    procedure combo_extensionClick(Sender: TObject);
    procedure panel_extensionResize(Sender: TObject);
    procedure Recreatelist;

    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
    procedure Extract(Sender: TObject);
  private
  public
  end;

var
  Form_Extractor: TForm_Extractor;

implementation

{$R *.dfm}

uses Main, Code_Functions, Data, Code_OniDataClass;




procedure TForm_Extractor.Recreatelist;
var
  i:    LongWord;
  exts: TStringArray;
begin
  combo_extension.Items.Clear;
  combo_extension.Items.Add('_All files_ (' + IntToStr(
    OniDataConnection.GetFilesCount) + ')');
  exts := OniDataConnection.GetExtensionsList;
  for i := 0 to High(exts) do
    combo_extension.Items.Add(exts[i]);
  combo_extension.ItemIndex := 0;
  combo_extensionClick(Self);
end;




procedure TForm_Extractor.LoadFileNames;
var
  Extension: String[4];
  no_zero_bytes: Boolean;
  pattern: String;
  files: TStringArray;
  i: LongWord;
begin
  Extension := MidStr(combo_extension.Items.Strings[combo_extension.ItemIndex], 1, 4);
  no_zero_bytes := not check_zerobyte.Checked;
  pattern := '';
  if check_filtername.Checked then
    pattern := edit_filtername.Text;
  if Extension = '_All' then
    Extension := '';

  files := OniDataConnection.GetFilesList(extension, pattern, no_zero_bytes);
  list.Items.Clear;
  if Length(files) > 0 then
    for i := 0 to High(files) do
      list.Items.Add(files[i]);
end;




procedure TForm_Extractor.panel_extensionResize(Sender: TObject);
begin
  combo_extension.Width := panel_extension.Width - 5;
  edit_filtername.Width := panel_extension.Width - 5;
end;




procedure TForm_Extractor.combo_extensionClick(Sender: TObject);
begin
  LoadFileNames;
end;




procedure TForm_Extractor.check_zerobyteClick(Sender: TObject);
var
  i: Byte;
begin
  LoadFileNames;
end;




procedure TForm_Extractor.check_filternameClick(Sender: TObject);
begin
  edit_filtername.Enabled := not check_filtername.Checked;
  LoadFileNames;
end;




procedure TForm_Extractor.FormResize(Sender: TObject);
begin
  if Self.Width >= 450 then
  begin
  end
  else
    Self.Width := 450;
  if Self.Height >= 400 then
  begin
    group_progress.Height := group_extract.Height - 293;
  end
  else
    Self.Height := 400;
end;




procedure TForm_Extractor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;




procedure TForm_Extractor.FormCreate(Sender: TObject);
begin
  btn_sel_dat.Caption    := 'Selected files' + CrLf + '(dat contents only)';
  btn_sel_datraw.Caption := 'Selected files' + CrLf + '(dat+raw contents)';
  btn_sel_datraw_convert.Caption :=
    'Selected files' + CrLf + '(dat+raw contents)' + CrLf + '(with convert if possible)';
  btn_all_dat.Caption    := 'All files in list' + CrLf + '(dat contents only)';
  btn_all_datraw.Caption := 'All files in list' + CrLf + '(dat+raw contents)';
  btn_all_datraw_convert.Caption :=
    'All files in list' + CrLf + '(dat+raw contents)' + CrLf + '(with convert if possible)';
  btn_sel_files_toone.Caption := 'Selected files' + CrLf + '(dat contents only)';
  btn_all_files_toone.Caption := 'All files in list' + CrLf + '(dat contents only)';
end;




procedure TForm_Extractor.Extract(Sender: TObject);
var
  sel_only:  Boolean;
  dat_only:  Boolean;
  convert:   Boolean;
  one_file:  Boolean;
  settings:  TExportSet;
  files:     LongWord;
  i, done:   LongWord;
  begintime: Double;
begin
  sel_only := Pos('sel', TButton(Sender).Name) > 0;
  dat_only := not (Pos('datraw', TButton(Sender).Name) > 0);
  convert  := Pos('convert', TButton(Sender).Name) > 0;
  one_file := Pos('toone', TButton(Sender).Name) > 0;
  if dat_only then
    settings := [DO_dat]
  else
    settings := [DO_dat, DO_raw];
  if convert then
    settings := settings + [DO_convert];
  if one_file then
    settings := settings + [DO_toone];
  progress.Position := 0;

  if saved.Execute then
  begin
    begintime := Time;
    group_progress.Visible := True;
    group_select.Enabled := False;
    group_singlefiles.Enabled := False;
    group_onefile.Enabled := False;
    lbl_estimated.Caption := 'Estimated finishing time: unknown';
    if one_file then
    begin
      if FileExists(saved.FileName) then
      begin
        if MessageBox(Self.Handle, PChar(
          'File already exists. Do you want to overwrite it?'), PChar('Warning!'), MB_YESNO) =
          ID_YES then
        begin
          DeleteFile(saved.FileName);
        end
        else
        begin
          group_progress.Visible    := False;
          group_select.Enabled      := True;
          group_singlefiles.Enabled := True;
          group_onefile.Enabled     := True;
          Exit;
        end;
      end;
      i := FileCreate(saved.FileName);
      FileClose(i);
      i := 0;
    end;
    if sel_only then
    begin
      files := list.SelCount;
      lbl_progress.Caption := 'Files done: 0/' + IntToStr(files);
      progress.Max := files;
      done  := 0;
      for i := 0 to list.Count - 1 do
      begin
        if list.Selected[i] then
        begin
          if one_file then
          begin
            ExportFile(OniDataConnection.ExtractFileID(
              list.Items.Strings[list.ItemIndex]), ExtractFileName(saved.FileName),
              settings, ExtractFileDir(saved.FileName));
          end
          else
          begin
            ExportFile(OniDataConnection.ExtractFileID(
              list.Items.Strings[list.ItemIndex]), list.Items.Strings[i], settings, 'D:');
          end;
          Inc(done);
        end;
        if ((done mod 10) = 0) and (done >= 50) then
          lbl_estimated.Caption := 'Estimated finishing time: ' + TimeToStr(
            (Time - begintime) / done * files + begintime);
        if (i mod 10) = 0 then
        begin
          progress.Position    := done;
          lbl_progress.Caption := 'Files done: ' + IntToStr(done) + '/' + IntToStr(files);
          Application.ProcessMessages;
        end;
      end;
    end
    else
    begin
      files := list.Count;
      lbl_progress.Caption := 'Files done: 0/' + IntToStr(files);
      progress.Max := files;
      for i := 0 to list.Count - 1 do
      begin
        if one_file then
        begin
          ExportFile(OniDataConnection.ExtractFileID(
            list.Items.Strings[list.ItemIndex]), ExtractFileName(saved.FileName),
            settings, ExtractFileDir(saved.FileName));
        end
        else
        begin
          ExportFile(OniDataConnection.ExtractFileID(
            list.Items.Strings[list.ItemIndex]), list.Items.Strings[i], settings, 'D:');
        end;
        if ((i mod 10) = 0) and (i >= 50) then
          lbl_estimated.Caption := 'Estimated finishing time: ' + TimeToStr(
            (Time - begintime) / i * files + begintime);
        if (i mod 5) = 0 then
        begin
          progress.Position    := i;
          lbl_progress.Caption := 'Files done: ' + IntToStr(i) + '/' + IntToStr(files);
          Application.ProcessMessages;
        end;
      end;
    end;
    group_progress.Visible    := False;
    group_select.Enabled      := True;
    group_singlefiles.Enabled := True;
    group_onefile.Enabled     := True;
  end;
end;

end.
