unit Tool_Preview;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Math, ExtCtrls, StdCtrls, StrUtils, Menus,
  Code_Functions, Data, Code_Exporters, Code_OniImgClass, Code_OniDataClass;

type
  TForm_Preview = class(TForm)
    timer:   TTimer;
    panel_preview: TPanel;
    img:     TImage;
    panel_buttons: TPanel;
    btn_dec: TButton;
    btn_startstop: TButton;
    btn_inc: TButton;
    Splitter1: TSplitter;
    lbl_notpossible: TLabel;
    panel_files: TPanel;
    list:    TListBox;
    panel_extension: TPanel;
    lbl_filter: TLabel;
    combo_extension: TComboBox;
    check_zerobyte: TCheckBox;
    edit_filtername: TEdit;
    check_filtername: TCheckBox;
    procedure LoadFileNames;
    procedure check_filternameClick(Sender: TObject);
    procedure check_zerobyteClick(Sender: TObject);
    procedure combo_extensionClick(Sender: TObject);
    procedure panel_extensionResize(Sender: TObject);
    procedure listClick(Sender: TObject);
    procedure Recreatelist;

    procedure PreviewImage;
    procedure PreviewTXAN;
    procedure btn_incClick(Sender: TObject);
    procedure btn_decClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure btn_startstopClick(Sender: TObject);
    procedure panel_buttonsResize(Sender: TObject);
    procedure timerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

    procedure DrawImage(index: Integer);
    procedure SetBitmapCount(Count: Integer);
    procedure LoadImage(fileid, index: Integer);
    procedure listMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    bitmaps:   array of TBitmap;
    actualimg: Byte;
    _fileid:   LongWord;
  public
  end;

var
  Form_Preview: TForm_Preview;

implementation

{$R *.dfm}

uses Main;




procedure TForm_Preview.Recreatelist;
var
  i:    LongWord;
  exts: TStringArray;
begin
  combo_extension.Items.Clear;
  combo_extension.Items.Add('_All files_ (' +
    IntToStr(OniDataConnection.GetFilesCount) + ')');
  exts := OniDataConnection.GetExtensionsList;
  for i := 0 to High(exts) do
    combo_extension.Items.Add(exts[i]);
  combo_extension.ItemIndex := 0;
  combo_extensionClick(Self);
end;




procedure TForm_Preview.LoadFileNames;
var
  Extension: String[4];
  no_zero_bytes: Boolean;
  pattern: String;
  files: TStringArray;
  i: LongWord;
begin
  Extension := MidStr(combo_extension.Items.Strings[combo_extension.ItemIndex], 1, 4);
  no_zero_bytes := not check_zerobyte.Checked;
  pattern := '';
  if check_filtername.Checked then
    pattern := edit_filtername.Text;
  if Extension = '_All' then
    Extension := '';

  files := OniDataConnection.GetFilesList(extension, pattern, no_zero_bytes);
  list.Items.Clear;
  if Length(files) > 0 then
    for i := 0 to High(files) do
      list.Items.Add(files[i]);
end;




procedure TForm_Preview.LoadImage(fileid, index: Integer);
var
  Data:      Tdata;
  memstream: TMemoryStream;
  OniImage:  TOniImage;

begin
  OniImage := TOniImage.Create;
  OniImage.Load(fileid);
  Data := OniImage.GetAsBMP;
  OniImage.Free;

  memstream := TMemoryStream.Create;
  memstream.Write(Data[0], Length(Data));
  memstream.Seek(0, soFromBeginning);
  bitmaps[index].LoadFromStream(memstream);
  memstream.Free;
end;




procedure TForm_Preview.combo_extensionClick(Sender: TObject);
begin
  LoadFileNames;
end;



procedure TForm_Preview.DrawImage(index: Integer);
begin
  BitBlt(img.Canvas.Handle, 0, 0, img.Width, img.Height,
    bitmaps[index].Canvas.Handle, 0, 0, WHITENESS);
  BitBlt(img.Canvas.Handle, 0, 0, bitmaps[index].Width, bitmaps[index].Height,
    bitmaps[index].Canvas.Handle, 0, 0, SRCCOPY);
  img.Invalidate;
end;




procedure TForm_Preview.SetBitmapCount(Count: Integer);
var
  i: Integer;
begin
  if Length(bitmaps) > Count then
  begin
    for i := Count to High(bitmaps) do
      bitmaps[i].Free;
    SetLength(bitmaps, Count);
  end;
  if Length(bitmaps) < Count then
  begin
    i := Length(bitmaps);
    SetLength(bitmaps, Count);
    for i := i to High(bitmaps) do
      bitmaps[i] := TBitmap.Create;
  end;
end;




procedure TForm_Preview.check_zerobyteClick(Sender: TObject);
begin
  LoadFileNames;
end;




procedure TForm_Preview.check_filternameClick(Sender: TObject);
begin
  edit_filtername.Enabled := not check_filtername.Checked;
  LoadFileNames;
end;




procedure TForm_Preview.listClick(Sender: TObject);
var
  ext: String;
begin
  _fileid := OniDataConnection.ExtractFileID(list.Items.Strings[list.ItemIndex]);
  lbl_notpossible.Visible := False;
  Self.img.Visible := True;
  Self.timer.Enabled := False;
  Self.panel_buttons.Visible := False;
  ext     := RightStr(list.Items.Strings[list.ItemIndex], 4);
  if (ext = 'PSpc') or (ext = 'TXMB') or (ext = 'TXMP') then
    PreviewImage
  else if ext = 'TXAN' then
    PreviewTXAN
  else
  begin
    Self.lbl_notpossible.Visible := True;
    Self.img.Visible := False;
  end;
end;




procedure TForm_Preview.listMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  pt: TPoint;
begin
  pt.X := x;
  pt.Y := y;
  list.ItemIndex := list.ItemAtPos(pt, true);
  if list.ItemIndex > -1 then
    Self.listClick(Self);
end;

procedure TForm_Preview.PreviewImage;
begin
  SetBitmapCount(1);
  LoadImage(_fileid, 0);
  DrawImage(0);
end;




procedure TForm_Preview.PreviewTXAN;
var
  loop_speed: Word;
  linkcount: LongWord;
  link: LongWord;
  i:    Byte;
begin
  OniDataConnection.LoadDatFilePart(_fileid, $14, SizeOf(loop_speed), @loop_speed);
  OniDataConnection.LoadDatFilePart(_fileid, $1C, SizeOf(linkcount), @linkcount);
  SetBitmapCount(linkcount);
  for i := 0 to linkcount - 1 do
  begin
    OniDataConnection.LoadDatFilePart(_fileid, $20 + i * 4, SizeOf(link), @link);
    link := link div 256;
    if link = 0 then
      link := _fileid - 1;
    LoadImage(link, i);
  end;
  actualimg := 254;
  Self.timer.Interval := Floor(loop_speed * (1 / 60) * 1000);
  Self.timer.Enabled := False;
  Self.btn_startstopClick(Self);
  Self.panel_buttons.Visible := True;
end;




procedure TForm_Preview.timerTimer(Sender: TObject);
begin
  btn_incClick(Self);
end;




procedure TForm_Preview.btn_startstopClick(Sender: TObject);
begin
  Self.timer.Enabled   := not Self.timer.Enabled;
  Self.btn_dec.Enabled := not Self.timer.Enabled;
  Self.btn_inc.Enabled := not Self.timer.Enabled;
  if Self.timer.Enabled then
    Self.btn_startstop.Caption := 'Stop automatic'
  else
    Self.btn_startstop.Caption := 'Start automatic';
end;




procedure TForm_Preview.btn_decClick(Sender: TObject);
begin
  if actualimg > 0 then
    Dec(actualimg)
  else
    actualimg := High(bitmaps);
  Self.Caption := 'Preview ' + OniDataConnection.GetFileInfo(_fileid).FileName +
    ' (' + IntToStr(actualimg + 1) + '/' + IntToStr(Length(bitmaps)) + ')';
  DrawImage(actualimg);
end;




procedure TForm_Preview.btn_incClick(Sender: TObject);
begin
  if actualimg < High(bitmaps) then
    Inc(actualimg)
  else
    actualimg := 0;
  Self.Caption := 'Preview ' + OniDataConnection.GetFileInfo(_fileid).FileName +
    ' (' + IntToStr(actualimg + 1) + '/' + IntToStr(Length(bitmaps)) + ')';
  DrawImage(actualimg);
end;




procedure TForm_Preview.panel_buttonsResize(Sender: TObject);
begin
  btn_startstop.Width := panel_buttons.Width - 45;
  btn_inc.Left := panel_buttons.Width - 23;
end;




procedure TForm_Preview.panel_extensionResize(Sender: TObject);
begin
  combo_extension.Width := panel_extension.Width - 5;
  edit_filtername.Width := panel_extension.Width - 5;
end;




procedure TForm_Preview.FormResize(Sender: TObject);
begin
  if Self.Width < 300 then
    Self.Width := 300;
  if Self.Height < 200 then
    Self.Height := 200;
end;




procedure TForm_Preview.FormCreate(Sender: TObject);
begin
  SetLength(bitmaps, 0);
  Self.Width  := 260;
  Self.Height := 300;
end;




procedure TForm_Preview.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

end.
