#pragma once
#ifndef ONI_CHARACTER_H
#define ONI_CHARACTER_H

#include "Daodan.h"
#include <stdint.h>

typedef struct {
	float X;
	float Y;
	float Z;	
} Vector3; //probably move to utilities...

typedef struct {
	int Type;				//'CHAR' etc.
	int ObjectId;			//not needed
	int Flags;				//The flags of the object...not used for CHAR
	Vector3 Position;		//Position of Object
	Vector3 Rotation;		//Rotation of Object
	int EditorCallbacks;	//Lets try not to mess with it for now. :P
	int field_28;			//unknown
} OSD_Header;

typedef struct {
	uint32_t Options;				//A bitset. Someone had better define these
	char Class[64];					//Name of the ONCC we use. ONCCName in idb
	char Name[32];					//Name of the character. ie: ai2_spawn Muro
	char Weapon[64];				//Name of the weapon he holds. ONWCName in idb
	char ScriptSpawn[32];			//Script function called when char spawns
	char ScriptDie[32];				//Script function called when char dies
	char ScriptAware[32];			//Script function called when char detects something
	char ScriptAlarm[32];			//Script function called when char is alarmed at something
	char ScriptHurt[32];			//Script function called when char is hurt for the first time
	char ScriptDefeat[32];			//Script function called when char is at 1 HP
	char ScriptNoPath[32];			//Script function called when char loses path. Broken.
	char ScriptNoAmmo[32];			//Script function called when char is out of ammo for the first time. Char must have ammo at spawn.
	int32_t AdditionalHealth;		//Additional Health given to the character
	int16_t AmmoUsed;				//Ammo given for the char to use
	int16_t AmmoDropped;			//Ammo the char drops
	int16_t CellsUsed;				//Cells given for the char to use
	int16_t CellsDropped;			//Cells the char drops
	int16_t HypoUsed;				//Hypo given for the char to use
	int16_t HypoDropped;			//Hypo the char drops
	int16_t ShieldUsed;				//Bullet shield given for the char to use
	int16_t ShieldDropped;			//Bullet shield the char drops
	int16_t CloakUsed;				//Phase Cloak given for the char to use
	int16_t CloakDropped;			//Phase Cloak the char drops
	int16_t NCIUsed;				//Don't use this...
	int16_t NCIDropped;				//Don't use this...
	int32_t TeamID;					//Team ID
	int32_t AmmoPercent;			//Percent of weapon ammo full
	int32_t JobID;					//Job ID...
									//0 - none 
									//1 - idle 
									//2 - guard (never used in Oni) 
									//3 - patrol 
									//4 - teambattle (never used in Oni)
	int16_t PatrolID;				//patrol path ID (reference to the Patrol_Path.BINA file)
	int16_t CombatID;				//combat ID (reference to the Combat.BINA file)
	int16_t	MeleeID;				//melee ID (reference to the Melee Profile.BINA file)
	int16_t NeutralID;				//neutral ID (reference to the Neutral.BINA file)
	int32_t	AlarmGroups;			//Bitset. http://wiki.oni2.net/CHAR
	int32_t InitialAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t MinimalAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t StartJobAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t InvestigatingAlertLevel;//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t PursuitStrongLow;
	int32_t PursuitWeakLow;
	int32_t PursuitStrongHigh;
	int32_t PursuitWeakHigh;
	int32_t Pursuit5;
	int32_t field_1FC;
} CharacterOSD;

typedef struct {
	OSD_Header Header;
	CharacterOSD OSD;
} CharacterObject;

enum {
	team_konoko,
	team_tctf,
	team_syndicate,
	team_neutral,
	team_securityguard,
	team_rougekonoko,
	team_switzerland,
	team_syndicateaccessory,
};


int	chr_isplayer			=		0x00000001;	//is player character
int	chr_randomskin			=		0x00000002;	//gets random skin from ONCV
int	chr_notprespawned		=		0x00000004;	//isn't spawned at level creation
int	chr_noncombatant		=		0x00000008;	//doesn't fight
int	chr_multispawnable		=		0x00000010;	//can spawn up to 5 without forcing
int	chr_unknown				=		0x00000020;	//
int	chr_unkillable			=		0x00000040;	//can only be brought to 1 hp
int	chr_superammo			=		0x00000080;	//infinite ammo
int	chr_omniscient			=		0x00000100;	//touchofdeath
int	chr_haslsi				=		0x00000200;	//drops an lsi
int	chr_boss				=		0x00000400;	//is a boss character
int	chr_upgradedifficulty	=		0x00000800;	//upgrade the difficulty if you play on med\hard
int	chr_noautodrop			=		0x00001000;	//uses drop fields instead of has fields on death

int16_t ONICALL ONrGameState_NewCharacter(CharacterObject* CHAR, void* AISA, void* flag, int* list_location);

#endif
