#pragma once
#ifndef ONI_CHARACTER_H
#define ONI_CHARACTER_H

#include "Daodan.h"
#include <stdint.h>
#include <stdbool.h>

typedef struct {
	float X;
	float Y;
	float Z;	
} Vector3; //probably move to utilities...

typedef struct {
	float X;
	float Y;
	float Z;
	float W;
} Quaternion;

typedef struct {
	float RotationScale[9];
	Vector3 Translation;
} Matrix4x3;

typedef struct {
	Vector3 Center;
	float Radius;
} Sphere;

typedef struct {
	Sphere Sphere_; //fix this name
	int Child1;
	int Child2;	
} SphereTreeNode;

typedef struct {
	Vector3 Min;
	Vector3 Max;
} BoundingBox;


enum { //action flags
	Action_Escape                    = 1,
	Action_Console                   = 2,
	Action_PauseScreen               = 4,
	Action_Cutscene_1                = 8,
	Action_Cutscene_2                = 0x10,
	Action_F4                        = 0x20,
	Action_F5                        = 0x40,
	Action_F6                        = 0x80,
	Action_F7                        = 0x100,
	Action_F8                        = 0x200,
	Action_StartRecord               = 0x400,
	Action_StopRecord                = 0x800,
	Action_PlayRecord                = 0x1000,
	Action_F12                       = 0x2000,
	Action_Unknown1                  = 0x4000,
	Action_LookMode                  = 0x8000,
	Action_Screenshot                = 0x10000,
	Action_Unknown2                  = 0x20000,
	Action_Unknown3                  = 0x40000,
	Action_Unknown4                  = 0x80000,
	Action_Unknown5                  = 0x100000,
	Action_Forward                   = 0x200000,
	Action_Backward                  = 0x400000,
	Action_TurnLeft                  = 0x800000,
	Action_TurnRight                 = 0x1000000,
	Action_StepLeft                  = 0x2000000,
	Action_StepRight                 = 0x4000000,
	Action_Jump                      = 0x8000000,
	Action_Crouch                    = 0x10000000,
	Action_Punch                     = 0x20000000,
	Action_Kick                      = 0x40000000,
	Action_Block                     = 0x80000000,
	//used in second action field
	Action2_Walk                     = 1,
	Action2_Action                   = 2,
	Action2_Hypo                     = 4,
	Action2_Reload                   = 8,
	Action2_Swap                     = 0x10,
	Action2_Drop                     = 0x20,
	Action2_Fire1                    = 0x40,
	Action2_Fire2                    = 0x80,
	Action2_Fire3                    = 0x100,
};


typedef struct {
	int32_t Actions1;
	int32_t Actions2;
} InputAction;


typedef struct {
	float MouseDeltaX;
	float MouseDeltaY;
	float field_8;
	float field_C;
	InputAction Current;
	InputAction Stopped;
	InputAction Start;
	InputAction Stop;
} GameInput;

typedef struct {
	int Type;				//'CHAR' etc.
	int ObjectId;			//not needed
	int Flags;				//The flags of the object...not used for CHAR
	Vector3 Position;		//Position of Object
	Vector3 Rotation;		//Rotation of Object
	int EditorCallbacks;	//Lets try not to mess with it for now. :P
	int field_28;			//unknown
} OSD_Header;

typedef struct {
	int32_t Flags;
	int32_t Frame;
	int32_t field_8;
	int32_t field_C;
	int32_t field_10;
	int32_t field_14;
	int32_t field_18;
	int32_t field_1C;
	int32_t FILMInstance;
} PlayingFilm;

typedef struct {
	uint32_t Options;				//A bitset. Someone had better define these
	char Class[64];					//Name of the ONCC we use. ONCCName in idb
	char Name[32];					//Name of the character. ie: ai2_spawn Muro
	char Weapon[64];				//Name of the weapon he holds. ONWCName in idb
	char ScriptSpawn[32];			//Script function called when char spawns
	char ScriptDie[32];				//Script function called when char dies
	char ScriptAware[32];			//Script function called when char detects something
	char ScriptAlarm[32];			//Script function called when char is alarmed at something
	char ScriptHurt[32];			//Script function called when char is hurt for the first time
	char ScriptDefeat[32];			//Script function called when char is at 1 HP
	char ScriptNoPath[32];			//Script function called when char loses path. Broken.
	char ScriptNoAmmo[32];			//Script function called when char is out of ammo for the first time. Char must have ammo at spawn.
	int32_t AdditionalHealth;		//Additional Health given to the character
	int16_t AmmoUsed;				//Ammo given for the char to use
	int16_t AmmoDropped;			//Ammo the char drops
	int16_t CellsUsed;				//Cells given for the char to use
	int16_t CellsDropped;			//Cells the char drops
	int16_t HypoUsed;				//Hypo given for the char to use
	int16_t HypoDropped;			//Hypo the char drops
	int16_t ShieldUsed;				//Bullet shield given for the char to use
	int16_t ShieldDropped;			//Bullet shield the char drops
	int16_t CloakUsed;				//Phase Cloak given for the char to use
	int16_t CloakDropped;			//Phase Cloak the char drops
	int16_t NCIUsed;				//Don't use this...
	int16_t NCIDropped;				//Don't use this...
	int32_t TeamID;					//Team ID
	int32_t AmmoPercent;			//Percent of weapon ammo full
	int32_t JobID;					//Job ID...
									//0 - none 
									//1 - idle 
									//2 - guard (never used in Oni) 
									//3 - patrol 
									//4 - teambattle (never used in Oni)
	int16_t PatrolID;				//patrol path ID (reference to the Patrol_Path.BINA file)
	int16_t CombatID;				//combat ID (reference to the Combat.BINA file)
	int16_t	MeleeID;				//melee ID (reference to the Melee Profile.BINA file)
	int16_t NeutralID;				//neutral ID (reference to the Neutral.BINA file)
	int32_t	AlarmGroups;			//Bitset. http://wiki.oni2.net/CHAR
	int32_t InitialAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t MinimalAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t StartJobAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t InvestigatingAlertLevel;//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t PursuitStrongLow;
	int32_t PursuitWeakLow;
	int32_t PursuitStrongHigh;
	int32_t PursuitWeakHigh;
	int32_t Pursuit5;
	int32_t field_1FC;
} CharacterOSD;

typedef struct {
	OSD_Header Header;
	CharacterOSD OSD;
} CharacterObject;

typedef struct {
	Vector3 Center;
	float Radius;
} BoundingSphere;

typedef struct {
	int32_t ONCP; //probably pointer
	int32_t field_4;	//who knows?
	int32_t Instance; //probably link to actual particle
	int32_t Bone; //duh
} AttachedParticle;

typedef struct { //Inventory
	int32_t Weapons[3];
	int16_t field_1A0; //10 bucks says this is the current weapon
	int16_t AmmoUsed;				//Ammo given for the char to use
	int16_t HypoUsed;				//Hypo given for the char to use
	int16_t CellsUsed;				//Cells given for the char to use
	int16_t AmmoDropped;			//Ammo the char drops
	int16_t HypoDropped;			//Hypo the char drops
	int16_t CellsDropped;			//Cells the char drops
	int16_t field_1A;	//who knows? InverseHypoRegenRate?
	int16_t field_1C;	
	int16_t field_1E;
	int16_t hasLSI;
	int16_t	field_1B6;
	int16_t ShieldUsed;				//Bullet shield given for the char to use
	int16_t CloakUsed;				//Phase Cloak given for the char to use
	int16_t field_28;			//probably bullet shield dropped
	int16_t DoorKeys;		//Lol. We can use this later for other sorts of items.
} Inventory;

typedef struct { //ActiveCharacter
	int16_t Number;
	int16_t field_2; //probably Number is an int32
	int32_t PhyContext;
	SphereTreeNode SphereTree1;		//probably SphereTree[7]...
	SphereTreeNode SphereTree3[4];
	SphereTreeNode SphereTree2[2];
	int16_t field_B0;
	int16_t field_B2;
	int16_t field_B4;
	int16_t field_B6;
	Vector3 field_B8;
	Vector3 AccelerateWith;
	int16_t field_D0;
	Vector3 field_D4;
	int32_t field_E0;
	int32_t field_E4;
	int32_t field_E8;
	int32_t field_EC;
	int32_t field_F0;
	int32_t field_F4;
	int16_t IsInAir;
	Vector3 FallingVelocity;
	Vector3 JumpVelocity;
	int16_t field_110;
	int16_t field_112;
	int32_t field_114;
	int32_t field_118;
	int32_t field_11C;
	int32_t field_120;
	int32_t field_124;
	int32_t field_128;
	int32_t field_12C;
	BoundingSphere BoundingSphere_; //fix this name
	Vector3 field_140;
	Vector3 field_14C;
	int32_t field_158;
	int32_t field_15C;
	Vector3 Location;
	int32_t field_16C[6]; //16C-184 ???
	int32_t AkiraNode;
	int32_t GraphNode;
	int32_t PelvisHeight;
	int32_t MovementStatePtr;
	int32_t ActiveWeapon;		//NOTE: FIGURE OUT THIS MESS OF INVENTORY...
	int32_t field_198;		//maybe weap 3, maybe not...
	int32_t InventoryWeapon;
	int16_t field_1A0;	//unused?
	int16_t AmmoUsable;				//Ammo given for the char to use
	int16_t HypoUsable;				//Hypo given for the char to use
	int16_t CellsUsable;				//Cells given for the char to use
	int16_t AmmoDropped;			//Ammo the char drops
	int16_t HypoDropped;			//Hypo the char drops
	int16_t CellsDropped;			//Cells the char drops
	int16_t field_1AE;	
	int16_t InverseHypoRegenRate;
	int16_t ShieldDropped;
	int16_t CloakDropped;
	int16_t field_1B4;
	int16_t field_1B6;
	int16_t ShieldUsable;
	int16_t CloakUsable;
	int16_t field_1BC[9]; //1BC-1E0
	int32_t NotIdleStartTime;
	int32_t TimeToIdle;
	int32_t field_1E8[1315]; //1E8-1648 what the hell is all this?
	BoundingBox BoundingBox_; //fix this name
	int32_t field_1660;
	int32_t field_1664;
	int32_t ShieldPower; //Same as Boss Shield Power???
	int32_t field_166C;
	int32_t NumberOfKills; //^_^
	int32_t InflictedDamage; //^_^
	int32_t field_1678[260];	//1678-1A88 more wtf
	int32_t field_1A88; //here starts animation junk? It was 4 bools in idb O_o
	int32_t Executor_AimingDirection; //possibly throw junk?
	int32_t field_1A98;
	int32_t field_1A9C;
	int32_t Executor_ActualMovementMode;
	int32_t field_1AA4;
	int32_t field_1AA8;
	int32_t field_1AAC;
	int32_t Executor_HasFacingOverride; //a bool...
	float	Executor_AimingSpeed; 
	bool	field_1AB8; //actually a bitset...
	bool	Executor_HasMoveOverride;
	int16_t	field_1ABA;
	int32_t	field_1ABC;
	int32_t	field_1AC0;
	int32_t	field_1AC4;
	int32_t	Executor_FacingOverride;
	int32_t	Executor_HasAttackOverride; //another bool :P
	int32_t	field_1AD0;
	int32_t	field_1AD4;
	int32_t	field_1AD8;
	int32_t	field_1ADC;
	int32_t	field_1AE0;
	int32_t	field_1AE4;
	int32_t	Executor_HasThrowOverride; //another another bool
	int32_t	field_1AEC;
	int32_t	field_1AF0;
	int32_t	field_1AF4;
	int32_t Animation;
	int16_t AnimationToState;
	int16_t AnimationFromState;
	int16_t AnimationType;
	int16_t NextAnimationType;
	int16_t	field_1B04;
	int16_t	field_1B06;
	int32_t Stitch; //bool
	float StitchHeight;
	int16_t InterpolationFromState;
	int16_t field_1B12;
	Vector3 StitchVelocity;
	int16_t InterpolationCurrentFrame;
	int16_t InterpolationLength;
	Quaternion InterpolationStartRotations[19];
	int32_t field_1C54;
	int32_t field_1C58;
	int32_t field_1C5C;
	int32_t field_1C60;
	int32_t Overlay;
	int32_t field_1C68;
	int32_t field_1C6C;
	int32_t field_1C70;
	int32_t field_1C74;
	int32_t field_1C78;
	int32_t field_1C7C;
	int32_t field_1C80;
	int32_t field_1C84;
	int16_t Frame;
	int16_t SoftPause;
	int16_t HardPause;
	int16_t field1C8E;
	int32_t field1C90;
	int16_t field1C94;
	int16_t field1C96;
	int16_t Dizzy;
	int16_t field1C9A;
	int32_t field1C9C;
	int16_t AnimationVarient;
	int16_t TimeToPeace;
	int16_t NumAnimationAttachedParticles;
	int16_t field_1CA6; //spacing
	AttachedParticle AnimationAttachedParticles[16];
	int32_t TRAMParticles;
	bool FixedParticlesAttached;
	bool FixedParticlesStarted;
	int16_t NumFixedParticles;
	AttachedParticle FixedParticles[16];
	int16_t CurrentAnimationType;
	int16_t field_1EB2; //spacing
	int32_t field_1EB4;
	int32_t field_1EB8;
	int32_t field_1EBC;
	int32_t field_1EC0;
	int32_t field_1EC4;
	int32_t field_1EC8;
	int32_t field_1ED0;
	int32_t field_1ED4;
	int32_t field_1ED8;
	int32_t field_1EE0;
	int32_t field_1EE4;
	int32_t field_1EE8;
	Quaternion Rotations[19];
	Quaternion OverlayRotations[19];
	int32_t field_2150;
	int32_t field_2154;
	GameInput Input;
	InputAction PreviousActions;
	int32_t SprintTimer;
	int32_t field_2194;
	Vector3 field_2198;
	int32_t field_21A4;
	int32_t field_21A8;
	int32_t field_21AC;
	Vector3 field_21B0;
	float HeadFacing;
	float HeadPitch;
	int32_t field_21C4;
	int32_t field_21C8;
	int32_t field_21D0;
	int32_t field_21D4;
	bool field_21D8;
	bool field_21D9;
	bool field_21DA;
	bool field_21DB;
	bool field_21DC;
	bool field_21DD;
	bool field_21DE;
	bool field_21DF;
	bool field_21E0;
	bool HasAlternateTrigger;
	bool field_21E2;
	bool ReleaseTrigger;
	bool ReleaseAlternateTrigger;
	bool TurningLeft;
	bool TurningRight;
	bool field_21E7;
	int32_t field_21E8;
	int32_t field_21EC;
	int32_t field_21F0;
	PlayingFilm PlayingFilm_; //fix this name
	int32_t field_2218[24]; //2218-2278
	Matrix4x3 BoneMatrices[19];
	Matrix4x3 WeaponMatrix;
	int32_t field_2638[113]; //2638-27FC
	int16_t ShadowIndex;
	int16_t field_27FE;
	int16_t field_2780;
	bool ShieldParts[19]; 
	bool field_2815; //padding...
	bool field_2816;
	bool field_2817;
	int32_t field_2818[8];
} ActiveCharacter;


typedef struct { //Character
	int16_t Number;
	int16_t ActiveCharacterIndex;
	int32_t Flags;
	int16_t field_8;
	int32_t ONCC;			//change type to ONCC when we get that far...
	int32_t field_10;
	int16_t Team;
	char Name[32];
	float BodySize;
	int32_t Health;
	int32_t MaxHealth;
	int32_t ASIA_ID; //might be 16 with 2 byte padding
	int32_t field_44;
	char ScriptSpawn[32];			//Script function called when char spawns
	char ScriptDie[32];				//Script function called when char dies
	char ScriptAware[32];			//Script function called when char detects something
	char ScriptAlarm[32];			//Script function called when char is alarmed at something
	char ScriptHurt[32];			//Script function called when char is hurt for the first time
	char ScriptDefeat[32];			//Script function called when char is at 1 HP
	char ScriptNoAmmo[32];			//Script function called when char is out of ammo for the first time. Char must have ammo at spawn.
	char ScriptNoPath[32];			//Script function called when char loses path. Broken.
	Vector3 Position;
	Vector3 LastPosition;
	Vector3 Location;
	float Facing;
	float DesiredFacing;
	float CosmeticFacing;
	float field_178;
	float field_17C;
	float field_180;
	int32_t BNV;
	int32_t GraphNode;
	float PelvisHeight;
	float field_190;
	Inventory Inventory_; //is there a better way to do this?
	Vector3 Velocity;
	int32_t field_1D0;
	int32_t field_1D4;
	int32_t field_1D8;
	int32_t field_1DC;
	int32_t field_1E0;
	int32_t IdleDelay;
	int32_t field_1E8;
	int32_t field_1EzC;
	int32_t CombatFlags;
	int32_t JobId;
	int32_t Goal;
	int32_t field_1FC;
	int32_t field_200;
	int32_t field_204;
	int32_t field_208[107]; //its all undocumented through here
	int32_t CombatState;	//I think....
	int32_t field_8BB; 
	int32_t PatrolPathOSD[10];	//actually another struct. Not needed atm.
	int32_t PatrolPathPoints[5][64]; //64 of another struct 
	int32_t field_DE8[98];	//DE8-F70
	int32_t CombatStatePtr;
	int32_t KnowledgeState[4]; //Another struct
	int32_t field_F84;
	int32_t AlertDecayTimer;
	int32_t field_F8C;
	int32_t field_F90;
	int32_t InitialAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t MinimalAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t StartJobAlertLevel;		//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t InvestigatingAlertLevel;//0 - lull, 1 - low, 2 - medium, 3 - high, 4 - combat
	int32_t StartleTime;
	int32_t field_FA8;
	int32_t field_FAC;
	int32_t field_FB0;
	int32_t PursuitStrongLow;
	int32_t PursuitWeakLow;
	int32_t PursuitStrongHigh;
	int32_t PursuitWeakHigh;
	int32_t Pursuit5;
	int32_t field_FC8[16];
	int32_t AlarmGroups; //a bitset
	int32_t field_FDC[16]; //FDC-F68
	int32_t	field_F68;
	int32_t DazeTimer;
	int32_t field_1024[16]; //1024-1064
	int32_t MeleePtr; //probably MELE. Looks somewhat important.
	int32_t field_106C[270]; //106C-14A4 skipping lots of junk and a little pathfinding stuff that we might want later.
	int32_t MovementModifiers; //hopefully sprinting, pistol, rifle, etc.
	int32_t field_14B4[101]; //14B4-1648 Glossing over a few other things we don't need having to do with AI direction.
	int32_t BossShieldPower;	//a multiplier? or just a flag? who knows
	int32_t field_1668[6];
	int32_t CurrentConsoleActionMarker; //not sure.
	int32_t field_1684[7]; // done. hopefully i didnt screw this up somewhere.
} Character;

enum {
	team_konoko,
	team_tctf,
	team_syndicate,
	team_neutral,
	team_securityguard,
	team_rougekonoko,
	team_switzerland,
	team_syndicateaccessory,
};


int	chr_isplayer			=		0x00000001;	//is player character
int	chr_randomskin			=		0x00000002;	//gets random skin from ONCV
int	chr_notprespawned		=		0x00000004;	//isn't spawned at level creation
int	chr_noncombatant		=		0x00000008;	//doesn't fight
int	chr_multispawnable		=		0x00000010;	//can spawn up to 5 without forcing
int	chr_unknown				=		0x00000020;	//
int	chr_unkillable			=		0x00000040;	//can only be brought to 1 hp
int	chr_superammo			=		0x00000080;	//infinite ammo
int	chr_omniscient			=		0x00000100;	//touchofdeath
int	chr_haslsi				=		0x00000200;	//drops an lsi
int	chr_boss				=		0x00000400;	//is a boss character
int	chr_upgradedifficulty	=		0x00000800;	//upgrade the difficulty if you play on med\hard
int	chr_noautodrop			=		0x00001000;	//uses drop fields instead of has fields on death

int16_t ONICALL ONrGameState_NewCharacter(CharacterObject* CHAR, void* AISA, void* flag, int* list_location);
//int16_t ONICALL ONrGameState_GetPlayerCharacter();


#endif
